# pyOCD debugger
# Copyright (c) 2017 NXP
# Copyright (c) 2018,2020 Arm Limited
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile
from ..family.target_imxrt import IMXRT

FLASH_ALGO_QUADSPI = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x60014962, 0x60414962, 0x46022301, 0x21077303,
    0x71913240, 0x65010599, 0x73412103, 0x71137381, 0x74412100, 0x740173c1, 0x77018241, 0x64012110,
    0x71512104, 0x4601018a, 0x318131ff, 0x0112640a, 0x0112644a, 0x21ff650a, 0x540b31c9, 0x4a514601,
    0x600a3180, 0x604a4a50, 0x610a4a50, 0x630a4a50, 0x4a5030ff, 0x61023001, 0x61424a4f, 0x3a124a4d,
    0x494c650a, 0x600131a6, 0xb5704770, 0x8901484b, 0x00490849, 0x494a8101, 0x0852890a, 0x810a0052,
    0x23048802, 0x2a000752, 0x8802da02, 0x8002439a, 0x07408808, 0x8808d502, 0x80084398, 0x49414842,
    0x49426041, 0x68016081, 0x43912280, 0x43112220, 0x493f6001, 0x62c82011, 0x6941483e, 0xd52003c9,
    0x21004a3c, 0x60513280, 0x8f4ff3bf, 0x23016941, 0x4399041b, 0xf3bf6141, 0x68108f4f, 0x01014c36,
    0x04c00c49, 0x05ca0d83, 0x0c924618, 0x43150785, 0x1e406365, 0x1e49d2fa, 0xf3bfd2f5, 0xf3bf8f4f,
    0x482e8f6f, 0x02492101, 0xf0004448, 0x482bf8a3, 0xf7ff4448, 0x4929ff6d, 0x44492000, 0xf850f000,
    0x2000bd70, 0x49254770, 0x2301b510, 0x059b2200, 0x46104449, 0xf853f000, 0xd0002800, 0xbd102001,
    0x07492105, 0x491d1842, 0x2301b510, 0x4449031b, 0xf0002000, 0x2800f844, 0x2001d000, 0x2105bd10,
    0x07494613, 0x49151842, 0x4449b510, 0xf0002000, 0x2800f82d, 0x2001d000, 0x0000bd10, 0x42464346,
    0x56010400, 0x0a1804eb, 0x26043206, 0x24010405, 0x00000406, 0x08180432, 0x00002204, 0x400b8000,
    0x400d0000, 0xd928c520, 0x400bc000, 0x0000ffff, 0x401f8140, 0xe000ed00, 0xe000ef40, 0x00000004,
    0x05522201, 0x691269d2, 0x47106852, 0x2401b430, 0x69e40564, 0x68a46924, 0xbc3046a4, 0xb4304760,
    0x05642401, 0x692469e4, 0x46a46924, 0x4760bc30, 0x47184b08, 0x3bb44b07, 0x22014718, 0x69d20552,
    0x69d26912, 0x21014710, 0x69c90549, 0x69896909, 0x00004708, 0x0021055d, 0xc004e001, 0x29041f09,
    0x078bd2fb, 0x8002d501, 0x07c91c80, 0x7002d000, 0x29004770, 0x07c3d00b, 0x7002d002, 0x1e491c40,
    0xd3042902, 0xd5020783, 0x1c808002, 0xe7e31e89, 0xe7ee2200, 0xe7df2200, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x200000ab,
    'pc_unInit': 0x20000163,
    'pc_program_page': 0x2000019f,
    'pc_erase_sector': 0x20000181,
    'pc_eraseAll': 0x20000167,

    'static_base' : 0x20000000 + 0x00000020 + 0x00000278,
    'begin_stack' : 0x20000700,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x100,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x20001000, 0x20001100],   # Enable double buffering
    'min_program_length' : 0x100,
}

class MIMXRT1024xxxxx(IMXRT):

    VENDOR = "NXP"

    memoryMap = MemoryMap(
        RamRegion(name="itcm",      start=0x00000000, length=0x10000), # 64 KB
        RamRegion(name="dtcm",      start=0x20000000, length=0x10000), # 64 KB
        RamRegion(name="ocram",     start=0x20200000, length=0x20000), # 128 KB
        FlashRegion(name="flexspi", start=0x60000000, length=0x400000, blocksize=0x1000, is_boot_memory=True,
            algo=FLASH_ALGO_QUADSPI, page_size=0x100),
        RamRegion(name="semc",      start=0x80000000, length=0x1e00000, is_external=True), # external sdram
        RamRegion(name="NCACHE_REGION",      start=0x81e00000, length=0x200000, is_external=True)
    )

    def __init__(self, link):
        super(MIMXRT1024xxxxx, self).__init__(link, self.memoryMap)
        self._svd_location = SVDFile.from_builtin("MIMXRT1024.xml")
