/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.Iterator;
import java.util.List;
import org.apache.turbine.util.Log;
import org.chefproject.core.ContentCollectionEdit;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.User;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InconsistentException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.PortalService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;

public class Dropbox {
    public static final String COLLECTION_DROPBOX = "/group-user/";
    protected static final String PROP_MEMBER_DROPBOX_DESCRIPTION = "Use this folder to store private files you wish to share only with organizers of this worksite.";
    protected static final String PROP_SITE_DROPBOX_DESCRIPTION = "Use this folder to store private files you wish to share only with individual members of this worksite.";
    protected static final String DROPBOX_ID = " Drop Box";
    public static final String EVENT_DROPBOX_OWN = "dropbox.own";

    public static String getCollection() {
        return Dropbox.getCollection(PortalService.getCurrentSiteId());
    }

    public static String getCollection(String siteId) {
        String rv = null;
        if (SiteService.isUserSite(siteId) || SiteService.isSpecialSite(siteId)) {
            return rv;
        }
        rv = COLLECTION_DROPBOX + siteId + "/";
        if (ContentHostingService.allowUpdateCollection(rv)) {
            return rv;
        }
        try {
            ContentHostingService.checkCollection(rv);
            rv = rv + UsageSessionService.getSessionUser().getId() + "/";
            return rv;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDisplayName() {
        return Dropbox.getDisplayName(PortalService.getCurrentSiteId());
    }

    public static String getDisplayName(String siteId) {
        if (SiteService.isUserSite(siteId) || SiteService.isSpecialSite(siteId)) {
            return null;
        }
        String id = COLLECTION_DROPBOX + siteId + "/";
        if (ContentHostingService.allowUpdateCollection(id)) {
            return siteId + DROPBOX_ID;
        }
        return UsageSessionService.getSessionUser().getSortName();
    }

    public static void createCollection() {
        Dropbox.createCollection(PortalService.getCurrentSiteId());
    }

    public static void createCollection(String siteId) {
        if (SiteService.isUserSite(siteId) || SiteService.isSpecialSite(siteId)) {
            return;
        }
        String dropbox = COLLECTION_DROPBOX + siteId + "/";
        try {
            ContentHostingService.checkCollection(dropbox);
        }
        catch (IdUnusedException unused) {
            try {
                ContentCollectionEdit edit = ContentHostingService.addCollection(dropbox);
                ResourcePropertiesEdit props = edit.getPropertiesEdit();
                props.addProperty("DAV:displayname", siteId + DROPBOX_ID);
                props.addProperty("CHEF:description", PROP_SITE_DROPBOX_DESCRIPTION);
                ContentHostingService.commitCollection(edit);
            }
            catch (PermissionException permissionException) {
                return;
            }
            catch (IdUsedException e) {
                Log.warn("chef", "Dropbox.createCollection(): IdUsedException: " + dropbox);
                return;
            }
            catch (IdInvalidException e) {
                Log.warn("chef", "Dropbox.createCollection(): IdInvalidException: " + dropbox);
                return;
            }
            catch (InconsistentException e) {
                Log.warn("chef", "Dropbox.createCollection(): InconsistentException: " + dropbox);
                return;
            }
        }
        catch (PermissionException e) {
            return;
        }
        catch (TypeException typeException) {
            Log.warn("chef", "Dropbox.createCollection(): typeException: " + dropbox);
            return;
        }
        List users = SecurityService.unlockUsers(EVENT_DROPBOX_OWN, ContentHostingService.getReference(dropbox));
        Iterator it = users.iterator();
        while (it.hasNext()) {
            User user = (User)it.next();
            String userFolder = dropbox + user.getId() + "/";
            try {
                ContentHostingService.checkCollection(userFolder);
            }
            catch (IdUnusedException unused) {
                try {
                    ContentCollectionEdit edit = ContentHostingService.addCollection(userFolder);
                    ResourcePropertiesEdit props = edit.getPropertiesEdit();
                    props.addProperty("DAV:displayname", user.getSortName());
                    props.addProperty("CHEF:description", PROP_MEMBER_DROPBOX_DESCRIPTION);
                    ContentHostingService.commitCollection(edit);
                }
                catch (PermissionException ignore) {
                }
                catch (IdUsedException e) {
                    Log.warn("chef", "Dropbox.createCollection(): idUsedException: " + userFolder);
                }
                catch (IdInvalidException e) {
                    Log.warn("chef", "Dropbox.createCollection(): IdInvalidException: " + userFolder);
                }
                catch (InconsistentException e) {
                    Log.warn("chef", "Dropbox.createCollection(): InconsistentException: " + userFolder);
                }
            }
            catch (PermissionException ignore) {
            }
            catch (TypeException typeException) {
                Log.warn("chef", "Dropbox.createCollection(): TypeException: " + userFolder);
            }
        }
    }

    static {
        COLLECTION_DROPBOX = COLLECTION_DROPBOX;
        PROP_MEMBER_DROPBOX_DESCRIPTION = PROP_MEMBER_DROPBOX_DESCRIPTION;
        PROP_SITE_DROPBOX_DESCRIPTION = PROP_SITE_DROPBOX_DESCRIPTION;
        DROPBOX_ID = DROPBOX_ID;
        EVENT_DROPBOX_OWN = EVENT_DROPBOX_OWN;
    }
}

