/* ----- decode/1277xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1277xint16_checksums[] = {
  "d5348da2ff27262d66e755b86943578667e0356e52efc69e5f8ff7135cd8c5b2",
  "7076c2a55d93f7846a8a8a1fcadea82529d82a42e8bf6ef033d8b4974c8d8e7d",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1277xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1277xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1277xint16_ITEMBYTES

static void *storage_decode_1277xint16_x;
static unsigned char *test_decode_1277xint16_x;
static void *storage_decode_1277xint16_s;
static unsigned char *test_decode_1277xint16_s;
static void *storage_decode_1277xint16_x2;
static unsigned char *test_decode_1277xint16_x2;
static void *storage_decode_1277xint16_s2;
static unsigned char *test_decode_1277xint16_s2;

#define precomputed_decode_1277xint16_NUM 4

static const uint16_t precomputed_decode_1277xint16_x[precomputed_decode_1277xint16_NUM][crypto_decode_ITEMS] = {
  {61881,37663,42761,36921,36945,56679,32896,15324,29500,40039,30645,17462,38727,21201,51869,11100,51219,38051,56668,46883,13381,50340,37135,52861,21427,7895,52658,11554,37135,35236,7769,40452,8773,44328,16906,41484,31974,21162,21270,28695,44802,44396,13240,42514,37358,4726,55270,21421,40110,31681,40614,39183,56966,13495,12368,53501,61435,23501,55104,61955,51979,37297,1956,58325,17995,63377,59022,21543,11928,25489,28603,56987,43577,37004,60573,244,57178,28966,19938,52121,30494,11796,15994,55342,57010,18478,39795,44524,17559,54824,12445,4180,27892,60798,48015,56250,7194,50618,14981,48461,8657,44225,34445,34253,41062,39236,39388,24271,31701,30203,6646,3616,26485,35125,51726,34516,54799,5172,17993,13789,40775,36230,62511,48976,22257,53969,46731,3657,58532,29764,2613,53212,14605,28074,17448,31897,39591,24288,4385,48210,56892,36480,34991,38325,849,44904,12384,31738,11573,24461,31036,49578,16766,21347,34645,49659,53964,37946,11438,30841,26347,13389,34925,2568,30918,57452,38095,65130,16364,20068,52864,15385,18524,60645,38361,16644,5132,64996,21493,59221,9646,449,25510,34384,50489,62504,33704,42336,21829,45265,19305,17322,23542,1176,44507,55212,43631,3640,43646,25073,28089,6236,54439,54089,16403,31870,63667,27623,2646,41997,9784,41257,41990,61447,52652,3440,38267,60228,51233,3759,39352,19250,19291,8675,5186,15840,2884,19681,42157,59660,15620,12143,11901,29899,65056,46265,26963,22890,11073,45957,60857,44678,13301,19798,19721,30411,4863,46483,11165,20449,23952,8837,40577,19623,55261,35803,38803,1443,7004,18445,36055,16353,46493,42626,14318,49521,40613,799,52619,48113,29523,40538,43013,19903,12023,5986,26066,25332,63368,17649,56871,50057,19065,30540,34857,21921,34721,42903,55339,64818,52653,55451,476,5927,2032,55659,18217,26529,60315,64548,17931,30992,33043,5954,6648,58760,51250,9088,26239,48097,7212,42180,35915,23204,57821,58690,38362,43822,56303,25300,5176,21445,15077,25719,12980,14008,22110,29639,42425,44542,22223,11437,4666,60710,218,5059,32698,62600,15694,40798,62122,34296,17843,32135,28035,58330,54281,50504,18452,38866,58224,41788,7843,13845,9900,30520,15295,42136,54290,21643,59779,35158,38341,2123,11015,3733,30638,60789,22165,9005,16662,35317,39712,60753,13491,32480,47672,56064,20689,27725,9467,40529,18532,20421,64780,45802,27372,719,51565,41961,36025,53472,27339,26711,34484,39045,29415,22410,17657,3366,6895,31761,3617,49884,43160,33684,45359,45820,5455,52691,49441,20430,41397,24552,4748,29387,39757,54914,52952,20511,61192,12504,16818,49125,5244,43211,56465,4750,34242,25792,23847,53887,1173,59869,16752,54896,61964,35966,64707,48094,16211,24322,52321,36698,44707,8249,2059,26277,3799,37352,42535,26549,19996,52617,64549,19208,51661,53320,62434,2004,10679,1401,9921,18917,14301,55016,16665,44218,10209,49590,5669,46128,41023,201,9028,33306,40782,45103,2329,50478,40800,12416,18410,48519,62229,9231,54135,11499,23259,8155,30697,9343,44391,57822,894,42945,54651,52561,8651,63529,59177,55117,46789,62502,55402,59323,40835,37893,52782,23647,7096,42332,13590,34987,58322,47174,7359,64487,31387,18409,34929,9338,57569,4560,26457,40672,53409,54208,3473,27668,8742,2193,32836,25136,1041,8166,10314,45158,60239,30764,60798,28618,27612,50644,13006,30126,36690,7181,54161,41473,33204,20883,22773,7938,8202,64245,25843,29699,44774,19460,52599,41161,4708,28488,37271,56706,20972,47343,42163,59627,31671,59323,51860,12142,17058,22006,64339,15342,16398,58839,58650,55246,48514,14450,37320,29301,51335,31615,23395,62362,57014,50976,59741,13168,25102,4908,28821,46998,56383,24802,57922,62137,5964,48931,55232,41321,21582,33877,59471,54442,51153,49236,11528,49610,1125,27982,38765,19460,4711,59941,31212,43253,34529,39691,37939,61789,21331,24726,12670,52833,29463,42191,58079,29031,52555,46838,16595,32746,33428,59941,58713,59134,36861,24613,12390,9382,60607,48270,30396,32828,58735,6274,36366,52963,7552,51566,20638,64225,13930,57005,11332,27174,19294,63869,62511,48458,65164,60635,28965,46309,2500,34549,50399,26749,12941,27869,3170,24709,38248,39601,41620,27059,19085,20786,35137,15196,22179,60168,13909,63535,33238,27912,17769,27759,51619,59314,51749,44824,50161,8181,51106,21070,13900,49141,62669,50320,55133,12961,50505,58667,61652,19622,56648,19638,30959,1028,17519,41561,12749,56133,8118,56297,29690,58562,15487,15931,31282,39844,33134,56674,35326,22308,38419,10369,2791,37501,1760,48477,30221,29553,36467,8019,60675,33416,49445,41152,5004,8286,45334,12187,35775,53167,32545,18804,12638,16465,7228,38486,26061,59506,36428,19148,2078,8089,1316,55955,36214,43267,60701,50140,41941,17782,30594,45578,22281,59095,12305,44631,24989,15281,63087,30110,25828,20042,18161,47,37326,37367,28381,46096,40954,63092,34503,64978,63361,63037,41449,11223,62439,45745,65434,56941,30736,15967,36972,44776,14366,4081,50195,51634,63662,14673,56210,32996,61937,20399,27010,52607,52730,14171,31276,18508,7229,28303,36629,34795,18935,4223,41439,11556,1152,57641,33790,51840,14280,53620,24225,24892,61942,57583,20693,24340,56930,51566,33593,47153,13125,18420,15607,19454,59434,1835,51161,23753,59147,45137,41820,22256,23910,21561,20510,23620,17386,33752,12975,34106,8001,33804,64506,32083,50136,40730,49334,29270,8039,10452,25040,52903,31208,43807,2333,49969,5278,28028,45916,43202,4711,29721,30470,29789,41475,41553,61759,38697,56664,2236,52602,37010,33569,63221,42749,59617,46932,15716,13174,25034,6533,9812,30544,24890,3686,9696,54981,27558,10818,7041,14066,6359,2106,3249,26490,61212,59633,5866,30702,45053,37800,58057,60315,11108,46325,448,54950,39067,12711,16382,20597,3220,48626,58703,15245,37169,53768,26864,46515,23983,62287,9079,18792,42704,4568,42674,13691,18306,51013,29466,39838,46037,15050,15322,35822,36130,31362,30342,42511,11309,13660,25622,60154,28182,58658,39681,12676,56596,32185,49030,36415,48501,58500,6567,32436,13674,56107,58987,8431,52108,23256,16948,37488,13548,42720,37541,51702,28967,15141,18231,42566,838,29330,31279,6453,65398,56932,3272,25969,64383,15042,19145,5736,64043,38443,33462,59842,28919,21896,30973,21010,55819,56678,14010,54613,6667,16424,39674,25405,43547,32103,48132,45281,52472,14634,51157,1926,59922,33217,39328,57925,35324,23190,46822,36412,6113,40134,46203,10295,58043,10940,42672,16971,51107,31027,127,4341,10317,45625,8563,11726,63773,19279,59238,36574,35601,33999,21076,54854,45629,56688,60252,766,45376,40855,39566,64607,65010,15786,21007,13693,39518,16754,31913,14955,61379,58582,33738,21914,32161,63136,12047,34266,64388,24515,16310,40779,42457,55273,991,64011,61064,62121,231,47035,2347,12918,56665,50058,16071,24838,41999,3197,25737,21357,22540,27933,29033,12095,35230,57916,39627,62751,18872,53764,17663,60984,2134,7071,53273,43469,3837,61860,54629,39684,9553,41726,3092,2890,11502,31238,5089,49416,13089,15854,2593,19138,17904,20797,14131,6066,43201,1601,17599,38170,57154,57066,24847,58004,57580,50032,598,36317,7694,25234,60521,21760,19687,43295,24695,50101,54657,62646,41914,25794,64649,27640,32616,62052,58462,55504,35397,19864,5786,30027,13594,14368,30471,59135,5189,1140,23935,26220,11364,3979,50153,1175,42706,34651,20341,4601,55556,28655,52203,4534,17349,62535,43738,40459,52245,45047,28572,11517,40824,18201,37099,4789,15051,48100,64815,47691,9791,27804,42986,12714,41858,11388,32649,19941,12290,7291,61956,59281,34796,60272,21459,955,46067,56909,61584,48219,6652,23560,29118,18109,40630,24534,32055,1848,20756,1172,47134,50546,36847,9398,60967,49035,30270,10036,9095,6854,32763,888,56641,41840,63649,57768,35266,16441,400,25024,49123,16820,19525,31610,34462,34923,29086,53397,22229,32769},
  {19936,1047,10869,23899,4084,27966,38459,33067,4753,53327,7604,48629,47236,34207,36178,37483,49945,39496,64773,14760,47566,40533,27404,65407,31921,54846,24482,48865,9285,47081,63495,65360,13849,50067,62106,45266,41781,47549,49439,41892,22800,32009,15760,12344,60325,50632,19699,4263,4515,19710,2881,25138,48362,2663,45298,332,51222,4250,56667,37020,35151,25896,2340,7375,18761,53319,31609,5987,50021,43582,9708,31357,13289,18787,2576,11738,44146,25817,10204,57040,40804,12400,21111,54481,50817,52882,37425,18688,27723,35791,16767,12571,58729,13044,51324,61518,139,26764,36645,44796,37932,43266,41479,33839,18,37641,61969,39741,2530,48347,2939,55496,45163,11888,32754,47745,7501,35187,65238,22305,56317,55964,36981,4993,63871,3109,49469,51115,38374,11772,48045,3901,59799,4438,8902,56076,61554,14705,65165,35913,9480,48899,9837,45923,58215,51484,4934,27002,24509,12740,49942,14188,52635,58123,40200,6325,13480,22645,35316,15763,18633,60589,11756,16206,52893,53574,7461,27906,42350,27291,4267,23602,49922,41253,32357,55522,61318,61489,47397,51993,41977,63664,993,35484,24446,50169,30281,65282,20175,46863,20510,30636,3097,32189,56418,27443,5916,7435,61370,17228,57592,50207,52507,13519,40913,34312,32119,26305,26111,7174,24057,29144,42215,32643,20644,36875,20917,43139,52826,4664,45909,5520,50184,16075,26534,42518,17121,25865,47184,5583,57728,32261,55692,12822,59367,52993,19065,49890,11900,8519,60831,53000,47107,34244,53498,44625,23660,21700,29234,58199,30762,38064,63716,16304,18172,37605,51252,40480,45212,31208,19900,42638,23503,9209,61228,54707,620,20643,41897,33077,41405,51708,40724,16565,35231,44019,10044,59599,46295,13381,38665,38332,50765,58636,6553,61330,2581,3491,39711,58261,60734,55647,63693,52049,19579,37023,27217,48330,49257,58919,64330,56553,51439,33981,3540,51531,12617,23255,33768,18501,59617,59514,12982,62834,29977,41905,23596,37046,9066,57490,11789,8144,55315,36437,27141,5909,61182,60232,6305,10098,47864,7081,53340,49771,60484,44056,41052,49887,3570,50690,7953,52482,65454,35384,37030,28196,46943,36114,59628,65489,63679,54735,60627,29003,12814,9493,55620,54574,6274,8174,46099,40951,47845,29160,35901,10592,2283,61583,5263,64715,16237,25713,49646,22115,39816,5904,27020,26863,59100,48664,42616,18312,26423,43839,63690,792,52530,1213,47334,7615,49954,34890,1022,43437,38527,28744,39147,31096,38914,59413,38347,29945,40811,27647,40047,16692,59309,61615,15881,51512,15701,13090,42537,7210,40048,9290,40282,38925,20867,13794,16299,28036,47721,26830,50722,4280,6223,21203,50432,35226,18698,61460,30516,58720,17171,35019,6025,22079,43578,29558,40664,51126,15667,27580,24026,7198,25153,22601,54931,42432,5339,49666,5216,1931,22462,48271,54750,26502,34761,8264,6417,4860,17649,23815,59741,11731,55666,18630,48697,4009,14039,61891,39094,63553,43543,5716,36888,44594,18412,17253,131,41552,50932,5283,63318,40195,52075,48408,34799,37799,61399,39739,53790,8567,53394,51336,65362,1623,52931,27280,473,40656,28994,63752,12445,11153,46845,30481,64546,36905,33919,61928,28660,47413,12637,44351,27981,5185,61707,33,31907,64489,24680,45186,47707,53374,45652,39006,8829,51843,1173,46316,28493,12425,51407,22188,42154,32029,12940,23390,33027,29769,29203,55003,21463,9908,48852,52652,4977,3241,41352,38378,6307,31673,37442,53685,15330,14001,38926,7145,25530,47537,18823,40990,13097,18714,47211,45222,16807,23218,6089,3903,48710,11473,17362,64774,21181,15898,51820,18772,37296,58865,12783,31955,8902,63152,23276,17292,46142,56184,49806,10958,10683,32495,15654,3236,60973,18077,64069,48650,60891,6081,31302,65134,24861,63214,23955,47892,37852,23929,49702,27321,62463,8468,34560,52329,6221,63902,7878,58207,52352,25845,472,43120,31719,41370,54806,31297,22120,20445,20587,22402,58787,5966,24694,8359,45898,49589,17388,37176,51798,51140,42842,28322,10335,60676,36397,48449,60067,25490,64362,31361,65511,42823,47502,41501,65387,19407,46388,57179,22428,31000,63167,53377,6975,53952,34405,62138,11136,7504,17445,32398,24023,42330,19951,51603,14502,41270,60538,54133,11290,54160,48758,24830,16826,42908,6331,6413,8911,7003,20336,9460,9383,13699,39676,63008,7337,21294,15957,10826,13005,16621,2897,21022,64190,11941,11690,195,61167,32134,7830,49632,62952,34180,48597,32702,53459,7473,41390,52366,9165,55677,52799,37713,5181,17698,63396,5651,61768,45239,25995,17396,50873,33070,18852,53527,61247,61173,41519,63048,39522,38117,19086,34404,60520,14848,7109,15908,7497,38298,25654,39746,51094,27118,28303,52691,10302,19979,35814,57412,17389,37849,39978,65172,42621,12636,14981,63940,8324,4422,13609,10325,8786,14803,24743,28608,33195,10280,32889,27415,24105,23134,32448,5068,28936,48911,11318,7369,16678,20070,35214,33345,52344,56073,45036,10259,53942,12892,43727,24489,14648,2932,39554,40477,61284,10735,17965,39990,27444,8114,27558,23702,4565,36790,54397,60442,59469,34895,58463,26848,27034,32695,60351,4258,52198,31930,8230,41202,55493,15754,43802,21007,25502,7290,219,63389,62300,8312,5296,34977,26052,12992,53963,44882,26251,29952,51864,1703,33088,4454,562,16376,5113,55313,61724,18227,26414,18114,35354,51368,46910,27023,8761,36642,17864,29823,4409,45831,6478,24591,31323,13754,35066,55573,18202,61522,64962,40658,2063,30207,59795,20020,6327,52302,2342,16340,10730,23277,37743,33611,52584,5208,18921,52524,49833,46230,4447,5707,63932,26277,48119,55931,30763,52281,33558,9590,20496,22230,41225,6045,56628,41477,55414,53686,26933,44423,65054,14073,10185,42667,48966,1796,26652,3880,14021,6612,2425,29091,57055,5345,46888,33527,1452,21894,21798,1344,39907,64553,44511,38057,50658,2081,39583,51400,48845,6942,12280,42168,54214,58531,16823,22874,35045,63457,38303,24585,49181,63536,13826,867,22002,14039,16894,6273,7573,41329,55485,47405,38275,40627,29429,7695,28317,58603,55612,64551,32879,56248,58854,41740,8996,41816,19098,45926,42597,56659,1369,15436,15054,47435,23129,50198,43460,27156,26564,28771,53483,6913,24254,51431,4708,44418,60929,50985,35220,49826,62638,24281,22260,15433,23149,37942,48041,54088,56120,18489,38502,12016,40631,47618,39982,11693,6103,38547,42358,65320,31997,55641,57717,61962,11908,65446,26700,61565,4013,37112,3135,50947,9358,45792,51142,27158,40128,34952,38736,41795,32373,39903,33934,22626,27891,13837,7953,33198,3223,38008,52071,61834,14017,65366,2402,47137,8303,21864,48733,6954,52290,23762,39499,57540,52045,11188,26106,36961,1673,23300,19620,38377,39665,31743,51126,61971,21255,42547,53129,11346,9756,14982,31,4537,43346,55612,3263,23074,29256,63317,16695,1046,37840,31637,51207,28608,4126,14780,26299,15472,16201,7584,56691,35737,6473,13933,13796,49472,7224,38302,57483,51173,57594,30241,23104,17384,15268,47127,41426,34035,21234,39620,1211,7698,2706,44118,26499,37351,47145,61570,12568,56417,1850,1590,6875,59205,4674,55120,33343,44235,42546,45563,47584,51090,17357,57593,1142,54207,43864,21932,41003,34044,12111,50317,60218,43753,63956,14138,54649,11007,13366,40587,3692,22883,35520,27913,10124,19077,55229,55733,37147,40637,38889,25048,31149,35948,48594,57533,38658,31428,64429,8000,13193,49030,26160,58243,47213,64300,38149,48034,43525,35874,27023,57730,42872,30686,20661,11187,22477,7173,61517,24083,62492,20565,3831,61510,26374,4319,11972,30594,32049,21105,45864,47956,30298,53226,56570,8231,20259,65101,13164,45452,64548,54648,64729,24708,36391,38011,28527,17992,15994,37158,28579,44638,56560,5478,20865,46170,26544,56708,56729,11562,26829,65361,8298,20034,47730,6486,57226,40755,46191,20404,26297,32676,61129,59578,39385,62885,62367,24365,61429,60289,13083,16591,38579,5558,18849,13505,37015,16933,1334},
  {34196,34530,7543,25672,3408,49153,63466,33716,1826,41848,19407,14819,11232,36614,12131,31278,48035,48132,4840,13801,10,26104,39459,50130,57738,25642,64678,27489,47087,42763,18336,38452,31830,8048,4367,18282,58449,62607,15538,60561,23147,3606,8879,3159,26435,15334,30473,13635,34510,19311,11835,54527,19777,53384,32873,30198,57864,48990,62438,63918,57757,23527,47400,51523,26307,57900,57866,53779,10369,3595,16679,35894,51783,46475,60541,59794,53201,36440,25743,18390,1245,43107,561,21324,24586,10275,570,56122,16780,8627,49163,33131,31887,64660,58173,58716,44681,30418,480,8920,64539,53624,17066,7837,22826,24798,17754,36215,21375,56187,64467,39151,45626,57391,47546,33760,1371,38650,19193,31944,17918,61523,18745,14582,40414,19924,45749,34873,892,5028,3872,58825,16626,49187,30768,51645,60041,42915,49217,21973,2470,49840,31205,41323,36714,54283,61049,6252,50949,38022,43160,30690,37393,27196,29793,64511,62880,29819,39613,55363,59054,50974,13174,8195,48967,34207,41313,3668,25211,34309,57421,29883,36805,20713,15254,10995,20515,61821,56144,42111,5561,20303,27364,20421,50631,61467,60948,57626,8683,8415,11301,62216,34943,34663,28356,21846,2560,59007,32569,59721,56634,47228,50962,15984,38780,22936,6583,21315,56281,18713,51976,24512,18236,16092,48597,22677,34651,65479,16718,65126,10615,9939,3387,35589,15717,35644,49533,15089,14226,44087,54415,44439,8496,10670,64283,20817,6572,44033,29920,59869,150,1629,46951,57103,34859,34099,54798,23149,6275,48030,30071,17108,51524,54331,39969,59887,14676,29739,8110,43003,35045,38203,53877,52740,60544,21327,54686,47592,62504,30569,11981,2276,38671,35137,21254,35112,11890,40386,39958,11897,60829,9427,29260,19696,25697,24140,3846,21593,11401,60203,50515,13530,16965,55159,19900,57757,21829,11700,26684,60678,37060,64257,41630,22446,42982,24900,47286,36407,26272,38658,34802,36288,7931,1196,6971,21675,47465,27696,58477,3012,61625,44212,47017,19012,39763,56042,10417,15448,29223,20853,53365,37887,46485,54903,41682,35048,923,27173,42142,34015,42759,54568,40444,45698,16395,4902,17679,3826,62475,38769,61335,47515,1500,1489,42240,55694,60055,46943,14099,40487,48289,42139,15353,41910,13258,65114,35407,14903,5084,41217,30119,2175,32716,15888,52223,54178,29347,60477,54929,2894,17524,4976,154,56490,52196,52427,49533,12416,28151,33902,19690,36414,50935,35645,56436,53413,9606,3515,2755,8016,33192,65123,11441,43798,49062,62924,56855,12667,11711,45402,4882,42834,29769,42947,5787,42386,9723,33160,9508,6800,15556,7843,22748,35695,31963,51009,39807,47153,51208,29072,51344,5176,16340,2021,53459,39165,21829,35506,7482,56970,24791,45606,40645,930,38763,13684,57628,63332,44714,32897,55711,48828,19169,10031,54529,1910,26383,10730,2390,59827,58305,46784,24331,51535,26520,14559,14926,56701,43276,51766,3520,11463,59239,788,63574,16889,28965,3042,59540,32875,37867,29017,841,10475,48896,7590,42120,40590,57189,30995,20643,51671,13256,46554,2860,64470,29691,35936,53008,14948,42615,18875,3722,5853,40974,24105,57617,34571,8254,26829,22417,23012,17368,34275,27677,32417,39125,53451,28166,50077,35573,5846,56363,26295,3545,30438,19173,29518,22292,4835,38460,24266,30079,12027,62464,35994,24918,20796,10224,63471,13134,46887,50902,12405,22369,47029,64282,24861,41266,38559,9073,33505,30556,19590,41741,52701,51782,16418,45704,49928,55532,53456,48574,30437,61509,41362,44740,50779,55617,14087,31852,43441,29146,32013,20111,36760,22246,63391,23338,39805,17436,61278,64444,39251,38276,25168,42998,29390,12989,44062,52032,35779,14897,3821,62423,38650,24822,54384,38557,7769,7443,37603,15429,29231,55520,21919,2956,19912,13660,34641,13234,63386,36139,852,43365,13947,49721,27526,60139,27081,1498,28941,33488,38499,28427,5009,10702,9987,51358,7087,64516,35595,51739,30141,20054,20274,32850,46419,28070,44868,19996,11291,788,2662,44939,63163,29111,36963,34177,43209,34541,44769,62140,43992,36173,47788,43699,27597,60153,43722,8070,48698,27690,52161,50686,29315,52179,36254,51391,56415,5186,47805,47332,41635,15775,43280,19926,52299,8426,7670,13497,13613,26794,20918,3579,38365,44470,11391,27935,36617,49184,54574,419,52041,58514,42012,33030,44146,10756,13372,7597,4029,34893,62620,48204,44658,21591,21299,88,38142,65501,1576,16536,5350,6150,28116,61402,29234,28134,61028,23828,41190,4125,34372,14398,53272,25263,13567,64876,60921,33149,60422,56376,40619,51320,36587,27098,38645,29725,19802,54220,24058,21170,33071,21636,33599,62119,23973,8226,56979,56032,10773,51563,15010,11348,53137,41315,6595,5084,55152,46583,17655,63762,38628,11691,36685,61793,23268,12638,3596,41166,8088,55018,62918,51479,41667,64483,31644,63654,17880,35440,2052,16176,45511,63357,13135,50579,61627,25008,36463,52224,46548,15567,52959,40771,24812,25315,50808,33518,36937,7395,2587,32156,3012,51622,13268,30463,37765,32955,35040,45424,26017,19838,53175,19986,56525,25479,12445,34832,47637,14287,56919,40606,21154,29647,9106,14473,11143,39838,29122,45488,14536,38229,46566,48902,31238,59891,21536,34957,17248,10570,59166,23467,43752,50664,36077,6407,4706,22161,2420,20365,55115,3188,22674,31938,59315,56451,14792,53405,26638,45013,16738,62008,48624,57907,40910,9947,36531,49208,15163,33068,27980,13514,58342,37207,52532,27119,26465,35189,42112,52593,29006,36577,15005,63630,18995,64072,52390,142,25112,65408,17358,48902,3370,59780,63203,52532,6048,9780,30749,46953,3025,14982,36752,24977,14756,1649,47228,26180,39709,27940,17338,14385,14667,56904,47014,33460,17163,33105,37108,9785,30201,40613,42385,2037,30271,8159,11877,38026,51660,38494,5231,18543,58244,38434,15448,13311,42091,39888,54416,27703,5370,34370,24333,45236,37233,26733,37117,20911,12194,41111,3518,28985,19895,5518,51110,30493,55680,49156,50559,30847,30487,46203,6989,35497,29910,28195,37845,37594,27582,62541,3795,2760,33724,5225,36310,5465,12671,46081,14674,5999,46681,13427,46560,41380,65009,53267,57384,44232,16472,52945,18455,46106,43823,26175,33167,41421,34551,15768,19518,28728,6248,7966,65497,3004,17778,17403,60142,25282,61265,48954,13229,29118,2152,54266,18244,2527,28231,44583,61167,55321,16257,27139,1534,20810,2929,64812,47166,64097,38645,28517,38153,51076,5816,7714,2005,40313,54749,26662,6965,61932,57733,19296,31230,6141,8928,26869,19924,18561,62018,44632,41260,22116,37682,30030,19621,2067,27897,20145,24002,27602,47703,5393,8669,18262,31524,27474,58644,64411,60064,58419,23971,58157,24715,54580,46911,24819,7066,20290,11993,10422,44703,31016,13375,4401,18988,45491,11844,2604,57627,3730,22229,34497,56752,30233,22428,36153,25550,18637,44066,60259,18326,25327,21781,47697,50196,65166,14545,31679,58823,3206,56402,40385,22207,60404,46304,58540,26802,39711,18872,29471,32805,54313,36523,10185,19196,28138,37434,21295,56804,61269,55772,59099,24728,53446,24977,35231,23235,60004,28885,7936,45220,15560,13155,56459,22286,23755,53583,61463,40542,33328,20650,27634,19863,919,63466,2419,45471,65022,5958,36543,24558,42568,32124,41440,914,1863,49569,12489,27632,48370,40115,49649,47707,54251,63047,33371,7821,15464,50823,26395,52825,54732,23820,14322,4789,61002,59409,727,44240,14188,61328,9937,33274,37477,6323,41111,35266,30138,45791,22300,8387,11439,55561,35533,34569,8083,33158,10959,3486,33286,29008,42698,29762,5821,16990,64692,59179,21672,60701,48690,24638,65162,6589,35721,36186,13291,49669,11410,36115,55140,7722,6694,58045,63361,32466,44408,24424,16837,63504,21760,14388,59564,32582,13911,64798,18027,63490,33023,64193,19779,59815,53854,14475,2251,40601,33909,54654,16487,59923,32692,14162,34814,9253,60158,15355,4996,62471,47660,6707,64273,50196,59400,23392,56518,2983,13606},
  {52153,35934,58653,59239,15275,19160,53672,11302,62556,36756,24006,54771,27963,36082,12236,15504,19341,61200,57396,21509,62562,32587,55148,9137,39376,1469,17044,26306,12088,53663,48298,3070,49634,45964,3084,56402,51540,33054,49663,59674,46101,49845,12786,52032,6300,10210,24059,12690,46738,10077,26036,46408,5997,16334,33307,34635,32799,47165,2203,1352,19910,46331,63002,38192,54459,26864,27226,12999,61315,24395,65141,61153,7880,12527,8469,39577,23886,62349,7274,59878,43567,49556,11616,62530,36563,6255,3697,52655,7200,17722,54616,52415,45855,60327,31480,58028,3850,23053,32007,51330,582,61221,29653,20278,43461,32657,32442,8600,8329,64631,34786,51721,16683,54324,15262,62296,27250,25270,9358,6469,38963,43574,5499,28201,24424,2038,43027,6521,50754,29475,20102,51270,28418,10892,50918,55258,39200,41632,46676,38396,62879,6073,1196,21850,45627,13269,54083,21777,64856,38052,53920,27438,20484,63636,14995,13904,3801,42092,4324,59841,1399,46137,16103,35621,14377,53106,56143,56268,55127,15512,62106,6552,54808,63691,4021,21136,30797,4551,64762,30010,47695,17601,41279,37490,35862,44406,46049,59616,19531,7989,61696,28724,14891,20446,24172,50238,5474,52819,3953,52884,32814,9533,21950,43977,36811,29396,5449,605,27855,12247,40171,10301,38114,57662,18706,59587,52866,17956,7213,8408,42122,42556,10413,52327,43944,63556,3917,22882,20568,21084,1367,61466,63232,1235,11457,11197,42843,37045,39735,2839,48401,44974,5656,16623,45319,31667,14040,22090,34111,48422,51163,47498,12513,21892,5819,15516,26570,2692,56272,42039,41026,55513,36533,32019,62403,21236,12085,63020,41742,43255,17684,11959,15874,45153,5941,41027,59839,37082,11525,55732,4934,6038,44808,30668,57822,51775,45569,349,50163,31805,19975,31181,49329,50259,36445,3885,28593,16005,34648,6111,22086,46126,41796,19105,62607,45508,42315,27722,51178,32039,2469,2351,6894,49375,9800,23246,58336,3814,52483,42372,5610,13694,28887,46239,60771,46366,43498,57453,22242,35917,55145,11244,24814,59530,60668,55695,50946,29848,9724,16212,19390,45365,44970,10188,33957,20579,53019,13776,43030,48432,55589,48362,1633,53029,52651,30999,19216,2600,14721,33206,12674,2045,2541,28338,29381,10212,25902,26239,52520,24316,43704,14319,26022,47398,11432,334,59702,8406,42955,23938,22004,13788,24819,9408,28153,33879,35446,45454,10905,51573,58398,24654,8141,20598,22009,7726,27419,56988,45785,42087,29065,52381,14481,52019,49515,29690,55674,21102,52431,10470,59904,11067,8123,36746,59962,54211,16851,12691,47954,49437,5112,38266,15948,28178,36760,33320,53754,63470,27647,13833,12551,58148,63499,39641,55010,28472,54515,24002,32329,62527,7194,44580,59194,26489,33812,5646,45086,5328,29148,22719,39665,28514,48717,1213,5849,56260,28858,1877,32278,59537,4406,63396,4810,17002,33728,48696,40966,9872,23911,25136,51425,15695,30459,15956,38300,41359,60624,21495,50968,506,24501,54137,22492,22776,31988,1464,21997,54624,49995,33157,18822,65222,59930,433,24779,47928,17820,11813,690,38184,20383,63344,26107,63947,6690,22919,60340,29271,12944,43635,40684,12392,55977,39531,22449,3222,63170,17834,52268,54421,53927,34717,1005,7800,7866,61641,11671,11133,51270,43457,5183,34399,62301,33611,36776,31095,14767,28059,30739,37700,20414,38682,36410,6110,64845,17339,19469,57904,62767,46259,29418,21179,12184,53987,24391,2705,34110,7610,1417,48764,39902,11629,31034,30693,4707,40973,13532,25260,45701,27683,11695,47989,50212,44111,53023,65099,34632,45475,44208,32349,52945,4633,5623,53467,21782,24091,15837,41926,38395,28144,13240,19713,28469,46057,14561,38548,57496,32409,14215,41659,6712,61398,41001,26727,22107,13853,16073,30244,39483,42763,35570,31315,50578,11275,56828,53534,60365,55110,64577,28800,58078,22726,37201,36716,40449,56892,13857,58442,6766,12216,51023,62845,19368,29919,32697,31803,63881,58948,22731,22311,6992,56643,30796,15561,33459,17511,65217,44397,58871,27723,37798,331,25724,63427,58200,53273,46850,38250,41847,15667,37364,31527,59291,35831,9614,53641,60947,33903,19577,18544,46772,43882,28002,37756,15324,3201,56348,34943,46391,57839,24362,40812,25582,8461,24871,39316,52156,40258,13187,65269,24621,60979,51488,5448,2436,58372,41837,14486,33077,52309,32158,47050,44164,22757,49584,43188,60541,36826,20226,42240,60855,16216,62589,59272,44870,34747,58517,30598,58870,21044,46172,51811,37219,62736,63439,49103,49207,63913,16947,30524,11061,25480,55012,19746,51422,32161,17171,3722,8700,26484,6605,29851,16796,41760,32516,20320,41731,31742,5031,15146,54114,43813,32318,36920,9041,26259,49065,48603,62121,22465,21558,39799,46845,8486,33447,27623,53016,19895,18092,51321,3960,22599,15474,39670,39625,41926,62607,52948,32902,22491,57145,52006,39945,32234,61896,27111,5209,46321,51855,9621,51256,35261,25717,4201,15743,55590,26834,43289,16741,16677,47985,44462,44380,10677,54711,16086,36799,40016,38407,22490,18060,7708,52153,30556,36771,31548,16832,56658,48386,24163,48873,54239,45133,26326,43173,31470,27135,53230,31593,49983,48082,15985,25471,52819,24773,61633,15564,10604,27256,10538,46226,3945,52532,44590,42878,21494,44717,2537,48734,18682,56956,2700,19337,40621,35281,6979,10590,63973,58377,13419,2621,46288,42626,38646,28442,48968,42425,29918,11223,42943,20596,56789,57263,7245,33404,17421,8594,14560,55180,19741,41443,29054,64700,48087,29989,28607,63936,28379,17450,65190,33118,40882,28968,45012,2866,42997,6469,62817,51470,16570,18941,25059,40958,9247,19218,29902,16759,45075,60717,2038,22533,4010,7377,28392,27414,22770,38301,3985,4212,40018,24612,58282,44095,47408,296,54826,32836,29044,8109,59351,37461,60718,64570,11765,17406,36834,23730,22311,13595,24892,32872,2879,40689,59919,11661,44896,20435,36281,6383,49066,41711,14169,19090,24428,38016,42398,27362,21800,56042,51190,45727,61782,29531,35105,2762,28510,4909,59361,38113,26790,14546,56366,64150,14995,21848,16645,12522,59743,9693,47828,6636,2067,15288,58562,42433,58349,7928,40560,41351,29066,62431,29412,60418,41806,50896,60812,30074,37756,53121,59453,11015,43582,47152,50005,54799,19989,44249,31370,26265,34202,57338,39292,29986,25068,33023,21708,41771,60128,31611,5258,18573,42193,17990,10669,51757,58982,12481,29333,30793,53848,43868,54385,46232,62706,60621,59753,45042,55469,53721,27580,46509,32935,53816,20656,39610,28656,30165,7565,58847,27862,19914,35960,56122,13402,60120,20613,51361,7469,40482,9568,31026,39299,17294,9996,26517,4226,11003,3505,40480,9122,3781,11730,47278,16857,15830,39092,44358,25646,62055,31428,11677,56263,18214,1738,27532,58743,40832,25977,29008,21707,28360,62681,50025,57335,2398,47420,31394,28548,49910,46400,30089,61218,19601,18989,23840,38506,51467,8012,30545,52128,39140,2106,21865,792,3184,24928,18478,2281,9829,8068,31618,7342,53605,55264,59955,22586,63251,35017,24544,51336,44076,38889,32757,12246,183,27667,5302,64087,34574,43769,52366,28773,59010,3892,43271,63307,41607,20328,6294,22302,52000,5703,50287,31413,21057,56260,36026,12309,63978,26693,15772,24739,10359,44928,10395,5203,49516,14509,10400,15591,55871,58596,14464,21483,13411,21953,4309,24244,19436,49451,37295,3175,54073,2716,41074,51734,58470,28491,31562,27739,34215,27003,35280,39551,42922,3251,22467,7057,5956,27289,47350,62860,1770,30433,4711,22797,2176,12885,39481,36560,37927,45908,7469,39173,46567,60848,32194,1464,54914,33180,2058,50031,20767,32932,1545,40658,7594,22388,33132,51717,40489,63733,6356,51722,18378,15336,3748,41889,11964,36532,55947,14657,19392,33204,30149,12042,26470,23270,35105,8026,48351,60872,64650,7221,49992,50809,46388,41089,18429,57302,33265,64671,8027,4878,42203,30200,14815,16713,25956,47798,37379,32617,39548,65282,21739,27701,53373},
} ;

static const unsigned char precomputed_decode_1277xint16_s[precomputed_decode_1277xint16_NUM][crypto_decode_STRBYTES] = {
  {185,241,31,147,9,167,57,144,81,144,103,221,128,128,220,59,60,115,103,156,181,119,54,68,71,151,209,82,157,202,92,43,19,200,163,148,92,221,35,183,69,52,164,196,15,145,125,206,179,83,215,30,178,205,34,45,15,145,164,137,89,30,4,158,69,34,40,173,10,66,12,162,230,124,170,82,22,83,23,112,2,175,108,173,184,51,18,166,238,145,118,18,230,215,173,83,174,156,193,123,166,158,15,153,134,222,183,52,80,48,253,208,251,239,205,91,64,215,3,242,11,203,177,145,164,7,213,227,75,70,145,247,142,230,39,84,152,46,145,99,187,111,155,222,57,170,140,144,157,236,244,0,90,223,38,113,226,77,153,203,30,119,20,46,122,62,46,216,178,222,46,72,115,155,236,173,151,68,40,214,157,48,84,16,244,108,126,237,143,187,186,219,26,28,186,197,133,58,77,189,209,33,193,172,141,134,205,133,102,160,68,153,220,153,207,94,213,123,251,117,246,25,32,14,117,103,53,137,14,202,212,134,15,214,52,20,73,70,221,53,71,159,134,141,47,244,80,191,241,86,209,210,139,182,73,14,164,228,68,116,53,10,220,207,13,57,170,109,40,68,153,124,167,154,224,94,33,17,82,188,60,222,128,142,175,136,181,149,81,3,104,175,96,48,250,123,53,45,141,95,60,121,170,193,126,65,99,83,85,135,251,193,204,210,58,148,174,44,121,120,235,102,77,52,109,136,8,10,198,120,108,224,207,148,106,254,236,63,100,78,128,206,25,60,92,72,229,236,217,149,4,65,12,20,228,253,245,83,85,231,174,37,193,1,166,99,80,134,57,197,40,244,168,131,96,165,69,85,209,176,105,75,170,67,246,91,152,4,219,173,172,215,111,170,56,14,126,170,241,97,185,109,92,24,167,212,73,211,19,64,126,124,179,248,231,107,86,10,13,164,56,38,41,161,6,164,7,240,172,205,112,13,123,149,68,235,33,200,175,14,184,153,50,75,91,75,227,33,66,20,224,61,68,11,225,76,173,164,12,233,4,61,111,47,125,46,203,116,32,254,185,180,83,105,106,89,65,43,133,179,185,237,134,174,245,51,86,77,9,77,203,118,255,18,147,181,157,43,225,79,144,93,133,34,129,158,167,76,221,215,219,139,147,151,163,5,92,27,13,72,215,140,225,63,157,181,130,166,238,55,113,193,165,158,31,3,139,205,241,187,83,115,90,158,5,168,191,77,247,46,98,23,210,101,244,98,136,247,241,68,39,222,137,195,121,74,76,119,41,136,161,85,161,135,151,167,43,216,50,253,173,205,155,216,220,1,39,23,240,7,107,217,41,71,161,103,155,235,36,252,11,70,16,121,19,129,66,23,248,25,136,229,50,200,128,35,127,102,225,187,44,28,196,164,75,140,164,90,221,225,66,229,218,149,46,171,239,219,212,98,56,20,197,83,229,58,119,100,180,50,184,54,94,86,199,115,185,165,254,173,207,86,173,44,58,18,38,237,218,0,195,19,186,127,136,244,78,61,94,159,170,242,248,133,179,69,135,125,131,109,218,227,9,212,72,197,20,72,210,151,112,227,60,163,163,30,21,54,172,38,56,119,191,59,152,164,18,212,139,84,131,233,86,137,197,149,75,8,7,43,149,14,174,119,117,237,149,86,45,35,22,65,245,137,32,155,81,237,179,52,224,126,56,186,0,219,209,80,77,108,251,36,81,158,100,72,197,79,12,253,234,178,236,106,207,2,109,201,233,163,185,140,224,208,203,106,87,104,180,134,133,152,231,114,138,87,249,68,38,13,239,26,17,124,33,14,220,194,152,168,148,131,47,177,252,178,79,21,211,205,33,193,206,79,181,161,232,95,140,18,203,114,77,155,130,214,216,206,31,80,8,239,216,48,178,65,229,191,124,20,203,168,145,220,142,18,194,133,192,100,39,93,127,210,149,4,221,233,112,65,112,214,12,242,126,140,195,252,222,187,83,63,2,95,97,204,90,143,163,174,57,32,11,8,165,102,215,14,232,145,39,166,181,103,28,78,137,205,37,252,8,75,205,201,72,208,226,243,212,7,183,41,121,5,193,38,229,73,221,55,232,214,25,65,186,172,225,39,182,193,37,22,48,180,63,160,201,0,68,35,26,130,78,159,47,176,25,9,46,197,96,159,128,48,234,71,135,189,21,243,15,36,119,211,235,44,219,90,219,31,233,119,127,36,103,173,222,225,126,3,193,167,123,213,81,205,203,33,41,248,41,231,77,215,197,182,38,244,106,216,187,231,131,159,5,148,46,206,95,92,184,27,92,165,22,53,171,136,210,227,70,184,191,28,231,251,155,122,233,71,113,136,122,36,225,224,208,17,89,103,224,158,161,208,192,211,145,13,20,108,38,34,145,8,68,128,48,98,17,4,230,31,74,40,102,176,79,235,44,120,126,237,202,111,220,107,212,197,206,50,174,117,82,143,13,28,145,211,1,162,180,129,147,81,245,88,2,31,10,32,245,250,243,100,3,116,230,174,4,76,119,205,201,160,100,18,72,111,151,145,130,221,236,81,239,184,179,164,235,232,183,123,187,231,148,202,110,47,162,66,246,85,83,251,238,59,14,64,215,229,26,229,206,215,130,189,114,56,200,145,117,114,135,200,127,123,99,91,154,243,182,222,32,199,93,233,112,51,14,98,44,19,149,112,150,183,63,220,226,96,66,226,185,242,76,23,35,191,192,215,105,161,78,84,85,132,79,232,170,212,209,199,84,192,8,45,202,193,101,4,78,109,109,151,4,76,103,18,37,234,236,121,245,168,225,134,11,155,51,148,93,241,83,83,150,96,126,49,97,206,23,115,207,164,223,226,103,113,75,205,246,182,211,64,234,127,148,130,37,234,89,229,254,230,253,143,37,96,102,48,166,36,191,236,142,188,188,118,60,128,111,229,130,24,14,142,227,206,128,29,110,201,158,80,225,250,106,54,173,222,68,44,38,106,94,75,125,249,47,244,74,189,140,254,219,236,37,113,229,180,196,9,245,134,223,196,125,104,141,50,221,108,98,12,133,96,104,149,177,154,148,162,179,105,141,74,50,81,65,137,92,59,163,86,8,235,85,54,47,248,214,129,8,109,105,69,111,108,163,201,178,231,37,202,24,175,241,195,245,31,162,199,78,82,76,54,245,191,205,244,144,196,93,215,161,50,73,197,43,229,212,240,166,76,72,221,182,76,239,120,4,4,111,68,89,162,205,49,69,219,182,31,233,219,250,115,194,228,127,60,59,62,50,122,164,155,110,129,98,221,254,137,36,87,19,150,129,40,231,10,125,146,224,6,93,189,13,118,113,115,115,142,83,31,3,237,136,130,37,193,192,160,140,19,94,32,22,177,155,47,191,139,175,207,33,127,116,73,94,49,81,64,60,28,86,150,205,101,114,232,76,142,204,74,30,8,153,31,36,5,147,218,118,141,3,169,29,237,220,195,213,163,118,69,130,119,10,178,9,87,215,230,17,48,87,174,157,97,177,59,111,246,158,117,228,100,74,78,241,70,47,0,206,145,247,145,221,110,16,180,250,159,116,246,199,134,210,253,129,247,61,246,233,161,215,43,231,243,177,178,154,255,109,222,16,120,95,62,108,144,232,174,30,56,241,15,19,196,178,201,174,248,81,57,146,219,228,128,241,241,175,79,130,105,127,205,250,205,91,55,44,122,76,72,61,28,143,110,21,143,235,135,247,73,127,16,223,161,36,45,128,4,41,225,254,131,128,202,200,55,116,209,161,94,60,97,246,241,239,224,213,80,20,95,98,222,110,201,57,131,49,184,69,51,244,71,247,60,254,75,42,232,43,7,217,199,201,92,11,231,81,176,92,163,240,86,102,93,57,84,30,80,68,92,234,67,216,131,175,50,58,133,65,31,12,132,250,251,83,125,216,195,26,159,182,192,86,114,103,31,212,40,208,97,167,206,232,121,31,171,29,9,49,195,158,20,124,109,92,179,194,168,103,18,25,116,6,119,93,116,3,162,81,162,63,241,41,151,88,221,188,8,122,205,146,144,33,131,245,246,253,166,225,232,84,183,100,61,118,51,202,97,133,25,84,38,80,119,58,97,102,14,224,37,197,214,166,107,66,42,129,27,242,54,215,24,58,8,177,12,122,103,28,239,241,232,234,22,238,119,253,175,168,147,201,226,155,235,100,43,245,180,192,1,166,214,155,152,167,49,254,63,117,80,148,12,242,189,79,229,141,59,49,145,8,210,240,104,179,181,175,93,79,243,119,35,104,73,208,166,216,17,178,166,123,53,130,71,69,199,26,115,158,155,213,179,202,58,218,59,238,139,34,141,130,122,134,118,15,166,45,44,92,53,22,100,250,234,22,110,34,229,1,155,132,49,20,221,185,125,134,191,63,142,117,189,132,228,167,25,180,126,106,53,43,219,107,230,239,32,140,203,216,90,52,66,112,146,236,52,224,166,165,146,246,201,39,113,37,59,55,71,70,166,70,3,146,114,47,122,53,25,118,255,100,222,200,12,113,101,127,251,194,58,201,74,104,22,43,250,43,150,182,130,194,233,247,112,136,85,253,120,18,82,11,218,102,221,186,54,85,213,11,26,40,64,250,154,61,99,27,170,103,125,4,188,225,176,248,204,42,57,213,199,134,7,18,234,193,129,160,153,69,226,252,137,150,90,230,182,60,142,225,23,198,156,123,180,55,40,187,226,188,42,176,166,75,66,163,199,51,121,127,0,245,16,77,40,57,178,115,33,206,45,29,249,79,75,102,231,222,142,17,139,207,132,84,82,70,214,61,178,112,221,92,235,254,2,64,177,151,159,142,154,95,252,242,253,170,61,15,82,125,53,94,154,114,65,169,124,107,58,195,239,214,228,202,131,154,85,161,125,160,246,15,47,218,133,132,251,195,95,182,63,75,159,217,165,233,215,223,3,11,250,136,238,169,242,231,0,187,183,43,9,118,50,89,221,138,195,199,62,6,97,15,164,125,12,137,100,109,83,12,88,29,109,105,113,63,47,158,137,60,226,203,154,31,245,184,73,4,210,255,68,56,238,86,8,159,27,25,208,205,169,253,14,164,241,101,213,4,155,81,37,254,162,20,12,74,11,238,44,6,122,225,19,8,193,33,51,238,61,33,10,194,74,240,69,61,81,51,55,178,23,193,168,65,6,191,68,26,149,66,223,234,222,15,97,148,226,236,224,112,195,86,2,221,141,14,30,146,98,105,236,0,85,231,76,31,169,119,96,181,195,129,213,182,244,186,163,194,100,137,252,248,107,104,127,100,242,94,228,208,216,69,138,152,77,154,22,75,117,26,53,32,56,7,119,255,230,69,20,116,4,127,93,108,102,100,44,139,15,233,195,151,4,210,166,91,135,117,79,249,17,4,217,239,111,235,203,182,17,197,67,71,244,218,170,11,158,21,204,247,175,156,111,253,44,120,159,25,71,235,144,181,18,203,58,228,187,47,253,75,186,63,38,156,108,234,167,170,49,130,163,124,44,137,127,229,77,2,48,123,28,4,242,145,231,236,135,112,235,211,83,187,3,243,179,77,222,144,240,91,188,252,25,8,92,190,113,189,70,182,158,214,95,55,125,56,7,20,81,148,4,30,184,114,197,239,143,182,36,39,238,139,191,62,118,52,39,135,35,198,26,251,127,120,3,65,221,112,163,161,248,168,225,194,137,57,64,144,1,192,97,227,191,180,65,69,76,122,123,158,134,107,136,158,113,149,208,213,86,1,128},
  {224,77,23,4,117,42,91,93,244,15,62,109,59,150,43,129,145,18,79,208,180,29,245,189,132,184,159,133,82,141,107,146,25,195,72,154,5,253,168,57,206,185,85,158,12,107,127,255,177,124,62,214,162,95,225,190,69,36,233,183,7,248,80,255,25,54,147,195,154,242,210,176,53,163,189,185,31,193,164,163,16,89,9,125,144,61,56,48,165,235,200,197,243,76,167,16,163,17,254,76,65,11,50,98,234,188,103,10,242,176,76,1,22,200,154,16,91,221,156,144,79,137,40,101,36,9,207,28,73,73,71,208,121,123,99,23,101,195,62,170,236,37,125,122,233,51,99,73,16,10,218,45,114,172,217,100,220,39,208,222,100,159,112,48,119,82,209,212,129,198,146,206,49,146,0,73,75,108,207,139,127,65,27,49,105,229,244,50,124,200,78,240,139,0,140,104,37,143,252,174,44,148,2,169,7,162,47,132,18,0,9,147,17,242,61,155,226,9,219,188,123,11,200,216,107,176,112,46,242,127,129,186,77,29,115,137,214,254,33,87,253,219,156,218,117,144,129,19,127,249,37,12,61,193,171,199,230,149,252,45,173,187,61,15,151,233,86,17,198,34,12,219,114,240,113,57,141,254,73,140,8,37,3,191,109,38,99,179,103,227,28,201,70,19,122,105,189,95,196,49,22,195,108,55,155,205,11,227,8,157,181,24,168,52,117,88,244,137,147,61,201,72,173,236,236,45,78,63,157,206,70,209,37,29,2,109,110,165,155,106,171,16,50,92,2,195,37,161,101,126,226,216,134,239,49,240,37,185,25,203,249,163,176,248,225,3,156,138,126,95,249,195,73,118,2,255,207,78,15,183,30,80,172,119,25,12,189,125,98,220,51,107,28,23,11,29,186,239,76,67,248,224,31,196,27,205,207,52,209,159,8,134,119,125,193,102,255,101,6,28,249,93,216,113,231,164,131,127,164,80,11,144,181,81,131,168,90,206,56,18,85,179,144,21,8,196,203,62,166,103,22,166,225,66,9,101,80,184,207,21,128,225,5,126,140,217,22,50,231,231,1,207,121,74,226,194,124,46,71,33,159,237,8,207,3,184,196,133,250,208,81,174,108,92,196,84,50,114,87,227,42,120,176,148,228,248,176,63,252,70,229,146,52,200,32,158,156,176,232,121,188,77,142,166,207,91,249,35,44,239,179,213,108,2,163,80,169,163,53,129,189,161,252,201,20,159,181,64,159,137,243,171,60,39,207,232,215,180,69,52,9,151,188,149,77,198,12,229,153,25,146,239,21,10,163,13,31,155,149,227,62,237,95,217,205,248,81,203,123,76,159,144,81,106,202,188,105,192,39,230,74,251,233,220,239,200,189,132,212,13,75,201,73,49,215,90,232,131,69,72,225,232,122,232,182,50,114,245,25,117,177,163,44,92,182,144,106,35,146,224,13,46,208,31,19,216,85,142,5,106,21,23,254,238,72,235,161,24,114,39,248,186,169,27,92,208,107,194,68,236,24,172,92,160,223,194,242,13,2,198,17,31,2,205,174,255,56,138,166,144,36,110,95,183,18,141,236,232,209,255,191,248,207,213,211,236,75,113,14,50,21,37,68,217,46,213,130,24,238,31,19,180,247,159,229,186,232,113,61,140,96,41,235,8,143,240,143,20,203,252,109,63,113,100,238,193,99,86,136,155,16,23,140,105,239,104,220,230,24,190,120,166,136,71,55,103,63,171,202,248,24,3,50,205,189,4,230,184,191,29,34,195,74,136,254,3,173,169,127,150,72,112,235,152,120,121,2,152,21,232,203,149,249,116,107,159,255,107,111,156,52,65,173,231,175,240,9,62,56,201,85,61,34,51,41,166,42,28,112,156,74,36,90,157,13,152,131,81,226,53,171,63,132,109,105,186,206,104,34,198,184,16,79,24,211,82,0,197,154,137,10,73,20,240,52,119,96,229,19,67,203,136,137,23,63,86,58,170,118,115,216,158,182,199,51,61,188,107,218,93,30,28,65,98,73,88,147,214,192,165,219,20,2,194,96,20,139,7,190,87,143,188,222,213,134,103,201,135,72,32,17,25,252,18,241,68,7,93,93,233,211,45,114,217,198,72,57,190,169,15,215,54,195,241,182,152,65,248,23,170,84,22,24,144,50,174,236,71,101,67,131,0,80,162,244,198,163,20,86,247,3,157,107,203,24,189,239,135,167,147,215,239,59,155,30,210,119,33,146,208,136,200,82,255,87,6,195,206,144,106,217,1,208,158,66,113,8,249,157,48,145,43,253,182,17,119,34,252,41,144,127,132,232,241,244,111,53,185,93,49,63,173,77,109,65,20,11,241,33,0,163,124,233,251,104,96,130,176,91,186,126,208,84,178,94,152,125,34,131,202,149,4,236,180,77,111,137,48,207,200,172,86,170,164,29,125,140,50,94,91,3,129,73,116,19,114,219,214,215,83,180,38,212,190,172,205,113,19,169,12,136,161,234,149,163,24,185,123,66,146,181,209,226,59,177,54,14,152,233,27,186,99,177,185,135,73,30,160,41,51,26,73,107,184,166,176,167,65,178,90,201,23,63,15,70,190,209,44,210,67,6,253,189,82,26,62,108,202,84,73,176,145,241,229,239,49,211,124,198,34,176,246,236,90,140,67,62,180,120,219,142,194,206,42,187,41,239,126,38,61,164,12,45,238,157,70,69,250,10,190,219,237,193,23,70,122,110,254,29,97,238,246,147,93,20,187,220,147,121,93,38,194,185,106,255,243,20,33,0,135,105,204,77,24,158,249,198,30,95,227,128,204,245,100,216,1,112,168,231,123,154,161,22,214,65,122,104,86,221,79,107,80,130,87,163,229,78,23,118,96,167,32,74,179,181,193,236,67,56,145,86,202,196,199,90,167,162,110,95,40,4,237,45,142,65,189,163,234,146,99,106,251,129,122,231,255,71,167,142,185,29,162,107,255,207,75,52,181,91,223,156,87,24,121,191,246,129,208,63,27,192,210,101,134,186,242,128,43,80,29,37,68,142,126,215,93,90,165,239,77,147,201,166,56,54,161,122,236,117,211,26,44,144,211,118,190,254,96,186,65,156,167,187,24,13,25,207,34,91,27,112,79,244,36,167,36,131,53,252,154,32,246,169,28,46,83,85,62,74,42,205,50,237,64,81,11,30,82,190,250,165,46,170,45,195,0,239,238,134,125,150,30,224,193,232,245,132,133,213,189,190,127,211,208,49,29,174,161,142,204,205,35,125,217,63,206,81,147,61,20,34,69,164,247,19,22,72,241,183,176,139,101,244,67,185,198,46,129,164,73,23,209,63,239,245,238,47,162,72,246,98,154,229,148,142,74,100,134,104,236,0,58,197,27,36,62,73,29,154,149,54,100,66,155,150,199,238,105,143,110,211,205,62,40,11,78,230,139,68,224,237,67,217,147,42,156,148,254,125,166,92,49,133,58,196,249,132,32,70,17,41,53,85,40,82,34,211,57,167,96,192,111,171,129,40,40,121,128,23,107,41,94,94,90,192,126,204,19,8,113,15,191,54,44,201,28,38,65,102,78,142,137,65,130,120,204,9,219,236,175,19,40,182,210,92,50,207,170,169,95,56,57,116,11,130,154,29,158,100,239,239,41,45,70,54,156,52,107,178,31,166,107,150,92,213,17,182,143,125,212,26,236,77,232,79,136,95,228,224,104,154,105,183,127,191,235,162,16,230,203,186,124,38,32,242,160,197,216,138,61,26,171,15,82,158,99,122,28,219,0,157,247,92,243,120,32,176,20,161,136,196,101,192,50,203,210,82,175,139,102,0,117,152,202,167,6,64,129,102,17,50,2,248,63,249,19,17,216,28,241,51,71,46,103,194,70,26,138,168,200,62,183,143,105,57,34,34,143,200,69,127,116,57,17,7,179,78,25,15,96,91,122,186,53,250,136,21,217,26,71,82,240,194,253,210,158,15,8,255,117,147,233,52,78,183,24,78,204,38,9,212,63,234,41,237,90,111,147,75,131,104,205,88,20,233,73,44,205,169,194,150,180,95,17,75,22,188,249,165,102,247,187,123,218,43,120,57,204,22,131,118,37,16,80,214,86,9,161,157,23,52,221,5,162,118,216,182,209,53,105,135,173,30,254,249,54,201,39,171,166,70,191,4,7,28,104,40,15,197,54,212,25,121,9,163,113,223,222,225,20,40,183,247,130,172,5,134,85,38,85,64,5,227,155,41,252,223,173,169,148,226,197,33,8,159,154,200,200,205,190,30,27,248,47,184,164,198,211,163,228,183,65,90,89,229,136,225,247,159,149,9,96,29,192,48,248,2,54,99,3,242,85,215,54,254,65,129,24,149,29,113,161,189,216,45,185,131,149,179,158,245,114,15,30,157,110,235,228,60,217,39,252,111,128,184,219,230,229,12,163,36,35,88,163,154,74,102,179,101,166,83,221,89,5,76,60,206,58,75,185,89,90,22,196,196,169,20,106,196,103,99,112,235,208,1,27,190,94,231,200,100,18,130,173,1,238,41,199,148,137,162,194,174,244,217,94,244,86,73,60,109,90,54,148,169,187,72,211,56,219,57,72,102,150,240,46,183,158,2,186,46,156,173,45,215,23,147,150,118,165,40,255,253,124,89,217,117,225,10,242,132,46,166,255,76,104,125,240,173,15,248,144,63,12,3,199,142,36,224,178,198,199,22,106,192,156,136,136,80,151,67,163,117,126,223,155,142,132,98,88,243,108,13,54,17,31,174,129,151,12,120,148,103,203,138,241,193,54,86,255,98,9,33,184,111,32,104,85,93,190,42,27,66,204,210,92,75,154,196,224,77,203,180,43,250,101,97,144,137,6,4,91,164,76,233,149,241,154,255,123,182,199,19,242,7,83,51,166,137,207,82,44,28,38,134,58,31,0,185,17,82,169,60,217,191,12,34,90,72,114,85,247,55,65,22,4,208,147,149,123,7,200,192,111,30,16,188,57,187,102,112,60,73,63,160,29,115,221,153,139,73,25,109,54,228,53,64,193,56,28,158,149,139,224,229,199,250,224,33,118,64,90,232,67,164,59,23,184,210,161,243,132,242,82,196,154,187,4,18,30,146,10,86,172,131,103,231,145,41,184,130,240,24,49,97,220,58,7,54,6,219,26,69,231,66,18,80,215,63,130,203,172,50,166,251,177,224,185,146,199,205,67,249,224,118,4,191,211,88,171,172,85,43,160,252,132,79,47,141,196,58,235,233,170,212,249,58,55,121,213,255,42,54,52,139,158,108,14,99,89,192,138,9,109,140,39,133,74,189,215,181,217,27,145,189,158,233,151,216,97,173,121,108,140,210,189,189,224,2,151,196,122,173,251,64,31,137,51,134,191,48,102,131,227,109,184,44,251,5,149,162,187,5,170,34,140,143,105,130,225,120,167,222,119,181,80,179,43,205,87,5,28,77,240,19,94,28,244,85,80,247,14,70,240,6,103,223,16,196,46,130,119,49,125,113,82,40,179,84,187,90,118,234,207,250,220,39,32,35,79,77,254,108,51,140,177,36,252,120,213,217,252,132,96,39,142,123,148,111,111,72,70,122,62,38,145,163,111,94,174,240,220,102,21,129,81,90,180,176,103,132,221,153,221,42,45,205,104,81,255,106,32,66,78,114,186,86,25,138,223,51,159,111,180,180,79,185,102,164,127,201,238,186,232,217,153,165,245,159,243,45,95,245,239,129,235,27,51,207,64,179,150,182,21,161,73,193,52,151,144,37,66,54,5},
  {148,133,226,134,119,29,72,100,80,13,1,192,234,247,180,131,34,7,120,163,207,75,227,57,224,43,6,143,99,47,46,122,163,187,4,188,232,18,233,53,10,0,248,101,35,154,210,195,138,225,42,100,166,252,97,107,239,183,11,167,160,71,52,150,86,124,112,31,15,17,106,71,81,228,143,244,178,60,145,236,107,90,22,14,175,34,87,12,67,103,230,59,9,119,67,53,206,134,111,75,59,46,255,212,65,77,136,208,105,128,246,117,8,226,94,191,230,243,174,249,157,225,231,91,40,185,67,201,195,102,44,226,10,226,19,210,129,40,11,14,39,65,54,140,71,202,139,181,125,236,146,233,209,207,88,142,143,100,214,71,221,4,99,168,49,2,76,83,10,96,35,40,58,2,58,219,140,65,179,33,11,192,107,129,143,124,148,252,61,227,92,229,137,174,210,118,224,1,216,34,27,252,120,209,170,66,157,30,42,89,222,96,90,69,119,141,127,83,123,219,211,251,239,152,58,178,47,224,186,185,224,131,91,5,250,150,249,74,200,124,254,69,83,240,57,73,246,56,222,157,212,77,181,178,57,136,124,3,164,19,32,15,201,229,242,64,35,192,48,120,189,201,137,234,163,167,65,192,213,85,166,9,176,194,229,121,107,161,106,143,11,212,121,238,108,24,5,199,134,148,152,168,226,119,17,146,60,106,97,116,255,251,160,245,123,116,189,154,67,216,174,230,30,199,118,51,3,32,71,191,159,133,97,161,84,14,123,98,5,134,77,224,187,116,197,143,233,80,150,59,243,42,35,80,125,241,80,219,127,164,185,21,79,79,228,106,197,79,199,197,27,240,20,238,26,225,235,33,223,32,37,44,8,243,127,136,103,135,196,110,86,85,0,10,127,230,57,127,73,233,58,221,124,184,18,199,112,62,124,151,152,89,183,25,67,83,217,219,25,73,8,203,192,95,60,71,220,62,213,189,149,88,91,135,199,255,78,65,102,254,119,41,211,38,59,13,5,139,101,61,60,139,125,193,241,58,146,55,55,172,143,212,151,173,48,33,174,41,27,251,81,81,172,25,1,172,224,116,221,233,150,0,93,6,103,183,15,223,43,136,51,133,14,214,109,90,131,24,158,187,119,117,212,66,68,201,59,212,33,156,239,233,84,57,43,116,174,31,251,167,229,136,59,149,117,210,4,206,128,236,79,83,158,213,232,185,40,244,105,119,205,46,228,8,15,151,65,137,6,83,40,137,114,46,194,157,22,156,121,46,157,237,211,36,76,114,240,76,97,100,76,94,6,15,89,84,137,44,43,235,83,197,218,52,69,66,119,215,188,77,157,225,69,85,180,45,60,104,6,237,196,144,1,251,158,162,174,87,230,167,68,97,182,184,55,142,160,102,2,151,242,135,192,141,251,30,172,4,59,27,171,84,105,185,48,108,109,228,196,11,185,240,180,172,169,183,68,74,83,155,234,218,177,40,88,60,39,114,117,81,117,208,255,147,149,181,119,214,210,162,232,136,155,3,37,106,158,164,223,132,7,167,40,213,252,157,130,178,11,64,38,19,15,69,242,14,11,244,113,151,151,239,155,185,220,5,209,5,0,165,142,217,151,234,95,183,19,55,39,158,161,188,155,164,249,59,182,163,202,51,90,254,79,138,55,58,220,19,1,161,167,117,127,8,204,127,16,62,255,203,162,211,163,114,61,236,145,214,78,11,116,68,112,19,154,0,170,220,228,203,203,204,125,193,128,48,247,109,110,132,234,76,62,142,247,198,61,139,116,220,165,208,134,37,187,13,195,10,80,31,168,129,99,254,177,44,22,171,166,191,204,245,23,222,123,49,191,45,90,177,18,19,82,167,73,116,195,167,155,22,146,165,251,37,136,129,36,37,144,26,196,60,163,30,220,88,111,139,219,124,65,199,127,155,49,184,8,200,144,113,144,200,56,20,212,63,229,7,211,208,253,152,69,85,178,138,58,29,138,222,215,96,38,178,197,158,162,3,107,151,116,53,28,225,100,247,170,174,129,128,159,217,188,190,225,74,47,39,1,213,118,7,15,103,234,41,86,9,179,233,193,227,192,182,11,95,79,201,152,103,223,56,78,58,125,221,12,169,54,202,192,13,199,44,103,231,20,3,86,248,249,65,37,113,226,11,148,232,107,128,235,147,89,113,73,3,235,40,0,191,166,29,136,164,142,158,101,223,19,121,163,80,215,201,200,51,218,181,44,11,214,251,251,115,96,140,16,207,100,58,119,166,187,73,138,14,221,22,14,160,41,94,17,225,11,135,62,32,205,104,145,87,228,89,216,67,227,133,29,108,161,126,213,152,203,208,6,110,157,195,245,138,214,22,43,220,183,102,217,13,230,118,229,74,78,115,20,87,227,18,60,150,202,94,127,117,251,46,0,244,154,140,86,97,60,81,240,39,239,247,78,51,39,183,214,198,117,48,97,87,181,183,26,251,29,97,50,161,159,150,113,35,225,130,92,119,134,76,13,163,221,205,70,202,34,64,136,178,8,195,236,216,208,208,190,189,229,118,69,240,146,161,196,174,91,198,65,217,7,55,108,124,177,169,218,113,13,125,143,78,152,143,230,86,159,247,42,91,125,155,28,68,94,239,188,251,83,153,132,149,80,98,246,167,206,114,189,50,30,172,64,203,195,139,49,58,237,14,215,243,250,150,246,96,112,212,157,150,89,30,19,29,227,146,69,60,47,114,224,216,159,85,140,11,200,77,92,53,81,135,178,51,154,247,43,141,84,3,101,169,123,54,57,194,134,107,235,234,201,105,218,5,13,113,208,130,99,150,11,111,145,19,206,41,3,39,158,200,175,27,4,252,11,139,27,202,189,117,86,78,50,79,82,128,83,181,166,109,68,175,28,78,27,44,20,3,102,10,139,175,187,246,183,113,99,144,129,133,201,168,237,134,225,174,188,242,216,171,77,141,172,186,179,170,205,107,249,234,202,170,134,31,58,190,42,108,193,203,254,197,131,114,211,203,158,141,191,200,95,220,66,20,189,186,228,184,163,162,159,61,16,169,214,77,75,204,234,32,246,29,185,52,45,53,170,104,182,81,251,13,221,149,182,173,127,44,31,109,9,143,32,192,46,213,163,1,73,203,146,228,28,164,6,129,114,172,4,42,60,52,173,29,189,15,77,136,156,244,76,188,114,174,87,84,51,83,88,0,254,148,221,255,40,6,152,64,230,20,6,24,212,109,218,239,50,114,230,109,100,238,20,93,230,160,29,16,68,134,62,56,24,208,175,98,255,52,108,253,249,237,125,129,6,236,56,220,171,158,120,200,235,142,218,105,245,150,29,116,90,77,204,211,250,93,178,82,47,129,132,84,63,131,167,242,165,93,34,32,147,222,224,218,21,42,107,201,162,58,84,44,145,207,99,161,195,25,220,19,112,215,247,181,247,68,18,249,228,150,171,45,77,143,97,241,228,90,94,49,12,14,206,160,152,31,234,214,198,245,23,201,195,162,227,251,156,123,166,248,216,69,112,138,4,8,48,63,199,177,125,247,79,51,147,197,187,240,176,97,111,142,0,204,212,181,207,60,223,206,67,159,236,96,227,98,120,198,238,130,73,144,227,28,27,10,156,125,196,11,166,201,212,51,255,118,133,147,187,128,224,136,112,177,161,101,126,77,183,207,18,78,205,220,135,99,157,48,16,136,21,186,207,55,87,222,158,158,162,82,207,115,146,35,137,56,135,43,158,155,194,113,176,177,200,56,85,149,230,181,6,191,6,122,243,233,32,84,141,136,96,67,74,41,30,231,171,91,232,170,232,197,237,140,7,25,98,18,145,86,116,9,141,79,75,215,116,12,146,88,194,124,179,231,131,220,200,57,157,208,14,104,213,175,98,65,56,242,240,189,51,226,206,159,219,38,179,142,56,192,59,59,44,129,76,109,202,52,230,227,87,145,52,205,239,105,97,103,117,137,128,164,113,205,78,113,225,142,157,58,142,248,51,74,72,250,166,204,142,0,24,98,128,255,206,67,6,191,42,13,132,233,227,246,52,205,160,23,52,38,29,120,105,183,209,11,134,58,144,143,145,97,164,57,113,6,124,184,68,102,29,155,36,109,186,67,49,56,75,57,72,222,166,183,180,130,11,67,81,129,244,144,57,38,249,117,165,158,145,165,245,7,63,118,223,31,101,46,138,148,204,201,94,150,111,20,111,72,132,227,34,150,88,60,255,51,107,164,208,155,144,212,55,108,250,20,66,134,13,95,180,176,113,145,109,104,253,144,175,81,162,47,151,160,190,13,57,113,183,77,142,21,166,199,29,119,128,217,4,192,127,197,127,120,23,119,123,180,77,27,169,138,214,116,35,110,213,147,218,146,190,107,77,244,211,14,200,10,188,131,105,20,214,141,89,21,127,49,1,180,82,57,111,23,89,182,115,52,224,181,164,161,241,253,19,208,40,224,200,172,88,64,209,206,23,72,26,180,47,171,63,102,143,129,205,161,247,134,152,61,62,76,56,112,104,24,30,31,217,255,188,11,114,69,251,67,238,234,194,98,81,239,58,191,173,51,190,113,104,8,250,211,68,71,223,9,71,110,39,174,239,238,25,216,129,63,3,106,254,5,74,81,113,11,44,253,62,184,97,250,245,150,101,111,9,149,132,199,184,22,34,30,213,7,121,157,221,213,38,104,53,27,236,241,133,225,96,75,254,121,253,23,224,34,245,104,212,77,129,72,66,242,88,174,44,161,100,86,50,147,78,117,165,76,19,8,249,108,177,78,194,93,210,107,87,186,17,21,221,33,86,71,36,123,82,107,20,229,155,251,160,234,51,228,163,93,45,227,139,96,52,213,63,183,243,96,154,27,66,79,217,46,182,40,159,174,40,121,63,52,49,17,44,74,179,177,68,46,44,10,27,225,146,14,213,86,193,134,176,221,25,118,156,87,57,141,206,99,205,72,34,172,99,235,150,71,239,98,21,85,81,186,20,196,142,254,209,56,191,123,199,229,134,12,82,220,193,157,191,86,244,235,224,180,172,228,178,104,31,155,184,73,31,115,37,128,41,212,171,142,201,39,252,74,234,109,58,146,47,83,228,221,85,239,220,217,219,230,152,96,198,208,145,97,159,137,195,90,100,234,213,112,0,31,164,176,200,60,99,51,139,220,14,87,203,92,79,209,23,240,94,158,48,130,170,80,242,107,151,77,151,3,234,247,115,9,159,177,254,253,70,23,191,142,238,95,72,166,124,125,224,161,146,3,71,7,161,193,201,48,240,107,242,188,179,156,241,193,91,186,235,211,71,246,91,130,141,30,104,60,135,198,27,103,89,206,204,213,12,93,242,55,181,18,74,238,17,232,215,2,208,172,108,55,144,239,209,38,250,129,101,146,179,24,151,160,194,137,186,117,223,178,28,87,195,32,175,44,9,217,205,138,9,135,147,31,134,129,207,42,158,13,6,130,80,113,202,166,66,116,189,22,94,66,180,252,43,231,168,84,29,237,50,190,62,96,138,254,189,25,137,139,90,141,235,51,5,194,146,44,19,141,100,215,42,30,38,26,189,226,129,247,210,126,120,173,104,95,197,65,16,248,0,85,52,56,172,232,70,127,87,54,30,253,107,70,2,248,255,128,193,250,67,77,167,233,94,210,139,56,203,8,153,158,117,132,126,213,103,64,19,234,180,127,82,55,254,135,37,36,254,234,251,59,132,19,7,244,44,186,51,26,17,251,20,196,8,232,96,91,198,220,167,11,38,53},
  {185,203,94,140,29,229,103,231,171,59,216,74,168,209,38,44,92,244,148,143,198,93,243,213,59,109,242,140,204,47,144,60,141,75,16,239,52,224,5,84,98,244,75,127,108,215,177,35,208,153,189,5,148,66,194,102,56,47,159,209,170,188,254,11,226,193,140,179,12,12,82,220,84,201,30,129,255,193,26,233,21,180,181,194,242,49,64,203,156,24,226,39,251,93,146,49,146,182,93,39,180,101,72,181,109,23,206,63,27,130,75,135,31,128,61,184,155,8,72,5,198,77,251,180,26,246,48,149,187,212,240,104,90,106,199,50,131,239,75,95,117,254,225,238,200,30,239,48,21,33,153,154,78,93,141,243,106,28,230,233,47,170,148,193,96,45,66,244,211,142,111,24,113,14,175,205,32,28,58,69,88,213,191,204,31,179,167,235,248,122,172,226,10,15,13,90,7,125,130,200,70,2,37,239,213,115,54,79,197,169,145,127,186,126,152,33,137,32,119,252,226,135,9,202,43,65,52,212,158,59,88,243,114,106,182,98,142,36,69,25,51,152,54,170,123,21,41,110,104,95,246,7,19,168,121,25,66,198,35,115,134,78,70,200,2,111,140,42,230,198,218,215,32,153,160,162,84,182,252,149,159,245,185,23,172,4,90,85,59,178,213,51,67,211,17,85,88,253,164,148,160,210,46,107,4,80,148,248,147,58,80,54,217,14,108,164,228,16,193,233,119,5,57,180,231,62,37,139,41,56,114,207,79,219,204,219,87,215,152,60,154,242,152,25,24,214,203,248,181,15,144,82,77,120,199,17,250,252,58,117,79,186,193,68,63,161,114,146,22,140,118,173,225,179,224,232,75,76,53,31,0,241,52,112,43,58,222,79,108,94,62,196,98,21,83,206,113,15,148,206,46,128,61,37,190,85,201,171,203,143,212,114,73,21,93,2,207,108,215,47,235,156,61,40,226,148,62,225,18,73,195,232,130,206,36,70,45,28,216,32,138,164,60,166,173,40,103,204,168,171,68,248,77,15,98,89,88,80,92,82,87,5,26,240,0,247,211,4,193,44,189,43,91,167,181,144,55,155,23,11,17,189,174,175,24,22,239,64,7,177,179,123,216,54,74,86,63,133,38,189,219,199,138,185,225,48,132,85,187,22,156,60,202,103,132,10,208,219,55,164,66,160,217,216,181,142,19,125,195,243,244,82,53,47,44,246,14,163,247,168,20,69,183,46,2,62,97,176,53,23,67,160,191,233,218,144,5,45,180,217,70,19,150,23,8,175,204,119,222,225,63,202,1,178,93,1,243,195,61,124,7,78,205,121,177,192,83,196,93,142,45,15,177,111,133,62,88,135,223,23,70,86,46,180,68,163,161,74,143,244,196,177,75,165,74,108,234,199,39,125,165,9,47,9,238,26,223,192,72,38,206,90,224,227,230,14,3,205,132,165,234,21,126,53,215,112,159,180,99,237,30,181,234,169,109,224,226,86,77,140,105,215,236,43,238,96,138,232,252,236,143,217,2,199,152,116,252,37,84,63,190,75,53,177,170,175,204,39,165,132,99,80,27,207,208,53,22,168,48,189,37,217,234,188,97,6,37,207,171,205,23,121,16,75,40,10,129,57,182,129,130,49,253,7,237,9,178,110,197,114,228,39,46,101,127,102,40,205,252,94,184,170,239,55,166,101,38,185,168,44,78,1,54,233,214,32,203,167,130,93,244,85,220,53,243,96,192,36,249,109,87,132,118,138,142,177,153,42,117,201,30,228,78,96,205,31,118,80,249,85,46,30,27,107,156,222,217,178,103,164,137,113,157,204,145,56,51,203,107,193,250,115,122,217,110,82,207,204,230,40,0,234,59,43,187,31,138,143,58,234,195,211,211,65,147,49,82,187,29,193,248,19,122,149,76,62,18,110,152,143,40,130,250,209,238,247,255,107,9,54,7,49,36,227,11,248,217,154,226,214,56,111,243,212,194,93,73,126,63,244,26,28,36,174,58,231,121,103,20,132,14,22,30,176,208,20,220,113,191,88,241,154,98,111,77,190,189,4,217,22,196,219,186,112,85,7,22,126,145,232,54,17,164,247,202,18,106,66,192,131,56,190,6,160,144,38,103,93,48,98,225,200,79,61,251,118,84,62,156,149,143,161,208,236,247,83,24,199,250,1,181,95,121,211,220,87,248,88,244,124,184,5,237,85,96,213,75,195,133,129,134,73,198,254,26,234,177,1,203,96,56,187,156,69,37,46,178,2,40,149,159,79,112,247,251,101,203,249,34,26,135,89,180,235,87,114,144,50,115,170,236,158,104,48,169,218,107,154,177,87,150,12,194,246,170,69,44,204,149,212,167,210,157,135,237,3,120,30,186,30,201,240,151,45,125,43,70,200,193,169,63,20,95,134,93,243,75,131,168,143,119,121,175,57,155,109,19,120,68,147,190,79,26,151,58,142,222,23,77,253,187,67,13,76,48,226,47,245,179,180,234,114,187,82,152,47,227,210,71,95,145,10,62,133,186,29,137,5,124,190,222,155,109,45,58,121,229,119,99,18,13,160,220,52,172,98,133,178,35,108,175,45,117,187,36,196,79,172,31,207,75,254,72,135,163,177,176,172,93,126,209,206,25,18,247,21,219,208,22,85,27,94,221,61,198,163,251,149,240,109,184,51,1,77,53,111,233,179,225,56,148,150,152,224,153,126,135,55,187,162,56,26,214,239,41,160,103,104,91,86,29,54,201,62,36,118,59,154,11,167,242,138,83,122,146,197,11,44,252,221,30,209,205,235,70,215,65,252,128,112,222,226,198,88,81,145,108,143,1,158,60,222,33,54,74,228,110,26,184,47,79,199,125,245,168,75,223,116,185,127,59,124,137,249,68,230,203,88,39,87,80,27,67,221,76,120,201,60,179,130,103,68,193,254,109,173,247,229,75,108,166,147,75,1,124,100,195,247,88,227,25,208,2,183,106,149,119,163,51,61,244,145,39,123,155,231,247,139,142,37,137,209,19,238,111,132,121,76,112,72,180,182,106,171,98,109,124,147,220,59,129,12,28,220,127,136,55,181,239,225,42,95,108,159,238,99,13,33,39,97,148,153,188,203,66,157,131,51,245,254,45,96,51,238,32,201,72,21,132,9,4,228,109,163,150,56,53,129,85,204,158,125,202,183,132,172,229,88,176,193,180,168,125,236,218,143,2,79,0,165,183,237,88,63,125,244,136,231,70,175,187,135,149,228,134,119,246,229,52,82,92,180,99,202,99,145,16,245,207,247,207,191,55,192,169,249,51,66,60,119,53,43,136,99,228,214,34,77,222,200,161,125,19,67,138,14,252,33,116,103,205,25,155,116,156,65,32,163,4,127,96,79,3,163,254,123,167,19,42,59,98,211,37,171,62,126,56,144,81,35,147,102,169,191,219,189,169,242,193,87,54,84,119,155,253,182,38,33,167,130,231,107,24,207,183,77,172,70,121,200,120,15,71,88,114,60,246,154,201,154,198,163,143,244,212,206,134,128,219,87,57,223,38,203,9,156,234,125,200,241,231,105,89,20,241,180,143,202,149,37,56,200,189,137,117,100,105,16,127,61,38,217,210,104,25,169,101,65,37,65,113,187,174,173,92,173,181,41,183,213,214,62,191,143,80,156,7,150,218,87,140,70,28,30,185,203,92,119,163,143,60,123,192,65,82,221,2,189,99,94,233,190,223,211,77,176,214,102,165,168,238,122,255,105,238,207,105,123,63,195,210,187,113,62,127,99,83,206,197,96,193,240,204,60,108,41,120,106,42,41,146,180,105,15,52,205,46,174,126,167,246,83,173,174,233,9,94,190,250,72,124,222,140,10,137,75,173,158,209,137,67,27,94,41,229,249,9,228,107,52,61,10,208,180,130,166,246,150,26,111,72,191,185,165,222,116,215,43,191,167,116,80,213,221,175,223,77,28,124,130,13,68,146,33,224,56,140,215,29,77,227,161,126,113,188,252,215,187,37,117,191,111,192,249,219,110,42,68,166,254,94,129,178,159,40,113,212,175,50,11,245,167,69,25,97,245,14,201,186,64,253,73,227,97,254,159,31,36,18,75,206,116,119,65,19,176,45,237,246,7,5,88,170,15,209,28,232,110,22,107,242,88,157,149,145,15,116,16,82,156,36,96,170,227,63,172,48,185,40,1,42,214,68,128,116,113,173,31,215,231,85,146,46,237,58,252,245,45,254,67,226,143,178,92,39,87,27,53,60,97,104,128,63,11,241,158,15,234,141,45,96,175,211,79,185,141,239,24,170,191,239,162,89,55,146,74,108,95,128,148,158,165,226,106,40,85,234,218,246,199,159,178,86,241,91,115,33,137,202,10,94,111,45,19,225,231,225,148,166,104,210,56,46,220,150,250,147,58,88,85,5,65,234,48,95,233,221,37,212,186,236,25,19,8,184,59,194,228,193,165,237,227,248,30,112,158,135,161,138,113,223,243,228,114,2,236,78,163,208,198,140,237,122,117,124,147,129,207,61,232,7,43,62,170,48,184,85,195,15,214,21,78,217,172,138,122,153,102,154,133,250,223,124,153,34,117,236,97,255,128,204,84,43,163,224,234,123,123,138,20,141,72,209,164,70,70,173,41,45,202,102,230,193,48,149,114,73,120,88,210,92,171,113,212,152,180,242,244,205,236,105,233,242,175,173,216,217,209,188,107,173,181,167,128,56,210,176,80,186,154,240,111,213,117,141,29,223,229,214,108,202,77,120,140,58,219,90,52,216,234,133,80,161,200,45,29,34,158,96,37,50,121,131,153,142,67,12,39,149,103,130,16,251,42,177,13,32,158,162,35,197,14,210,45,174,184,217,65,214,61,180,152,70,173,46,100,103,242,196,122,157,45,199,219,38,71,202,6,140,107,119,229,128,159,121,101,80,113,203,84,200,110,217,244,105,195,247,223,94,9,60,185,162,122,132,111,246,194,64,181,137,117,34,239,145,76,45,74,32,93,106,150,11,201,76,31,81,119,160,203,228,152,58,8,105,85,24,3,112,12,96,97,46,72,233,8,101,38,132,31,130,123,174,28,101,209,224,215,51,234,58,88,19,247,201,136,224,95,136,200,44,172,233,151,245,127,214,47,183,0,19,108,182,20,87,250,14,135,249,170,142,204,101,112,130,230,52,15,7,169,75,247,135,162,104,79,150,24,30,87,32,203,71,22,111,196,181,122,65,82,196,219,186,140,21,48,234,249,69,104,156,61,163,96,119,40,128,175,155,40,83,20,108,193,173,56,160,40,231,60,63,218,228,228,128,56,235,83,99,52,193,85,213,16,180,94,236,75,43,193,175,145,103,12,57,211,156,10,114,160,22,202,102,228,75,111,74,123,91,108,167,133,123,105,208,137,127,154,170,167,179,12,195,87,145,27,68,23,153,106,246,184,140,245,234,6,225,118,103,18,13,89,128,8,85,50,57,154,208,142,39,148,84,179,45,29,5,153,231,181,176,237,194,125,184,5,130,214,156,129,10,8,111,195,31,81,164,128,9,6,210,158,170,29,116,87,108,129,5,202,41,158,245,248,212,24,10,202,202,71,232,59,164,14,161,163,188,46,180,142,139,218,65,57,192,75,180,129,197,117,10,47,102,103,230,90,33,137,90,31,223,188,200,237,138,252,53,28,72,195,121,198,52,181,129,160,253,71,214,223,241,129,159,252,91,31,14,19,219,164,248,117,223,57,73,65,100,101,182,186,3,146,105,127,124,154,2,255,235,84,53,108,125,208},
} ;

static void test_decode_1277xint16_impl(long long impl)
{
  unsigned char *x = test_decode_1277xint16_x;
  unsigned char *s = test_decode_1277xint16_s;
  unsigned char *x2 = test_decode_1277xint16_x2;
  unsigned char *s2 = test_decode_1277xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1277xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1277xint16(impl);
    printf("decode_1277xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277xint16_implementation(impl),ntruprime_dispatch_decode_1277xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1277xint16;
    printf("decode_1277xint16 selected implementation %s compiler %s\n",ntruprime_decode_1277xint16_implementation(),ntruprime_decode_1277xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1277xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1277xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1277xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1277xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1277xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1277xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1277xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277xint16")) return;
  storage_decode_1277xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1277xint16_x = aligned(storage_decode_1277xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1277xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1277xint16_s = aligned(storage_decode_1277xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1277xint16_x2 = callocplus(maxalloc);
  test_decode_1277xint16_x2 = aligned(storage_decode_1277xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1277xint16_s2 = callocplus(maxalloc);
  test_decode_1277xint16_s2 = aligned(storage_decode_1277xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1277xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1277xint16();++impl)
      forked(test_decode_1277xint16_impl,impl);
    ++test_decode_1277xint16_x;
    ++test_decode_1277xint16_s;
    ++test_decode_1277xint16_x2;
    ++test_decode_1277xint16_s2;
  }
  free(storage_decode_1277xint16_s2);
  free(storage_decode_1277xint16_x2);
  free(storage_decode_1277xint16_s);
  free(storage_decode_1277xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

