/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.text.JPlaceholder;
import com.jsql.view.swing.util.UiUtil;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JTextFieldPlaceholder
extends JTextField
implements JPlaceholder {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String placeholderText;
    private int xOffset;

    public JTextFieldPlaceholder(String placeholder, String value) {
        this(placeholder);
        this.setText(value);
    }

    public JTextFieldPlaceholder(String placeholder) {
        this.placeholderText = placeholder;
    }

    public JTextFieldPlaceholder(String placeholder, int xOffset) {
        this(placeholder);
        this.xOffset = xOffset;
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (ClassCastException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        if (this.getText().isEmpty()) {
            int h = this.getHeight();
            FontMetrics fm = g.getFontMetrics();
            UiUtil.drawPlaceholder(this, g, this.placeholderText, this.xOffset, h / 2 + fm.getAscent() / 2 - 1);
        }
    }

    @Override
    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
    }
}

