// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package marketplaceagreementiface provides an interface to enable mocking the AWS Marketplace Agreement Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package marketplaceagreementiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/marketplaceagreement"
)

// MarketplaceAgreementAPI provides an interface to enable mocking the
// marketplaceagreement.MarketplaceAgreement service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Marketplace Agreement Service.
//	func myFunc(svc marketplaceagreementiface.MarketplaceAgreementAPI) bool {
//	    // Make svc.DescribeAgreement request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := marketplaceagreement.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockMarketplaceAgreementClient struct {
//	    marketplaceagreementiface.MarketplaceAgreementAPI
//	}
//	func (m *mockMarketplaceAgreementClient) DescribeAgreement(input *marketplaceagreement.DescribeAgreementInput) (*marketplaceagreement.DescribeAgreementOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockMarketplaceAgreementClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MarketplaceAgreementAPI interface {
	DescribeAgreement(*marketplaceagreement.DescribeAgreementInput) (*marketplaceagreement.DescribeAgreementOutput, error)
	DescribeAgreementWithContext(aws.Context, *marketplaceagreement.DescribeAgreementInput, ...request.Option) (*marketplaceagreement.DescribeAgreementOutput, error)
	DescribeAgreementRequest(*marketplaceagreement.DescribeAgreementInput) (*request.Request, *marketplaceagreement.DescribeAgreementOutput)

	GetAgreementTerms(*marketplaceagreement.GetAgreementTermsInput) (*marketplaceagreement.GetAgreementTermsOutput, error)
	GetAgreementTermsWithContext(aws.Context, *marketplaceagreement.GetAgreementTermsInput, ...request.Option) (*marketplaceagreement.GetAgreementTermsOutput, error)
	GetAgreementTermsRequest(*marketplaceagreement.GetAgreementTermsInput) (*request.Request, *marketplaceagreement.GetAgreementTermsOutput)

	GetAgreementTermsPages(*marketplaceagreement.GetAgreementTermsInput, func(*marketplaceagreement.GetAgreementTermsOutput, bool) bool) error
	GetAgreementTermsPagesWithContext(aws.Context, *marketplaceagreement.GetAgreementTermsInput, func(*marketplaceagreement.GetAgreementTermsOutput, bool) bool, ...request.Option) error

	SearchAgreements(*marketplaceagreement.SearchAgreementsInput) (*marketplaceagreement.SearchAgreementsOutput, error)
	SearchAgreementsWithContext(aws.Context, *marketplaceagreement.SearchAgreementsInput, ...request.Option) (*marketplaceagreement.SearchAgreementsOutput, error)
	SearchAgreementsRequest(*marketplaceagreement.SearchAgreementsInput) (*request.Request, *marketplaceagreement.SearchAgreementsOutput)

	SearchAgreementsPages(*marketplaceagreement.SearchAgreementsInput, func(*marketplaceagreement.SearchAgreementsOutput, bool) bool) error
	SearchAgreementsPagesWithContext(aws.Context, *marketplaceagreement.SearchAgreementsInput, func(*marketplaceagreement.SearchAgreementsOutput, bool) bool, ...request.Option) error
}

var _ MarketplaceAgreementAPI = (*marketplaceagreement.MarketplaceAgreement)(nil)
