/*
 * Copyright 2021 Free Software Foundation, Inc.
 * Copyright 2022 Marcus Müller
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(message_debug.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(6f4bb7d39b43ec95fce8da7dbc15bd7b)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <spdlog/common.h>

namespace py = pybind11;

#include <gnuradio/blocks/message_debug.h>
// pydoc.h is automatically generated in the build directory
#include <message_debug_pydoc.h>

void bind_message_debug(py::module& m)
{

    using message_debug = ::gr::blocks::message_debug;


    py::class_<message_debug, gr::block, gr::basic_block, std::shared_ptr<message_debug>>(
        m, "message_debug", D(message_debug))

        .def(py::init(&message_debug::make),
             py::arg("en_uvec") = true,
             py::arg("level") = spdlog::level::info,
             D(message_debug, make))


        .def("num_messages", &message_debug::num_messages, D(message_debug, num_messages))


        .def("get_message",
             &message_debug::get_message,
             py::arg("i"),
             D(message_debug, get_message))


        .def("set_vector_print",
             &message_debug::set_vector_print,
             py::arg("en"),
             D(message_debug, set_vector_print))

        .def_property(
            "level",
            [](const message_debug& instance) { return instance.level(); },
            [](message_debug& instance, spdlog::level::level_enum level) {
                instance.set_level(level);
            })

        ;
}
