//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor

import "encoding/json"

func unmarshalMetricAlertCriteriaClassification(rawMsg json.RawMessage) (MetricAlertCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MetricAlertCriteriaClassification
	switch m["odata.type"] {
	case string(OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria):
		b = &MetricAlertMultipleResourceMultipleMetricCriteria{}
	case string(OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria):
		b = &MetricAlertSingleResourceMultipleMetricCriteria{}
	case string(OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria):
		b = &WebtestLocationAvailabilityCriteria{}
	default:
		b = &MetricAlertCriteria{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalMultiMetricCriteriaClassification(rawMsg json.RawMessage) (MultiMetricCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b MultiMetricCriteriaClassification
	switch m["criterionType"] {
	case string(CriterionTypeDynamicThresholdCriterion):
		b = &DynamicMetricCriteria{}
	case string(CriterionTypeStaticThresholdCriterion):
		b = &MetricCriteria{}
	default:
		b = &MultiMetricCriteria{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalMultiMetricCriteriaClassificationArray(rawMsg json.RawMessage) ([]MultiMetricCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]MultiMetricCriteriaClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalMultiMetricCriteriaClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalRuleActionClassification(rawMsg json.RawMessage) (RuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RuleActionClassification
	switch m["odata.type"] {
	case "Microsoft.Azure.Management.Insights.Models.RuleEmailAction":
		b = &RuleEmailAction{}
	case "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction":
		b = &RuleWebhookAction{}
	default:
		b = &RuleAction{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRuleActionClassificationArray(rawMsg json.RawMessage) ([]RuleActionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]RuleActionClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalRuleActionClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalRuleConditionClassification(rawMsg json.RawMessage) (RuleConditionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RuleConditionClassification
	switch m["odata.type"] {
	case "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition":
		b = &LocationThresholdRuleCondition{}
	case "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition":
		b = &ManagementEventRuleCondition{}
	case "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition":
		b = &ThresholdRuleCondition{}
	default:
		b = &RuleCondition{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalRuleDataSourceClassification(rawMsg json.RawMessage) (RuleDataSourceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RuleDataSourceClassification
	switch m["odata.type"] {
	case "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource":
		b = &RuleManagementEventDataSource{}
	case "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource":
		b = &RuleMetricDataSource{}
	default:
		b = &RuleDataSource{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
