//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// EdgeNodesClient contains the methods for the EdgeNodes group.
// Don't use this type directly, use NewEdgeNodesClient() instead.
type EdgeNodesClient struct {
	host string
	pl   runtime.Pipeline
}

// NewEdgeNodesClient creates a new instance of EdgeNodesClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewEdgeNodesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*EdgeNodesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &EdgeNodesClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// NewListPager - Edgenodes are the global Point of Presence (POP) locations used to deliver CDN content to end users.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-06-01
// options - EdgeNodesClientListOptions contains the optional parameters for the EdgeNodesClient.List method.
func (client *EdgeNodesClient) NewListPager(options *EdgeNodesClientListOptions) *runtime.Pager[EdgeNodesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[EdgeNodesClientListResponse]{
		More: func(page EdgeNodesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *EdgeNodesClientListResponse) (EdgeNodesClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return EdgeNodesClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return EdgeNodesClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return EdgeNodesClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *EdgeNodesClient) listCreateRequest(ctx context.Context, options *EdgeNodesClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Cdn/edgenodes"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *EdgeNodesClient) listHandleResponse(resp *http.Response) (EdgeNodesClientListResponse, error) {
	result := EdgeNodesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EdgenodeResult); err != nil {
		return EdgeNodesClientListResponse{}, err
	}
	return result, nil
}
