# Generated by Django 3.1.11 on 2021-06-01 18:04

from django.core.management import call_command
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0105_endpoint_host_migration'),
    ]

    def populate_roles(apps, schema_editor):
        call_command('loaddata', 'role')

    operations = [
        # Needed to change the id of the Reader role from 0 to 5 to avoid an error with MySQL
        migrations.RunSQL("UPDATE dojo_product_member SET role = 5 WHERE (role = 0)"),
        migrations.RunSQL("UPDATE dojo_product_group SET role = 5 WHERE (role = 0)"),
        migrations.RunSQL("UPDATE dojo_product_type_member SET role = 5 WHERE (role = 0)"),
        migrations.RunSQL("UPDATE dojo_product_type_group SET role = 5 WHERE (role = 0)"),

        # Create the table for the role
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('is_owner', models.BooleanField(default=False)),
            ],
            options={'ordering': ('name',)},
        ),

        # Insert the five predefined roles in the database
        migrations.RunPython(populate_roles),

        # Only now we can alter the remaining tables, otherwise we would break referential integrity
        migrations.AlterField(
            model_name='product_group',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.role'),
        ),
        migrations.AlterField(
            model_name='product_member',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.role'),
        ),
        migrations.AlterField(
            model_name='product_type_group',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.role'),
        ),
        migrations.AlterField(
            model_name='product_type_member',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.role'),
        ),
    ]
