// SPDX-FileCopyrightText: 2008, 2011 Brad Hards <bradh@frogmouth.net>
// SPDX-License-Identifier: BSD-2-Clause

#include "controlword.h"

enum control_word_types {
    Symbol,
    Flag,
    Value,
    Toggle,
    Destination
};

struct control_word_known {
    const char *controlword;
    enum control_word_types wordtype;
};

/* possible things to add:

*/
const static struct control_word_known known_control_words[] = {{"\'", Symbol},
                                                                {"-", Symbol},
                                                                {"*", Symbol},
                                                                {":", Symbol},
                                                                {"\\", Symbol},
                                                                {"_", Symbol},
                                                                {"{", Symbol},
                                                                {"|", Symbol},
                                                                {"}", Symbol},
                                                                {"~", Symbol},
                                                                {"ab", Toggle},
                                                                {"absh", Value},
                                                                {"abslock", Flag},
                                                                {"absnoovrlp", Toggle},
                                                                {"absw", Value},
                                                                {"acaps", Toggle},
                                                                {"acccircle", Toggle},
                                                                {"acccomma", Toggle},
                                                                {"accdot", Toggle},
                                                                {"accnone", Toggle},
                                                                {"accunderdot", Toggle},
                                                                {"acf", Value},
                                                                {"adeff", Value},
                                                                {"additive", Flag},
                                                                {"adeflang", Value},
                                                                {"adjustright", Flag},
                                                                {"adn", Value},
                                                                {"aenddoc", Flag},
                                                                {"aendnotes", Flag},
                                                                {"aexpnd", Value},
                                                                {"af", Value},
                                                                {"afelev", Flag},
                                                                {"afs", Value},
                                                                {"aftnbj", Flag},
                                                                {"aftncn", Destination},
                                                                {"aftnnalc", Flag},
                                                                {"aftnnar", Flag},
                                                                {"aftnnauc", Flag},
                                                                {"aftnnchi", Flag},
                                                                {"aftnnchosung", Flag},
                                                                {"aftnncnum", Flag},
                                                                {"aftnndbar", Flag},
                                                                {"aftnndbnum", Flag},
                                                                {"aftnndbnumd", Flag},
                                                                {"aftnndbnumk", Flag},
                                                                {"aftnndbnumt", Flag},
                                                                {"aftnnganada", Flag},
                                                                {"aftnngbnum", Flag},
                                                                {"aftnngbnumd", Flag},
                                                                {"aftnngbnumk", Flag},
                                                                {"aftnngbnuml", Flag},
                                                                {"aftnnrlc", Flag},
                                                                {"aftnnruc", Flag},
                                                                {"aftnnzodiac", Flag},
                                                                {"aftnnzodiacd", Flag},
                                                                {"aftnnzodiacl", Flag},
                                                                {"aftnrestart", Flag},
                                                                {"aftnrstcont", Flag},
                                                                {"aftnsep", Destination},
                                                                {"aftnsepc", Destination},
                                                                {"aftnstart", Value},
                                                                {"aftntj", Flag},
                                                                {"ai", Toggle},
                                                                {"alang", Value},
                                                                {"allowfieldendsel", Flag},
                                                                {"allprot", Flag},
                                                                {"alntblind", Flag},
                                                                {"alt", Flag},
                                                                {"animtext", Value},
                                                                {"annotation", Destination},
                                                                {"annotprot", Flag},
                                                                {"ansi", Flag},
                                                                {"ansicpg", Value},
                                                                {"aoutl", Toggle},
                                                                {"ApplyBrkRules", Flag},
                                                                {"ascaps", Toggle},
                                                                {"ashad", Toggle},
                                                                {"asianbrkrule", Flag},
                                                                {"aspalpha", Toggle},
                                                                {"aspnum", Toggle},
                                                                {"astrike", Toggle},
                                                                {"atnauthor", Destination},
                                                                {"atndate", Destination},
                                                                {"atnicn", Destination},
                                                                {"atnid", Destination},
                                                                {"atnparent", Destination},
                                                                {"atnref", Destination},
                                                                {"atntime", Destination},
                                                                {"atrfend", Destination},
                                                                {"atrfstart", Destination},
                                                                {"aul", Toggle},
                                                                {"auld", Toggle},
                                                                {"auldb", Toggle},
                                                                {"aulnone", Toggle},
                                                                {"aulw", Toggle},
                                                                {"aup", Value},
                                                                {"author", Destination},
                                                                {"autofmtoverride", Flag},
                                                                {"b", Toggle},
                                                                {"background", Destination},
                                                                {"bdbfhdr", Flag},
                                                                {"bdrrlswsix", Flag},
                                                                {"bgbdiag", Flag},
                                                                {"bgcross", Flag},
                                                                {"bgdcross", Flag},
                                                                {"bgdkbdiag", Flag},
                                                                {"bgdkcross", Flag},
                                                                {"bgdkdcross", Flag},
                                                                {"bgdkfdiag", Flag},
                                                                {"bgdkhoriz", Flag},
                                                                {"bgdkvert", Flag},
                                                                {"bgfdiag", Flag},
                                                                {"bghoriz", Flag},
                                                                {"bgvert", Flag},
                                                                {"bin", Value},
                                                                {"binfsxn", Value},
                                                                {"binsxn", Value},
                                                                {"bkmkcolf", Value},
                                                                {"bkmkcoll", Value},
                                                                {"bkmkend", Destination},
                                                                {"bkmkpub", Flag},
                                                                {"bkmkstart", Destination},
                                                                {"bliptag", Value},
                                                                {"blipuid", Destination},
                                                                {"blipupi", Value},
                                                                {"blue", Value},
                                                                {"bookfold", Flag},
                                                                {"bookfoldrev", Flag},
                                                                {"bookfoldsheets", Value},
                                                                {"box", Flag},
                                                                {"brdrart", Value},
                                                                {"brdrb", Flag},
                                                                {"brdrbar", Flag},
                                                                {"brdrbtw", Flag},
                                                                {"brdrcf", Value},
                                                                {"brdrdash", Flag},
                                                                {"brdrdashd", Flag},
                                                                {"brdrdashdd", Flag},
                                                                {"brdrdashdot", Flag},
                                                                {"brdrdashdotdot", Flag},
                                                                {"brdrdashdotstr", Flag},
                                                                {"brdrdashsm", Flag},
                                                                {"brdrdb", Flag},
                                                                {"brdrdot", Flag},
                                                                {"brdremboss", Flag},
                                                                {"brdrengrave", Flag},
                                                                {"brdrframe", Flag},
                                                                {"brdrhair", Flag},
                                                                {"brdrinset", Flag},
                                                                {"brdrl", Flag},
                                                                {"brdrnil", Flag},
                                                                {"brdrnone", Flag},
                                                                {"brdroutset", Flag},
                                                                {"brdrr", Flag},
                                                                {"brdrs", Flag},
                                                                {"brdrsh", Flag},
                                                                {"brdrt", Flag},
                                                                {"brdrtbl", Flag},
                                                                {"brdrth", Flag},
                                                                {"brdrthtnlg", Flag},
                                                                {"brdrthtnmg", Flag},
                                                                {"brdrthtnsg", Flag},
                                                                {"brdrtnthlg", Flag},
                                                                {"brdrtnthmg", Flag},
                                                                {"brdrtnthsg", Flag},
                                                                {"brdrtnthtnlg", Flag},
                                                                {"brdrtnthtnmg", Flag},
                                                                {"brdrtnthtnsg", Flag},
                                                                {"brdrtriple", Flag},
                                                                {"brdrw", Value},
                                                                {"brdrwavy", Flag},
                                                                {"brdrwavydb", Flag},
                                                                {"brkfrm", Flag},
                                                                {"brsp", Value},
                                                                {"bullet", Symbol},
                                                                {"buptim", Destination},
                                                                {"bxe", Flag},
                                                                {"caccentfive", Flag},
                                                                {"caccentfour", Flag},
                                                                {"caccentone", Flag},
                                                                {"caccentsix", Flag},
                                                                {"caccentthree", Flag},
                                                                {"caccenttwo", Flag},
                                                                {"cachedcolbal", Flag},
                                                                {"caps", Toggle},
                                                                {"category", Destination},
                                                                {"cb", Value},
                                                                {"cbackgroundone", Flag},
                                                                {"cbackgroundtwo", Flag},
                                                                {"cbpat", Value},
                                                                {"cchs", Value},
                                                                {"cell", Symbol},
                                                                {"cellx", Value},
                                                                {"cf", Value},
                                                                {"cfollowedhyperlink", Flag},
                                                                {"cfpat", Value},
                                                                {"cgrid", Value},
                                                                {"charrsid", Value},
                                                                {"charscalex", Value},
                                                                {"chatn", Symbol},
                                                                {"chbgbdiag", Flag},
                                                                {"chbgcross", Flag},
                                                                {"chbgdcross", Flag},
                                                                {"chbgdkbdiag", Flag},
                                                                {"chbgdkcross", Flag},
                                                                {"chbgdkdcross", Flag},
                                                                {"chbgdkfdiag", Flag},
                                                                {"chbgdkhoriz", Flag},
                                                                {"chbgdkvert", Flag},
                                                                {"chbgfdiag", Flag},
                                                                {"chbghoriz", Flag},
                                                                {"chbgvert", Flag},
                                                                {"chbrdr", Flag},
                                                                {"chcbpat", Value},
                                                                {"chcfpat", Value},
                                                                {"chdate", Symbol},
                                                                {"chdpa", Symbol},
                                                                {"chdpl", Symbol},
                                                                {"chftn", Symbol},
                                                                {"chftnsep", Symbol},
                                                                {"chftnsepc", Symbol},
                                                                {"chpgn", Symbol},
                                                                {"chhres", Value},
                                                                {"chshdng", Value},
                                                                {"chtime", Symbol},
                                                                {"chyperlink", Flag},
                                                                {"clbgbdiag", Flag},
                                                                {"clbgcross", Flag},
                                                                {"clbgdcross", Flag},
                                                                {"clbgdkbdiag", Flag},
                                                                {"clbgdkcross", Flag},
                                                                {"clbgdkdcross", Flag},
                                                                {"clbgdkfdiag", Flag},
                                                                {"clbgdkhor", Flag},
                                                                {"clbgdkvert", Flag},
                                                                {"clbgfdiag", Flag},
                                                                {"clbghoriz", Flag},
                                                                {"clbgvert", Flag},
                                                                {"clbrdrb", Flag},
                                                                {"clbrdrl", Flag},
                                                                {"clbrdrr", Flag},
                                                                {"clbrdrt", Flag},
                                                                {"clcbpat", Value},
                                                                {"clcbpatraw", Value},
                                                                {"clcfpat", Value},
                                                                {"clcfpatraw", Value},
                                                                {"cldel", Flag},
                                                                {"cldelauth", Value},
                                                                {"cldeldttm", Value},
                                                                {"cldgll", Flag},
                                                                {"cldglu", Flag},
                                                                {"clFitText", Flag},
                                                                {"clftsWidth", Value},
                                                                {"clhidemark", Flag},
                                                                {"clins", Flag},
                                                                {"clinsauth", Value},
                                                                {"clinsdttm", Value},
                                                                {"clmgf", Flag},
                                                                {"clmrg", Flag},
                                                                {"clmrgd", Flag},
                                                                {"clmrgdauth", Value},
                                                                {"clmrgddttm", Value},
                                                                {"clmrgdr", Flag},
                                                                {"clNoWrap", Flag},
                                                                {"clpadb", Value},
                                                                {"clpadfb", Value},
                                                                {"clpadfl", Value},
                                                                {"clpadfr", Value},
                                                                {"clpadft", Value},
                                                                {"clpadl", Value},
                                                                {"clpadr", Value},
                                                                {"clpadt", Value},
                                                                {"clspb", Value},
                                                                {"clspfb", Value},
                                                                {"clspfl", Value},
                                                                {"clspfr", Value},
                                                                {"clspft", Value},
                                                                {"clspl", Value},
                                                                {"clspr", Value},
                                                                {"clspt", Value},
                                                                {"clshdng", Value},
                                                                {"clshdngraw", Value},
                                                                {"clshdrawnil", Flag},
                                                                {"clsplit", Flag},
                                                                {"clsplitr", Flag},
                                                                {"cltxbtlr", Flag},
                                                                {"cltxlrtb", Flag},
                                                                {"cltxlrtbv", Flag},
                                                                {"cltxtbrl", Flag},
                                                                {"cltxtbrlv", Flag},
                                                                {"clvertalb", Flag},
                                                                {"clvertalc", Flag},
                                                                {"clvertalt", Flag},
                                                                {"clvmgf", Flag},
                                                                {"clvmrg", Flag},
                                                                {"clwWidth", Value},
                                                                {"cmaindarkone", Flag},
                                                                {"cmaindarktwo", Flag},
                                                                {"cmainlightone", Flag},
                                                                {"cmainlighttwo", Flag},
                                                                {"collapsed", Flag},
                                                                {"colno", Value},
                                                                {"colorschememapping", Destination},
                                                                {"colortbl", Destination},
                                                                {"cols", Value},
                                                                {"colsr", Value},
                                                                {"colsx", Value},
                                                                {"column", Symbol},
                                                                {"colw", Value},
                                                                {"comment", Destination},
                                                                {"company", Destination},
                                                                {"contextualspace", Flag},
                                                                {"cpg", Value},
                                                                {"crauth", Value},
                                                                {"crdate", Value},
                                                                {"creatim", Destination},
                                                                {"cs", Value},
                                                                {"cshade", Value},
                                                                {"ctextone", Flag},
                                                                {"ctexttwo", Flag},
                                                                {"ctint", Value},
                                                                {"ctrl", Flag},
                                                                {"cts", Value},
                                                                {"cufi", Value},
                                                                {"culi", Value},
                                                                {"curi", Value},
                                                                {"cvmme", Flag},
                                                                {"datafield", Destination},
                                                                {"datastore", Destination},
                                                                {"date", Flag},
                                                                {"dbch", Flag},
                                                                {"defchp", Destination},
                                                                {"deff", Value},
                                                                {"defformat", Flag},
                                                                {"deflang", Value},
                                                                {"deflangfe", Value},
                                                                {"defpap", Destination},
                                                                {"defshp", Flag},
                                                                {"deftab", Value},
                                                                {"deleted", Toggle},
                                                                {"delrsid", Value},
                                                                {"dfrauth", Value},
                                                                {"dfrdate", Value},
                                                                {"dfrmtxtx", Value},
                                                                {"dfrmtxty", Value},
                                                                {"dfrstart", Value},
                                                                {"dfrstop", Value},
                                                                {"dfrxst", Value},
                                                                {"dghorigin", Value},
                                                                {"dghshow", Value},
                                                                {"dghspace", Value},
                                                                {"dgmargin", Flag},
                                                                {"dgsnap", Flag},
                                                                {"dgvorigin", Value},
                                                                {"dgvshow", Value},
                                                                {"dgvspace", Value},
                                                                {"dibitmap", Value},
                                                                {"disabled", Toggle},
                                                                {"dn", Value},
                                                                {"dntblnsbdb", Flag},
                                                                {"do", Destination},
                                                                {"dobxcolumn", Flag},
                                                                {"dobxmargin", Flag},
                                                                {"dobxpage", Flag},
                                                                {"dobymargin", Flag},
                                                                {"dobypage", Flag},
                                                                {"dobypara", Flag},
                                                                {"doccomm", Destination},
                                                                {"doctemp", Flag},
                                                                {"doctype", Value},
                                                                {"docvar", Destination},
                                                                {"dodhgt", Value},
                                                                {"dolock", Flag},
                                                                {"donotembedlingdata", Value},
                                                                {"donotembedsysfont", Value},
                                                                {"donotshowcomments", Flag},
                                                                {"donotshowinsdel", Flag},
                                                                {"donotshowmarkup", Flag},
                                                                {"donotshowprops", Flag},
                                                                {"dpaendhol", Flag},
                                                                {"dpaendl", Value},
                                                                {"dpaendsol", Flag},
                                                                {"dpaendw", Value},
                                                                {"dparc", Flag},
                                                                {"dparcflipx", Flag},
                                                                {"dparcflipy", Flag},
                                                                {"dpastarthol", Flag},
                                                                {"dpastartl", Value},
                                                                {"dpastartsol", Flag},
                                                                {"dpastartw", Value},
                                                                {"dpcallout", Flag},
                                                                {"dpcoa", Value},
                                                                {"dpcoaccent", Flag},
                                                                {"dpcobestfit", Flag},
                                                                {"dpcoborder", Flag},
                                                                {"dpcodabs", Flag},
                                                                {"dpcodbottom", Flag},
                                                                {"dpcodcenter", Flag},
                                                                {"dpcodescent", Value},
                                                                {"dpcodtop", Flag},
                                                                {"dpcolength", Value},
                                                                {"dpcominusx", Flag},
                                                                {"dpcominusy", Flag},
                                                                {"dpcooffset", Value},
                                                                {"dpcosmarta", Flag},
                                                                {"dpcotdouble", Flag},
                                                                {"dpcotright", Flag},
                                                                {"dpcotsingle", Flag},
                                                                {"dpcottriple", Flag},
                                                                {"dpcount", Value},
                                                                {"dpellipse", Flag},
                                                                {"dpendgroup", Flag},
                                                                {"dpfillbgcb", Value},
                                                                {"dpfillbgcg", Value},
                                                                {"dpfillbgcr", Value},
                                                                {"dpfillbggray", Value},
                                                                {"dpfillbgpal", Flag},
                                                                {"dpfillfgcb", Value},
                                                                {"dpfillfgcg", Value},
                                                                {"dpfillfgcr", Value},
                                                                {"dpfillfggray", Value},
                                                                {"dpfillfgpal", Flag},
                                                                {"dpfillpat", Value},
                                                                {"dpgroup", Flag},
                                                                {"dpline", Flag},
                                                                {"dplinecob", Value},
                                                                {"dplinecog", Value},
                                                                {"dplinecor", Value},
                                                                {"dplinedado", Flag},
                                                                {"dplinedadodo", Flag},
                                                                {"dplinedash", Flag},
                                                                {"dplinedot", Flag},
                                                                {"dplinegray", Value},
                                                                {"dplinehollow", Flag},
                                                                {"dplinepal", Flag},
                                                                {"dplinesolid", Flag},
                                                                {"dplinew", Value},
                                                                {"dppolycount", Value},
                                                                {"dppolygon", Flag},
                                                                {"dppolyline", Flag},
                                                                {"dpptx", Value},
                                                                {"dppty", Value},
                                                                {"dprect", Flag},
                                                                {"dproundr", Flag},
                                                                {"dpshadow", Flag},
                                                                {"dpshadx", Value},
                                                                {"dpshady", Value},
                                                                {"dptxbtlr", Flag},
                                                                {"dptxbx", Flag},
                                                                {"dptxbxmar", Value},
                                                                {"dptxbxtext", Destination},
                                                                {"dptxlrtb", Flag},
                                                                {"dptxlrtbv", Flag},
                                                                {"dptxtbrl", Flag},
                                                                {"dptxtbrlv", Flag},
                                                                {"dpx", Value},
                                                                {"dpxsize", Value},
                                                                {"dpy", Value},
                                                                {"dpysize", Value},
                                                                {"dropcapli", Value},
                                                                {"dropcapt", Value},
                                                                {"ds", Value},
                                                                {"dxfrtext", Value},
                                                                {"dy", Value},
                                                                {"ebcend", Destination},
                                                                {"ebcstart", Destination},
                                                                {"edmins", Value},
                                                                {"embo", Toggle},
                                                                {"emdash", Symbol},
                                                                {"emfblip", Flag},
                                                                {"emspace", Symbol},
                                                                {"endash", Symbol},
                                                                {"enddoc", Flag},
                                                                {"endnhere", Flag},
                                                                {"endnotes", Flag},
                                                                {"enforceprot", Value},
                                                                {"enspace", Symbol},
                                                                {"expnd", Value},
                                                                {"expndtw", Value},
                                                                {"expshrtn", Flag},
                                                                {"f", Value},
                                                                {"faauto", Flag},
                                                                {"facenter", Flag},
                                                                {"facingp", Flag},
                                                                {"factoidname", Destination},
                                                                {"fafixed", Flag},
                                                                {"fahang", Flag},
                                                                {"falt", Destination},
                                                                {"faroman", Flag},
                                                                {"favar", Flag},
                                                                {"fbias", Value},
                                                                {"fbidi", Flag},
                                                                {"fbidis", Flag},
                                                                {"fbimajor", Flag},
                                                                {"fbiminor", Flag},
                                                                {"fchars", Destination},
                                                                {"fcharset", Value},
                                                                {"fcs", Value},
                                                                {"fdbmajor", Flag},
                                                                {"fdbminor", Flag},
                                                                {"fdecor", Flag},
                                                                {"felnbrelev", Flag},
                                                                {"fet", Value},
                                                                {"fetch", Flag},
                                                                {"ffdefres", Value},
                                                                {"ffdeftext", Destination},
                                                                {"ffentrymcr", Destination},
                                                                {"ffexitmcr", Destination},
                                                                {"ffformat", Destination},
                                                                {"ffhaslistbox", Value},
                                                                {"ffhelptext", Destination},
                                                                {"ffhps", Value},
                                                                {"ffl", Destination},
                                                                {"ffmaxlen", Value},
                                                                {"ffname", Destination},
                                                                {"ffownhelp", Value},
                                                                {"ffownstat", Value},
                                                                {"ffprot", Value},
                                                                {"ffrecalc", Value},
                                                                {"ffres", Value},
                                                                {"ffsize", Value},
                                                                {"ffstattext", Destination},
                                                                {"fftype", Value},
                                                                {"fftypetxt", Value},
                                                                {"fhimajor", Flag},
                                                                {"fhiminor", Flag},
                                                                {"fi", Value},
                                                                {"fid", Value},
                                                                {"field", Destination},
                                                                {"file", Destination},
                                                                {"filetbl", Destination},
                                                                {"fittext", Value},
                                                                {"fjgothic", Flag},
                                                                {"fjminchou", Flag},
                                                                {"fldalt", Flag},
                                                                {"flddirty", Flag},
                                                                {"fldedit", Flag},
                                                                {"fldinst", Destination},
                                                                {"fldlock", Flag},
                                                                {"fldpriv", Flag},
                                                                {"fldrslt", Destination},
                                                                {"fldtype", Destination},
                                                                {"flomajor", Flag},
                                                                {"flominor", Flag},
                                                                {"fmodern", Flag},
                                                                {"fn", Value},
                                                                {"fname", Destination},
                                                                {"fnetwork", Flag},
                                                                {"fnil", Flag},
                                                                {"fnonfilesys", Flag},
                                                                {"fontemb", Destination},
                                                                {"fontfile", Destination},
                                                                {"fonttbl", Destination},
                                                                {"footer", Destination},
                                                                {"footerf", Destination},
                                                                {"footerl", Destination},
                                                                {"footerr", Destination},
                                                                {"footery", Value},
                                                                {"footnote", Destination},
                                                                {"forceupgrade", Flag},
                                                                {"formdisp", Flag},
                                                                {"formfield", Destination},
                                                                {"formprot", Flag},
                                                                {"formshade", Flag},
                                                                {"fosnum", Value},
                                                                {"fprq", Value},
                                                                {"fracwidth", Flag},
                                                                {"frelative", Value},
                                                                {"frmtxbtlr", Flag},
                                                                {"frmtxlrtb", Flag},
                                                                {"frmtxlrtbv", Flag},
                                                                {"frmtxtbrl", Flag},
                                                                {"frmtxtbrlv", Flag},
                                                                {"froman", Flag},
                                                                {"fromhtml", Value},
                                                                {"fromtext", Flag},
                                                                {"fs", Value},
                                                                {"fscript", Flag},
                                                                {"fswiss", Flag},
                                                                {"ftech", Flag},
                                                                {"ftnalt", Flag},
                                                                {"ftnbj", Flag},
                                                                {"ftncn", Destination},
                                                                {"ftnil", Flag},
                                                                {"ftnlytwnine", Flag},
                                                                {"ftnnalc", Flag},
                                                                {"ftnnar", Flag},
                                                                {"ftnnauc", Flag},
                                                                {"ftnnchi", Flag},
                                                                {"ftnnchosung", Flag},
                                                                {"ftnncnum", Flag},
                                                                {"ftnndbar", Flag},
                                                                {"ftnndbnum", Flag},
                                                                {"ftnndbnumd", Flag},
                                                                {"ftnndbnumk", Flag},
                                                                {"ftnndbnumt", Flag},
                                                                {"ftnnganada", Flag},
                                                                {"ftnngbnum", Flag},
                                                                {"ftnngbnumd", Flag},
                                                                {"ftnngbnumk", Flag},
                                                                {"ftnngbnuml", Flag},
                                                                {"ftnnrlc", Flag},
                                                                {"ftnnruc", Flag},
                                                                {"ftnnzodiac", Flag},
                                                                {"ftnnzodiacd", Flag},
                                                                {"ftnnzodiacl", Flag},
                                                                {"ftnrestart", Flag},
                                                                {"ftnrstcont", Flag},
                                                                {"ftnrstpg", Flag},
                                                                {"ftnsep", Destination},
                                                                {"ftnsepc", Destination},
                                                                {"ftnstart", Value},
                                                                {"ftntj", Flag},
                                                                {"fttruetype", Flag},
                                                                {"fvaliddos", Flag},
                                                                {"fvalidhpfs", Flag},
                                                                {"fvalidmac", Flag},
                                                                {"fvalidntfs", Flag},
                                                                {"g", Destination},
                                                                {"gcw", Value},
                                                                {"generator", Destination},
                                                                {"green", Value},
                                                                {"grfdocevents", Value},
                                                                {"gridtbl", Destination},
                                                                {"gutter", Value},
                                                                {"gutterprl", Flag},
                                                                {"guttersxn", Value},
                                                                {"header", Destination},
                                                                {"headerf", Destination},
                                                                {"headerl", Destination},
                                                                {"headerr", Destination},
                                                                {"headery", Value},
                                                                {"hich", Flag},
                                                                {"highlight", Value},
                                                                {"hl", Destination},
                                                                {"hlfr", Destination},
                                                                {"hlinkbase", Destination},
                                                                {"hlloc", Destination},
                                                                {"hlsrc", Destination},
                                                                {"horzdoc", Flag},
                                                                {"horzsect", Flag},
                                                                {"horzvert", Value},
                                                                {"hr", Value},
                                                                {"hres", Value},
                                                                {"hrule", Flag},
                                                                {"hsv", Destination},
                                                                {"htmautsp", Flag},
                                                                {"htmlbase", Flag},
                                                                {"htmlrtf", Toggle},
                                                                {"htmltag", Destination},
                                                                {"hwelev", Flag},
                                                                {"hyphauto", Toggle},
                                                                {"hyphcaps", Toggle},
                                                                {"hyphconsec", Value},
                                                                {"hyphhotz", Value},
                                                                {"hyphpar", Toggle},
                                                                {"i", Toggle},
                                                                {"id", Value},
                                                                {"ignoremixedcontent", Value},
                                                                {"ilfomacatclnup", Value},
                                                                {"ilvl", Value},
                                                                {"impr", Toggle},
                                                                {"indmirror", Flag},
                                                                {"indrlsweleven", Flag},
                                                                {"info", Destination},
                                                                {"insrsid", Value},
                                                                {"intbl", Flag},
                                                                {"ipgp", Value},
                                                                {"irowband", Value},
                                                                {"irow", Value},
                                                                {"itap", Value},
                                                                {"ixe", Flag},
                                                                {"jcompress", Flag},
                                                                {"jexpand", Flag},
                                                                {"jis", Flag},
                                                                {"jpegblip", Flag},
                                                                {"jsksu", Flag},
                                                                {"keep", Flag},
                                                                {"keepn", Flag},
                                                                {"kerning", Value},
                                                                {"keycode", Destination},
                                                                {"keywords", Destination},
                                                                {"krnprsnet", Flag},
                                                                {"ksulang", Value},
                                                                {"jclisttab", Flag},
                                                                {"landscape", Flag},
                                                                {"lang", Value},
                                                                {"langfe", Value},
                                                                {"langfenp", Value},
                                                                {"langnp", Value},
                                                                {"lastrow", Flag},
                                                                {"latentstyles", Destination},
                                                                {"lbr", Value},
                                                                {"lchars", Destination},
                                                                {"ldblquote", Symbol},
                                                                {"level", Value},
                                                                {"levelfollow", Value},
                                                                {"levelindent", Value},
                                                                {"leveljc", Value},
                                                                {"leveljcn", Value},
                                                                {"levellegal", Value},
                                                                {"levelnfc", Value},
                                                                {"levelnfcn", Value},
                                                                {"levelnorestart", Value},
                                                                {"levelnumbers", Destination},
                                                                {"levelold", Value},
                                                                {"levelpicture", Value},
                                                                {"levelpicturenosize", Flag},
                                                                {"levelprev", Value},
                                                                {"levelprevspace", Value},
                                                                {"levelspace", Value},
                                                                {"levelstartat", Value},
                                                                {"leveltemplateid", Value},
                                                                {"leveltext", Destination},
                                                                {"lfolevel", Destination},
                                                                {"li", Value},
                                                                {"line", Symbol},
                                                                {"linebetcol", Flag},
                                                                {"linecont", Flag},
                                                                {"linemod", Value},
                                                                {"lineppage", Flag},
                                                                {"linerestart", Flag},
                                                                {"linestart", Value},
                                                                {"linestarts", Value},
                                                                {"linex", Value},
                                                                {"linkself", Flag},
                                                                {"linkstyles", Flag},
                                                                {"linkval", Destination},
                                                                {"lin", Value},
                                                                {"lisa", Value},
                                                                {"lisb", Value},
                                                                {"list", Destination},
                                                                {"listhybrid", Flag},
                                                                {"listid", Value},
                                                                {"listlevel", Destination},
                                                                {"listname", Destination},
                                                                {"listoverride", Destination},
                                                                {"listoverridecount", Value},
                                                                {"listoverrideformat", Value},
                                                                {"listoverridestartat", Flag},
                                                                {"listoverridetable", Destination},
                                                                {"listpicture", Destination},
                                                                {"listrestarthdn", Value},
                                                                {"listsimple", Value},
                                                                {"liststyleid", Value},
                                                                {"liststylename", Destination},
                                                                {"listtable", Destination},
                                                                {"listtemplateid", Value},
                                                                {"listtext", Destination},
                                                                {"lnbrkrule", Flag},
                                                                {"lndscpsxn", Flag},
                                                                {"lnongrid", Flag},
                                                                {"loch", Flag},
                                                                {"lquote", Symbol},
                                                                {"ls", Value},
                                                                {"lsdlocked", Value},
                                                                {"lsdlockeddef", Value},
                                                                {"lsdlockedexcept", Destination},
                                                                {"lsdpriority", Value},
                                                                {"lsdprioritydef", Value},
                                                                {"lsdqformat", Value},
                                                                {"lsdqformatdef", Value},
                                                                {"lsdsemihidden", Value},
                                                                {"lsdsemihiddendef", Value},
                                                                {"lsdstimax", Value},
                                                                {"lsdunhideused", Value},
                                                                {"lsdunhideuseddef", Value},
                                                                {"ltrch", Flag},
                                                                {"ltrdoc", Flag},
                                                                {"ltrmark", Symbol},
                                                                {"ltrpar", Flag},
                                                                {"ltrrow", Flag},
                                                                {"ltrsect", Flag},
                                                                {"lvltentative", Flag},
                                                                {"lytcalctblwd", Flag},
                                                                {"lytexcttp", Flag},
                                                                {"lytprtmet", Flag},
                                                                {"lyttblrtgr", Flag},
                                                                {"mac", Flag},
                                                                {"macc", Destination},
                                                                {"maccPr", Destination},
                                                                {"macpict", Flag},
                                                                {"mailmerge", Destination},
                                                                {"makebackup", Flag},
                                                                {"maln", Destination},
                                                                {"malnScr", Destination},
                                                                {"manager", Destination},
                                                                {"margb", Value},
                                                                {"margbsxn", Value},
                                                                {"margl", Value},
                                                                {"marglsxn", Value},
                                                                {"margmirror", Flag},
                                                                {"margmirsxn", Flag},
                                                                {"margPr", Destination},
                                                                {"margr", Value},
                                                                {"margrsxn", Value},
                                                                {"margSz", Value},
                                                                {"margt", Value},
                                                                {"margtsxn", Value},
                                                                {"mbar", Destination},
                                                                {"mbarPr", Destination},
                                                                {"mbaseJc", Destination},
                                                                {"mbegChr", Destination},
                                                                {"mborderBox", Destination},
                                                                {"mborderBoxPr", Destination},
                                                                {"mbox", Destination},
                                                                {"mboxPr", Destination},
                                                                {"mbrk", Value},
                                                                {"mbrkBin", Value},
                                                                {"mbrkBinSub", Value},
                                                                {"mcGp", Value},
                                                                {"mcGpRule", Value},
                                                                {"mchr", Destination},
                                                                {"mcount", Destination},
                                                                {"mcSp", Value},
                                                                {"mctrlPr", Destination},
                                                                {"md", Destination},
                                                                {"mdefJc", Value},
                                                                {"mdeg", Destination},
                                                                {"mdegHide", Destination},
                                                                {"mden", Destination},
                                                                {"mdiff", Destination},
                                                                {"mdiffSty", Value},
                                                                {"mdispdef", Value},
                                                                {"mdPr", Destination},
                                                                {"me", Destination},
                                                                {"mendChr", Destination},
                                                                {"meqArr", Destination},
                                                                {"meqArrPr", Destination},
                                                                {"mf", Destination},
                                                                {"mfName", Destination},
                                                                {"mfPr", Destination},
                                                                {"mfunc", Destination},
                                                                {"mfuncPr", Destination},
                                                                {"mgroupChr", Destination},
                                                                {"mgroupChrPr", Destination},
                                                                {"mgrow", Destination},
                                                                {"mhideBot", Destination},
                                                                {"mhideLeft", Destination},
                                                                {"mhideRight", Destination},
                                                                {"mhideTop", Destination},
                                                                {"mhtmltag", Destination},
                                                                {"min", Value},
                                                                {"minterSp", Value},
                                                                {"mintLim", Value},
                                                                {"mintraSp", Value},
                                                                {"mjc", Value},
                                                                {"mlim", Destination},
                                                                {"mlimloc", Destination},
                                                                {"mlimlow", Destination},
                                                                {"mlimlowPr", Destination},
                                                                {"mlimupp", Destination},
                                                                {"mlimuppPr", Destination},
                                                                {"mlit", Flag},
                                                                {"mlMargin", Value},
                                                                {"mm", Destination},
                                                                {"mmaddfieldname", Destination},
                                                                {"mmath", Destination},
                                                                {"mmathFont", Value},
                                                                {"mmathPict", Destination},
                                                                {"mmathPr", Destination},
                                                                {"mmattach", Flag},
                                                                {"mmaxdist", Destination},
                                                                {"mmblanklines", Flag},
                                                                {"mmc", Destination},
                                                                {"mmcJc", Destination},
                                                                {"mmconnectstr", Destination},
                                                                {"mmconnectstrdata", Destination},
                                                                {"mmcPr", Destination},
                                                                {"mmcs", Destination},
                                                                {"mmdatasource", Destination},
                                                                {"mmdatatypeaccess", Flag},
                                                                {"mmdatatypeexcel", Flag},
                                                                {"mmdatatypefile", Flag},
                                                                {"mmdatatypeodbc", Flag},
                                                                {"mmdatatypeodso", Flag},
                                                                {"mmdatatypeqt", Flag},
                                                                {"mmdefaultsql", Flag},
                                                                {"mmdestemail", Flag},
                                                                {"mmdestfax", Flag},
                                                                {"mmdestnewdoc", Flag},
                                                                {"mmdestprinter", Flag},
                                                                {"mmerrors", Value},
                                                                {"mmfttypeaddress", Flag},
                                                                {"mmfttypebarcode", Flag},
                                                                {"mmfttypedbcolumn", Flag},
                                                                {"mmfttypemapped", Flag},
                                                                {"mmfttypenull", Flag},
                                                                {"mmfttypesalutation", Flag},
                                                                {"mmheadersource", Destination},
                                                                {"mmjdsotype", Value},
                                                                {"mmlinktoquery", Flag},
                                                                {"mmmailsubject", Destination},
                                                                {"mmmaintypecatalog", Flag},
                                                                {"mmmaintypeemail", Flag},
                                                                {"mmmaintypeenvelopes", Flag},
                                                                {"mmmaintypefax", Flag},
                                                                {"mmmaintypelabels", Flag},
                                                                {"mmmaintypeletters", Flag},
                                                                {"mmodso", Destination},
                                                                {"mmodsoactive", Value},
                                                                {"mmodsocoldelim", Value},
                                                                {"mmodsocolumn", Value},
                                                                {"mmodsodynaddr", Value},
                                                                {"mmodsofhdr", Value},
                                                                {"mmodsofilter", Destination},
                                                                {"mmodsofldmpdata", Destination},
                                                                {"mmodsofmcolumn", Value},
                                                                {"mmodsohash", Value},
                                                                {"mmodsolid", Value},
                                                                {"mmodsomappedname", Destination},
                                                                {"mmodsoname", Destination},
                                                                {"mmodsorecipdata", Destination},
                                                                {"mmodsosort", Destination},
                                                                {"mmodsosrc", Destination},
                                                                {"mmodsotable", Destination},
                                                                {"mmodsoudl", Destination},
                                                                {"mmodsoudldata", Destination},
                                                                {"mmodsouniquetag", Destination},
                                                                {"mmPr", Destination},
                                                                {"mmquery", Destination},
                                                                {"mmr", Destination},
                                                                {"mmreccur", Value},
                                                                {"mmshowdata", Flag},
                                                                {"mnary", Destination},
                                                                {"mnaryLim", Value},
                                                                {"mnaryPr", Destination},
                                                                {"mnoBreak", Destination},
                                                                {"mnor", Flag},
                                                                {"mnum", Destination},
                                                                {"mo", Value},
                                                                {"mobjDist", Destination},
                                                                {"moMath", Destination},
                                                                {"moMathPara", Destination},
                                                                {"moMathParaPr", Destination},
                                                                {"mopEmu", Destination},
                                                                {"mphant", Destination},
                                                                {"mphantPr", Destination},
                                                                {"mplcHide", Destination},
                                                                {"mpos", Destination},
                                                                {"mpostSp", Value},
                                                                {"mpreSp", Value},
                                                                {"mr", Destination},
                                                                {"mrad", Destination},
                                                                {"mradPr", Destination},
                                                                {"mrMargin", Value},
                                                                {"mrPr", Destination},
                                                                {"mrSp", Value},
                                                                {"mrSpRule", Value},
                                                                {"mscr", Value},
                                                                {"msepChr", Destination},
                                                                {"mshow", Destination},
                                                                {"mshp", Destination},
                                                                {"msmallFrac", Value},
                                                                {"msmcap", Flag},
                                                                {"msPre", Destination},
                                                                {"msPrePr", Destination},
                                                                {"msSub", Destination},
                                                                {"msSubPr", Destination},
                                                                {"msSubSup", Destination},
                                                                {"msSubSupPr", Destination},
                                                                {"msSup", Destination},
                                                                {"msSupPr", Destination},
                                                                {"mstrikeBLTR", Destination},
                                                                {"mstrikeH", Destination},
                                                                {"mstrikeTLBR", Destination},
                                                                {"mstrikeV", Destination},
                                                                {"msty", Value},
                                                                {"msub", Destination},
                                                                {"msubHide", Destination},
                                                                {"msup", Destination},
                                                                {"msupHide", Destination},
                                                                {"mtransp", Destination},
                                                                {"mtype", Destination},
                                                                {"muser", Flag},
                                                                {"mvauth", Value},
                                                                {"mvdate", Value},
                                                                {"mvertJc", Destination},
                                                                {"mvf", Flag},
                                                                {"mvfmf", Destination},
                                                                {"mvfml", Destination},
                                                                {"mvt", Flag},
                                                                {"mvtof", Destination},
                                                                {"mvtol", Destination},
                                                                {"mwrapIndent", Value},
                                                                {"mwrapRight", Value},
                                                                {"mzeroAsc", Destination},
                                                                {"mzeroDesc", Destination},
                                                                {"mzeroWid", Destination},
                                                                {"nestcell", Symbol},
                                                                {"nestrow", Symbol},
                                                                {"nesttableprops", Destination},
                                                                {"newtblstyruls", Flag},
                                                                {"nextfile", Destination},
                                                                {"noafcnsttbl", Flag},
                                                                {"nobrkwrptbl", Flag},
                                                                {"nocolbal", Flag},
                                                                {"nocompatoptions", Flag},
                                                                {"nocwrap", Flag},
                                                                {"nocxsptable", Flag},
                                                                {"noextrasprl", Flag},
                                                                {"nofchars", Value},
                                                                {"nofcharsws", Value},
                                                                {"nofeaturethrottle", Flag},
                                                                {"nofpages", Value},
                                                                {"nofwords", Value},
                                                                {"nogrowautofit", Flag},
                                                                {"noindnmbrts", Flag},
                                                                {"nojkernpunct", Flag},
                                                                {"nolead", Flag},
                                                                {"noline", Flag},
                                                                {"nolnhtadjtbl", Flag},
                                                                {"nonesttables", Destination},
                                                                {"nonshppict", Flag},
                                                                {"nooverflow", Flag},
                                                                {"noproof", Flag},
                                                                {"noqfpromote", Flag},
                                                                {"nosectexpand", Flag},
                                                                {"nosnaplinegrid", Flag},
                                                                {"nospaceforul", Flag},
                                                                {"nosupersub", Flag},
                                                                {"notabind", Flag},
                                                                {"notbrkcnstfrctbl", Flag},
                                                                {"notcvasp", Flag},
                                                                {"notvatxbx", Flag},
                                                                {"nouicompat", Flag},
                                                                {"noultrlspc", Flag},
                                                                {"nowidctlpar", Flag},
                                                                {"nowrap", Flag},
                                                                {"nowwrap", Flag},
                                                                {"noxlattoyen", Flag},
                                                                {"objalias", Destination},
                                                                {"objalign", Value},
                                                                {"objattph", Flag},
                                                                {"objautlink", Flag},
                                                                {"objclass", Destination},
                                                                {"objcropb", Value},
                                                                {"objcropl", Value},
                                                                {"objcropr", Value},
                                                                {"objcropt", Value},
                                                                {"objdata", Destination},
                                                                {"object", Destination},
                                                                {"objemb", Flag},
                                                                {"objh", Value},
                                                                {"objhtml", Flag},
                                                                {"objicemb", Flag},
                                                                {"objlink", Flag},
                                                                {"objlock", Flag},
                                                                {"objname", Destination},
                                                                {"objocx", Flag},
                                                                {"objpub", Flag},
                                                                {"objscalex", Value},
                                                                {"objscaley", Value},
                                                                {"objsect", Destination},
                                                                {"objsetsize", Flag},
                                                                {"objsub", Flag},
                                                                {"objtime", Destination},
                                                                {"objtransy", Value},
                                                                {"objupdate", Flag},
                                                                {"objw", Value},
                                                                {"ogutter", Value},
                                                                {"oldas", Flag},
                                                                {"oldcprops", Destination},
                                                                {"oldlinewrap", Flag},
                                                                {"oldpprops", Destination},
                                                                {"oldsprops", Destination},
                                                                {"oldtprops", Destination},
                                                                {"oleclsid", Destination},
                                                                {"operator", Destination},
                                                                {"otblrul", Flag},
                                                                {"outl", Toggle},
                                                                {"outlinelevel", Value},
                                                                {"overlay", Flag},
                                                                {"page", Symbol},
                                                                {"pagebb", Flag},
                                                                {"panose", Destination},
                                                                {"paperh", Value},
                                                                {"paperw", Value},
                                                                {"par", Symbol},
                                                                {"pararsid", Value},
                                                                {"pard", Flag},
                                                                {"password", Destination},
                                                                {"passwordhash", Destination},
                                                                {"pc", Flag},
                                                                {"pca", Flag},
                                                                {"pgbrdrb", Flag},
                                                                {"pgbrdrfoot", Flag},
                                                                {"pgbrdrhead", Flag},
                                                                {"pgbrdrl", Flag},
                                                                {"pgbrdropt", Value},
                                                                {"pgbrdrr", Flag},
                                                                {"pgbrdrsnap", Flag},
                                                                {"pgbrdrt", Flag},
                                                                {"pgdsc", Destination}, /* OpenOffice / LibreOffice */
                                                                {"pgdsctbl", Destination}, /* OpenOffice / LibreOffice */
                                                                {"pghsxn", Value},
                                                                {"pgnbidia", Flag},
                                                                {"pgnbidib", Flag},
                                                                {"pgnchosung", Flag},
                                                                {"pgncnum", Flag},
                                                                {"pgncont", Flag},
                                                                {"pgndbnum", Flag},
                                                                {"pgndbnumd", Flag},
                                                                {"pgndbnumk", Flag},
                                                                {"pgndbnumt", Flag},
                                                                {"pgndec", Flag},
                                                                {"pgndecd", Flag},
                                                                {"pgnganada", Flag},
                                                                {"pgngbnum", Flag},
                                                                {"pgngbnumd", Flag},
                                                                {"pgngbnumk", Flag},
                                                                {"pgngbnuml", Flag},
                                                                {"pgnhindia", Flag},
                                                                {"pgnhindib", Flag},
                                                                {"pgnhindic", Flag},
                                                                {"pgnhindid", Flag},
                                                                {"pgnhn", Value},
                                                                {"pgnhnsc", Flag},
                                                                {"pgnhnsh", Flag},
                                                                {"pgnhnsm", Flag},
                                                                {"pgnhnsn", Flag},
                                                                {"pgnhnsp", Flag},
                                                                {"pgnid", Flag},
                                                                {"pgnlcltr", Flag},
                                                                {"pgnlcrm", Flag},
                                                                {"pgnrestart", Flag},
                                                                {"pgnstart", Value},
                                                                {"pgnstarts", Value},
                                                                {"pgnthaia", Flag},
                                                                {"pgnthaib", Flag},
                                                                {"pgnthaic", Flag},
                                                                {"pgnucltr", Flag},
                                                                {"pgnucrm", Flag},
                                                                {"pgnvieta", Flag},
                                                                {"pgnx", Value},
                                                                {"pgny", Value},
                                                                {"pgnzodiac", Flag},
                                                                {"pgnzodiacd", Flag},
                                                                {"pgnzodiacl", Flag},
                                                                {"pgp", Destination},
                                                                {"pgptbl", Destination},
                                                                {"pgwsxn", Value},
                                                                {"phcol", Flag},
                                                                {"phmrg", Flag},
                                                                {"phpg", Flag},
                                                                {"picbmp", Flag},
                                                                {"picbpp", Value},
                                                                {"piccropb", Value},
                                                                {"piccropl", Value},
                                                                {"piccropr", Value},
                                                                {"piccropt", Value},
                                                                {"pich", Value},
                                                                {"pichgoal", Value},
                                                                {"picprop", Destination},
                                                                {"picscaled", Flag},
                                                                {"picscalex", Value},
                                                                {"picscaley", Value},
                                                                {"pict", Destination},
                                                                {"picw", Value},
                                                                {"picwgoal", Value},
                                                                {"pindtabqc", Flag},
                                                                {"pindtabql", Flag},
                                                                {"pindtabqr", Flag},
                                                                {"plain", Flag},
                                                                {"pmartabqc", Flag},
                                                                {"pmartabql", Flag},
                                                                {"pmartabqr", Flag},
                                                                {"pmmetafile", Value},
                                                                {"pn", Destination},
                                                                {"pnacross", Flag},
                                                                {"pnaiu", Flag},
                                                                {"pnaiud", Flag},
                                                                {"pnaiueo", Flag},
                                                                {"pnaiueod", Flag},
                                                                {"pnb", Toggle},
                                                                {"pnbidia", Flag},
                                                                {"pnbidib", Flag},
                                                                {"pncaps", Toggle},
                                                                {"pncard", Flag},
                                                                {"pncf", Value},
                                                                {"pnchosung", Flag},
                                                                {"pncnum", Flag},
                                                                {"pndbnum", Flag},
                                                                {"pndbnumd", Flag},
                                                                {"pndbnumk", Flag},
                                                                {"pndbnuml", Flag},
                                                                {"pndbnumt", Flag},
                                                                {"pndec", Flag},
                                                                {"pndecd", Flag},
                                                                {"pnf", Value},
                                                                {"pnfs", Value},
                                                                {"pnganada", Flag},
                                                                {"pngblip", Flag},
                                                                {"pngbnum", Flag},
                                                                {"pngbnumd", Flag},
                                                                {"pngbnumk", Flag},
                                                                {"pngbnuml", Flag},
                                                                {"pnhang", Flag},
                                                                {"pni", Toggle},
                                                                {"pnindent", Value},
                                                                {"pniroha", Flag},
                                                                {"pnirohad", Flag},
                                                                {"pnlcltr", Flag},
                                                                {"pnlcrm", Flag},
                                                                {"pnlvl", Value},
                                                                {"pnlvlblt", Flag},
                                                                {"pnlvlbody", Flag},
                                                                {"pnlvlcont", Flag},
                                                                {"pnnumonce", Flag},
                                                                {"pnord", Flag},
                                                                {"pnordt", Flag},
                                                                {"pnprev", Flag},
                                                                {"pnqc", Flag},
                                                                {"pnql", Flag},
                                                                {"pnqr", Flag},
                                                                {"pnrauth", Value},
                                                                {"pnrdate", Value},
                                                                {"pnrestart", Flag},
                                                                {"pnrnfc", Value},
                                                                {"pnrnot", Flag},
                                                                {"pnrpnbr", Value},
                                                                {"pnrrgb", Value},
                                                                {"pnrstart", Value},
                                                                {"pnrstop", Value},
                                                                {"pnrxst", Value},
                                                                {"pnscaps", Toggle},
                                                                {"pnseclvl", Destination},
                                                                {"pnsp", Value},
                                                                {"pnstart", Value},
                                                                {"pnstrike", Toggle},
                                                                {"pntext", Destination},
                                                                {"pntxta", Destination},
                                                                {"pntxtb", Destination},
                                                                {"pnucltr", Flag},
                                                                {"pnucrm", Flag},
                                                                {"pnul", Toggle},
                                                                {"pnuld", Flag},
                                                                {"pnuldash", Flag},
                                                                {"pnuldashd", Flag},
                                                                {"pnuldashdd", Flag},
                                                                {"pnuldb", Flag},
                                                                {"pnulhair", Flag},
                                                                {"pnulnone", Flag},
                                                                {"pnulth", Flag},
                                                                {"pnulw", Flag},
                                                                {"pnulwave", Flag},
                                                                {"pnzodiac", Flag},
                                                                {"pnzodiacd", Flag},
                                                                {"pnzodiacl", Flag},
                                                                {"posnegx", Value},
                                                                {"posnegy", Value},
                                                                {"posx", Value},
                                                                {"posxc", Flag},
                                                                {"posxi", Flag},
                                                                {"posxl", Flag},
                                                                {"posxo", Flag},
                                                                {"posxr", Flag},
                                                                {"posy", Value},
                                                                {"posyb", Flag},
                                                                {"posyc", Flag},
                                                                {"posyil", Flag},
                                                                {"posyin", Flag},
                                                                {"posyout", Flag},
                                                                {"posyt", Flag},
                                                                {"prauth", Value},
                                                                {"prcolbl", Flag},
                                                                {"prdate", Value},
                                                                {"printdata", Flag},
                                                                {"printim", Destination},
                                                                {"private", Destination},
                                                                {"propname", Destination},
                                                                {"proptype", Value},
                                                                {"protect", Toggle},
                                                                {"protend", Destination},
                                                                {"protlevel", Value},
                                                                {"protstart", Destination},
                                                                {"protusertbl", Destination},
                                                                {"psover", Flag},
                                                                {"psz", Value},
                                                                {"ptabldot", Flag},
                                                                {"ptablmdot", Flag},
                                                                {"ptablminus", Flag},
                                                                {"ptablnone", Flag},
                                                                {"ptabluscore", Flag},
                                                                {"pubauto", Flag},
                                                                {"pvmrg", Flag},
                                                                {"pvpara", Flag},
                                                                {"pvpg", Flag},
                                                                {"pwd", Value},
                                                                {"pxe", Destination},
                                                                {"qc", Flag},
                                                                {"qd", Flag},
                                                                {"qj", Flag},
                                                                {"qk", Value},
                                                                {"ql", Flag},
                                                                {"qmspace", Symbol},
                                                                {"qr", Flag},
                                                                {"qt", Flag},
                                                                {"rawclbgdkbdiag", Flag},
                                                                {"rawclbgbdiag", Flag},
                                                                {"rawclbgcross", Flag},
                                                                {"rawclbgdcross", Flag},
                                                                {"rawclbgdkcross", Flag},
                                                                {"rawclbgdkdcross", Flag},
                                                                {"rawclbgdkfdiag", Flag},
                                                                {"rawclbgdkhor", Flag},
                                                                {"rawclbgdkvert", Flag},
                                                                {"rawclbgfdiag", Flag},
                                                                {"rawclbghoriz", Flag},
                                                                {"rawclbgvert", Flag},
                                                                {"rdblquote", Symbol},
                                                                {"readonlyrecommended", Flag},
                                                                {"readprot", Flag},
                                                                {"red", Value},
                                                                {"relyonvml", Value},
                                                                {"remdttm", Flag},
                                                                {"rempersonalinfo", Flag},
                                                                {"result", Destination},
                                                                {"revauth", Value},
                                                                {"revauthdel", Value},
                                                                {"revbar", Value},
                                                                {"revdttm", Value},
                                                                {"revdttmdel", Value},
                                                                {"revised", Toggle},
                                                                {"revisions", Flag},
                                                                {"revprop", Value},
                                                                {"revprot", Flag},
                                                                {"revtbl", Destination},
                                                                {"revtim", Destination},
                                                                {"ri", Value},
                                                                {"rin", Value},
                                                                {"row", Symbol},
                                                                {"rquote", Symbol},
                                                                {"rsid", Value},
                                                                {"rsidroot", Value},
                                                                {"rsidtbl", Destination},
                                                                {"rsltbmp", Flag},
                                                                {"rslthtml", Flag},
                                                                {"rsltmerge", Flag},
                                                                {"rsltpict", Flag},
                                                                {"rsltrtf", Flag},
                                                                {"rslttxt", Flag},
                                                                {"rtf", Destination},
                                                                {"rtlch", Flag},
                                                                {"rtldoc", Flag},
                                                                {"rtlgutter", Flag},
                                                                {"rtlmark", Symbol},
                                                                {"rtlpar", Flag},
                                                                {"rtlrow", Flag},
                                                                {"rtlsect", Flag},
                                                                {"rxe", Destination},
                                                                {"s", Value},
                                                                {"sa", Value},
                                                                {"saauto", Toggle},
                                                                {"saftnnalc", Flag},
                                                                {"saftnnar", Flag},
                                                                {"saftnnauc", Flag},
                                                                {"saftnnchi", Flag},
                                                                {"saftnnchosung", Flag},
                                                                {"saftnncnum", Flag},
                                                                {"saftnndbar", Flag},
                                                                {"saftnndbnum", Flag},
                                                                {"saftnndbnumd", Flag},
                                                                {"saftnndbnumk", Flag},
                                                                {"saftnndbnumt", Flag},
                                                                {"saftnnganada", Flag},
                                                                {"saftnngbnum", Flag},
                                                                {"saftnngbnumd", Flag},
                                                                {"saftnngbnumk", Flag},
                                                                {"saftnngbnuml", Flag},
                                                                {"saftnnrlc", Flag},
                                                                {"saftnnruc", Flag},
                                                                {"saftnnzodiac", Flag},
                                                                {"saftnnzodiacd", Flag},
                                                                {"saftnnzodiacl", Flag},
                                                                {"saftnrestart", Flag},
                                                                {"saftnrstcont", Flag},
                                                                {"saftnstart", Value},
                                                                {"sautoupd", Flag},
                                                                {"saveinvalidxml", Flag},
                                                                {"saveprevpict", Flag},
                                                                {"sb", Value},
                                                                {"sbasedon", Value},
                                                                {"sbauto", Toggle},
                                                                {"sbkcol", Flag},
                                                                {"sbkeven", Flag},
                                                                {"sbknone", Flag},
                                                                {"sbkodd", Flag},
                                                                {"sbkpage", Flag},
                                                                {"sbys", Flag},
                                                                {"scaps", Toggle},
                                                                {"scompose", Flag},
                                                                {"sec", Value},
                                                                {"sect", Symbol},
                                                                {"sectd", Flag},
                                                                {"sectdefaultcl", Flag},
                                                                {"sectexpand", Value},
                                                                {"sectlinegrid", Value},
                                                                {"sectnum", Symbol},
                                                                {"sectrsid", Value},
                                                                {"sectspecifycl", Flag},
                                                                {"sectspecifygen", Flag},
                                                                {"sectspecifyl", Flag},
                                                                {"sectunlocked", Flag},
                                                                {"sftnbj", Flag},
                                                                {"sftnnalc", Flag},
                                                                {"sftnnar", Flag},
                                                                {"sftnnauc", Flag},
                                                                {"sftnnchi", Flag},
                                                                {"sftnnchosung", Flag},
                                                                {"sftnncnum", Flag},
                                                                {"sftnndbar", Flag},
                                                                {"sftnndbnum", Flag},
                                                                {"sftnndbnumd", Flag},
                                                                {"sftnndbnumk", Flag},
                                                                {"sftnndbnumt", Flag},
                                                                {"sftnnganada", Flag},
                                                                {"sftnngbnum", Flag},
                                                                {"sftnngbnumd", Flag},
                                                                {"sftnngbnumk", Flag},
                                                                {"sftnngbnuml", Flag},
                                                                {"sftnnrlc", Flag},
                                                                {"sftnnruc", Flag},
                                                                {"sftnnzodiac", Flag},
                                                                {"sftnnzodiacd", Flag},
                                                                {"sftnnzodiacl", Flag},
                                                                {"sftnrestart", Flag},
                                                                {"sftnrstcont", Flag},
                                                                {"sftnrstpg", Flag},
                                                                {"sftnstart", Value},
                                                                {"sftntj", Flag},
                                                                {"shad", Toggle},
                                                                {"shading", Value},
                                                                {"shidden", Flag},
                                                                {"shift", Flag},
                                                                {"showplaceholdtext", Value},
                                                                {"showxmlerrors", Value},
                                                                {"shp", Destination},
                                                                {"shpbottom", Value},
                                                                {"shpbxcolumn", Flag},
                                                                {"shpbxignore", Flag},
                                                                {"shpbxmargin", Flag},
                                                                {"shpbxpage", Flag},
                                                                {"shpbyignore", Flag},
                                                                {"shpbymargin", Flag},
                                                                {"shpbypage", Flag},
                                                                {"shpbypara", Flag},
                                                                {"shpfblwtxt", Value},
                                                                {"shpfhdr", Value},
                                                                {"shpgrp", Destination},
                                                                {"shpinst", Destination},
                                                                {"shpleft", Value},
                                                                {"shplid", Value},
                                                                {"shplockanchor", Flag},
                                                                {"shppict", Destination},
                                                                {"shpright", Value},
                                                                {"shprslt", Destination},
                                                                {"shptop", Value},
                                                                {"shptxt", Destination},
                                                                {"shpwrk", Value},
                                                                {"shpwr", Value},
                                                                {"shpz", Value},
                                                                {"sl", Value},
                                                                {"slink", Value},
                                                                {"slmult", Value},
                                                                {"slocked", Flag},
                                                                {"sn", Destination},
                                                                {"snaptogridincell", Flag},
                                                                {"snext", Value},
                                                                {"softcol", Flag},
                                                                {"softlheight", Value},
                                                                {"softline", Flag},
                                                                {"softpage", Flag},
                                                                {"sp", Destination},
                                                                {"spersonal", Flag},
                                                                {"spltpgpar", Flag},
                                                                {"splytwnine", Flag},
                                                                {"spriority", Value},
                                                                {"sprsbsp", Flag},
                                                                {"sprslnsp", Flag},
                                                                {"sprsspbf", Flag},
                                                                {"sprstsm", Flag},
                                                                {"sprstsp", Flag},
                                                                {"spv", Flag},
                                                                {"sqformat", Flag},
                                                                {"srauth", Value},
                                                                {"srdate", Value},
                                                                {"sreply", Flag},
                                                                {"ssemihidden", Value},
                                                                {"staticval", Destination},
                                                                {"stextflow", Value},
                                                                {"strike", Toggle},
                                                                {"striked1", Toggle},
                                                                {"stshfbi", Value},
                                                                {"stshfdbch", Value},
                                                                {"stshfhich", Value},
                                                                {"stshfloch", Value},
                                                                {"stylelock", Flag},
                                                                {"stylelockbackcomp", Flag},
                                                                {"stylelockenforced", Flag},
                                                                {"stylelockqfset", Flag},
                                                                {"stylelocktheme", Flag},
                                                                {"stylesheet", Destination},
                                                                {"stylesortmethod", Value},
                                                                {"styrsid", Value},
                                                                {"sub", Flag},
                                                                {"subdocument", Value},
                                                                {"subfontbysize", Flag},
                                                                {"subject", Destination},
                                                                {"sunhideused", Value},
                                                                {"super", Flag},
                                                                {"sv", Destination},
                                                                {"svb", Destination},
                                                                {"swpbdr", Flag},
                                                                {"tab", Symbol},
                                                                {"tabsnoovrlp", Flag},
                                                                {"taprtl", Flag},
                                                                {"tb", Value},
                                                                {"tblind", Value},
                                                                {"tblindtype", Value},
                                                                {"tbllkbestfit", Flag},
                                                                {"tbllkborder", Flag},
                                                                {"tbllkcolor", Flag},
                                                                {"tbllkfont", Flag},
                                                                {"tbllkhdrcols", Flag},
                                                                {"tbllkhdrrows", Flag},
                                                                {"tbllklastcol", Flag},
                                                                {"tbllklastrow", Flag},
                                                                {"tbllknocolband", Flag},
                                                                {"tbllknorowband", Flag},
                                                                {"tbllkshading", Flag},
                                                                {"tblrsid", Value},
                                                                {"tc", Destination},
                                                                {"tcelld", Flag},
                                                                {"tcf", Value},
                                                                {"tcl", Value},
                                                                {"tcn", Flag},
                                                                {"tdfrmtxtBottom", Value},
                                                                {"tdfrmtxtLeft", Value},
                                                                {"tdfrmtxtRight", Value},
                                                                {"tdfrmtxtTop", Value},
                                                                {"template", Destination},
                                                                {"themedata", Destination},
                                                                {"themelang", Value},
                                                                {"themelangcs", Value},
                                                                {"themelangfe", Value},
                                                                {"time", Flag},
                                                                {"title", Destination},
                                                                {"titlepg", Flag},
                                                                {"tldot", Flag},
                                                                {"tleq", Flag},
                                                                {"tlhyph", Flag},
                                                                {"tlmdot", Flag},
                                                                {"tlth", Flag},
                                                                {"tlul", Flag},
                                                                {"toplinepunct", Flag},
                                                                {"tphcol", Flag},
                                                                {"tphmrg", Flag},
                                                                {"tphpg", Flag},
                                                                {"tposnegx", Value},
                                                                {"tposnegy", Value},
                                                                {"tposxc", Flag},
                                                                {"tposxi", Flag},
                                                                {"tposxl", Flag},
                                                                {"tposx", Value},
                                                                {"tposxo", Flag},
                                                                {"tposxr", Flag},
                                                                {"tposy", Value},
                                                                {"tposyb", Flag},
                                                                {"tposyc", Flag},
                                                                {"tposyil", Flag},
                                                                {"tposyin", Flag},
                                                                {"tposyout", Flag},
                                                                {"tposyt", Flag},
                                                                {"tpvmrg", Flag},
                                                                {"tpvpara", Flag},
                                                                {"tpvpg", Flag},
                                                                {"tqc", Flag},
                                                                {"tqdec", Flag},
                                                                {"tqr", Flag},
                                                                {"trackformatting", Value},
                                                                {"trackmoves", Value},
                                                                {"transmf", Flag},
                                                                {"trauth", Value},
                                                                {"trautofit", Toggle},
                                                                {"trbgbdiag", Flag},
                                                                {"trbgcross", Flag},
                                                                {"trbgdcross", Flag},
                                                                {"trbgdkbdiag", Flag},
                                                                {"trbgdkcross", Flag},
                                                                {"trbgdkdcross", Flag},
                                                                {"trbgdkfdiag", Flag},
                                                                {"trbgdkhor", Flag},
                                                                {"trbgdkvert", Flag},
                                                                {"trbgfdiag", Flag},
                                                                {"trbghoriz", Flag},
                                                                {"trbgvert", Flag},
                                                                {"trbrdrb", Flag},
                                                                {"trbrdrh", Flag},
                                                                {"trbrdrl", Flag},
                                                                {"trbrdrr", Flag},
                                                                {"trbrdrt", Flag},
                                                                {"trbrdrv", Flag},
                                                                {"trcbpat", Value},
                                                                {"trcfpat", Value},
                                                                {"trdate", Value},
                                                                {"trftsWidthA", Value},
                                                                {"trftsWidthB", Value},
                                                                {"trftsWidth", Value},
                                                                {"trgaph", Value},
                                                                {"trhdr", Flag},
                                                                {"trkeep", Flag},
                                                                {"trkeepfollow", Flag},
                                                                {"trleft", Value},
                                                                {"trowd", Flag},
                                                                {"trpaddb", Value},
                                                                {"trpaddfb", Value},
                                                                {"trpaddfl", Value},
                                                                {"trpaddfr", Value},
                                                                {"trpaddft", Value},
                                                                {"trpaddl", Value},
                                                                {"trpaddr", Value},
                                                                {"trpaddt", Value},
                                                                {"trpadob", Value},
                                                                {"trpadofb", Value},
                                                                {"trpadofl", Value},
                                                                {"trpadofr", Value},
                                                                {"trpadoft", Value},
                                                                {"trpadol", Value},
                                                                {"trpador", Value},
                                                                {"trpadot", Value},
                                                                {"trpat", Value},
                                                                {"trqc", Flag},
                                                                {"trql", Flag},
                                                                {"trqr", Flag},
                                                                {"trrh", Value},
                                                                {"trshdng", Value},
                                                                {"trspdb", Value},
                                                                {"trspdfb", Value},
                                                                {"trspdfl", Value},
                                                                {"trspdfr", Value},
                                                                {"trspdft", Value},
                                                                {"trspdl", Value},
                                                                {"trspdr", Value},
                                                                {"trspdt", Value},
                                                                {"trspob", Value},
                                                                {"trspofb", Value},
                                                                {"trspofl", Value},
                                                                {"trspofr", Value},
                                                                {"trspoft", Value},
                                                                {"trspol", Value},
                                                                {"trspor", Value},
                                                                {"trspot", Value},
                                                                {"truncatefontheight", Flag},
                                                                {"truncex", Flag},
                                                                {"trwWidthA", Value},
                                                                {"trwWidthB", Value},
                                                                {"trwWidth", Value},
                                                                {"ts", Value},
                                                                {"tsbgbdiag", Flag},
                                                                {"tsbgcross", Flag},
                                                                {"tsbgdcross", Flag},
                                                                {"tsbgdkbdiag", Flag},
                                                                {"tsbgdkcross", Flag},
                                                                {"tsbgdkdcross", Flag},
                                                                {"tsbgdkfdiag", Flag},
                                                                {"tsbgdkhor", Flag},
                                                                {"tsbgdkvert", Flag},
                                                                {"tsbgfdiag", Flag},
                                                                {"tsbghoriz", Flag},
                                                                {"tsbgvert", Flag},
                                                                {"tsbrdrb", Flag},
                                                                {"tsbrdrdgl", Flag},
                                                                {"tsbrdrdgr", Flag},
                                                                {"tsbrdrh", Flag},
                                                                {"tsbrdrl", Flag},
                                                                {"tsbrdrr", Flag},
                                                                {"tsbrdrr", Flag},
                                                                {"tsbrdrt", Flag},
                                                                {"tsbrdrv", Flag},
                                                                {"tscbandhorzeven", Flag},
                                                                {"tscbandhorzodd", Flag},
                                                                {"tscbandsh", Value},
                                                                {"tscbandsv", Value},
                                                                {"tscbandverteven", Flag},
                                                                {"tscbandvertodd", Flag},
                                                                {"tscellcbpat", Value},
                                                                {"tscellcfpat", Value},
                                                                {"tscellpaddb", Value},
                                                                {"tscellpaddfb", Value},
                                                                {"tscellpaddfl", Value},
                                                                {"tscellpaddfr", Value},
                                                                {"tscellpaddft", Value},
                                                                {"tscellpaddl", Value},
                                                                {"tscellpaddr", Value},
                                                                {"tscellpaddt", Value},
                                                                {"tscellpct", Value},
                                                                {"tscellwidth", Value},
                                                                {"tscellwidthfts", Value},
                                                                {"tscfirstcol", Flag},
                                                                {"tscfirstrow", Flag},
                                                                {"tsclastcol", Flag},
                                                                {"tsclastrow", Flag},
                                                                {"tscnecell", Flag},
                                                                {"tscnwcell", Flag},
                                                                {"tscsecell", Flag},
                                                                {"tscswcell", Flag},
                                                                {"tsd", Flag},
                                                                {"tsnowrap", Flag},
                                                                {"tsrowd", Flag},
                                                                {"tsvertalb", Flag},
                                                                {"tsvertalc", Flag},
                                                                {"tsvertalt", Flag},
                                                                {"twoinone", Value},
                                                                {"twoonone", Flag},
                                                                {"tx", Value},
                                                                {"txbxtwalways", Flag},
                                                                {"txbxtwfirst", Flag},
                                                                {"txbxtwfirstlast", Flag},
                                                                {"txbxtwlast", Flag},
                                                                {"txbxtwno", Flag},
                                                                {"txe", Destination},
                                                                {"u", Value},
                                                                {"uc", Value},
                                                                {"ud", Destination},
                                                                {"ul", Toggle},
                                                                {"ulc", Value},
                                                                {"uld", Flag},
                                                                {"uldash", Toggle},
                                                                {"uldashd", Toggle},
                                                                {"uldashdd", Toggle},
                                                                {"uldb", Toggle},
                                                                {"ulhair", Toggle},
                                                                {"ulhwave", Toggle},
                                                                {"ulldash", Toggle},
                                                                {"ulnone", Flag},
                                                                {"ulth", Toggle},
                                                                {"ulth", Toggle},
                                                                {"ulthd", Toggle},
                                                                {"ulthdash", Toggle},
                                                                {"ulthdashd", Toggle},
                                                                {"ulthdashdd", Toggle},
                                                                {"ulthldash", Toggle},
                                                                {"ululdbwave", Toggle},
                                                                {"ulw", Flag},
                                                                {"ulwave", Toggle},
                                                                {"up", Value},
                                                                {"upr", Destination},
                                                                {"urtf", Value},
                                                                {"useltbaln", Flag},
                                                                {"usenormstyforlist", Flag},
                                                                {"userprops", Destination},
                                                                {"usexform", Flag},
                                                                {"utinl", Flag},
                                                                {"v", Toggle},
                                                                {"validatexml", Value},
                                                                {"vern", Value},
                                                                {"version", Value},
                                                                {"vertal", Flag},
                                                                {"vertalb", Flag},
                                                                {"vertalc", Flag},
                                                                {"vertalj", Flag},
                                                                {"vertalt", Flag},
                                                                {"vertdoc", Flag},
                                                                {"vertsect", Flag},
                                                                {"viewbksp", Value},
                                                                {"viewkind", Value},
                                                                {"viewnobound", Flag},
                                                                {"viewscale", Value},
                                                                {"viewzk", Value},
                                                                {"wbitmap", Value},
                                                                {"wbmbitspixel", Value},
                                                                {"wbmplanes", Value},
                                                                {"wbmwidthbyte", Value},
                                                                {"webhidden", Flag},
                                                                {"wgrffmtfilter", Destination},
                                                                {"widctlpar", Flag},
                                                                {"widowctrl", Flag},
                                                                {"windowcaption", Destination},
                                                                {"wmetafile", Value},
                                                                {"wpeqn", Flag},
                                                                {"wpjst", Flag},
                                                                {"wpsp", Flag},
                                                                {"wraparound", Flag},
                                                                {"wrapdefault", Flag},
                                                                {"wrapthrough", Flag},
                                                                {"wraptight", Flag},
                                                                {"wraptrsp", Flag},
                                                                {"writereservation", Destination},
                                                                {"writereservhash", Destination},
                                                                {"wrppunct", Flag},
                                                                {"xe", Destination},
                                                                {"xef", Value},
                                                                {"xform", Destination},
                                                                {"xmlattr", Flag},
                                                                {"xmlattrname", Destination},
                                                                {"xmlattrns", Value},
                                                                {"xmlattrvalue", Destination},
                                                                {"xmlclose", Destination},
                                                                {"xmlname", Destination},
                                                                {"xmlns", Value},
                                                                {"xmlnstbl", Destination},
                                                                {"xmlopen", Destination},
                                                                {"xmlsdttcell", Flag},
                                                                {"xmlsdttpara", Flag},
                                                                {"xmlsdttregular", Flag},
                                                                {"xmlsdttrow", Flag},
                                                                {"xmlsdttunknown", Flag},
                                                                {"yr", Value},
                                                                {"yts", Value},
                                                                {"yxe", Flag},
                                                                {"zwbo", Symbol},
                                                                {"zwj", Symbol},
                                                                {"zwnbo", Symbol},
                                                                {"zwnj", Symbol},
                                                                {nullptr, Symbol}};

namespace RtfReader
{

ControlWord::ControlWord(const QString &name)
    : m_name(name)
{
}

/**
FIXME: This should be table / hash driven
  */
bool ControlWord::isSupportedDestination() const
{
    if ((m_name == "pict") || (m_name == "fonttbl") || (m_name == "stylesheet") || (m_name == "colortbl") || (m_name == "info") || (m_name == "title")
        || (m_name == "generator") || (m_name == "company") || (m_name == "creatim") || (m_name == "printim") || (m_name == "revtim") || (m_name == "operator")
        || (m_name == "comment") || (m_name == "subject") || (m_name == "manager") || (m_name == "category") || (m_name == "doccomm") || (m_name == "keywords")
        || (m_name == "hlinkbase") || (m_name == "userprops") || (m_name == "author") ||
        // destinations from here on are marked supported so content like images inside them are handled,
        // but they don't have their own destination class to parse destination specific control words
        (m_name == "pgdsc") || (m_name == "pgdsctbl") || (m_name == "shppict") || (m_name == "shp") || (m_name == "shpinst") || (m_name == "pntxta")
        || (m_name == "pntxtb") || (m_name == "mmathPr")) {
        return true;
    }
    return false;
}

bool ControlWord::isDestination(const QString &controlword)
{
    for (int i = 0; known_control_words[i].controlword != nullptr; ++i) {
        if (controlword == QString(known_control_words[i].controlword)) {
            if (known_control_words[i].wordtype == Destination) {
                return true;
            } else {
                return false;
            }
        }
    }
    /* this isn't even a control word we recognise */
    return false;
}

bool ControlWord::isKnown() const
{
    for (int i = 0; known_control_words[i].controlword != nullptr; ++i) {
        if (m_name == QString(known_control_words[i].controlword)) {
            return true;
        }
    }
    return false;
}
}
