# ./play.it adventure games collection

The codebase is maintained at [https://git.dotslashplay.it/games-adventure/]

Bug reports and feature requests are tracked at [https://forge.dotslashplay.it/play.it/games-adventure/-/issues]

[https://git.dotslashplay.it/games-adventure/]: https://git.dotslashplay.it/games-adventure/
[https://forge.dotslashplay.it/play.it/games-adventure/-/issues]: https://forge.dotslashplay.it/play.it/games-adventure/-/issues

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only adventure games. These games usually focus on the narrative and should require no fast action from the player. Aside from the narrative, the main drives for the player should be exploration and problem solving.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for ./play.it, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-adventure play.it-adventure.git
cd play.it-adventure.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-adventure
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- A Bird Story
- A Mortician's Tale
- A New Beginning
- A Night at the Watermill
- A Space Adventure
- A Vampyre Story
- A Year of Springs
- Agatha Christie: The ABC Murders
- Agent A: A puzzle in disguise
- Amerzone: The Explorer's Legacy
- Ankh
- Anna's Quest
- Arise: A Simple Story
- Astrologaster
- Bad End Theater
- Bear With Me
- Beautiful Desolation
- Before Your Eyes
- Behind the Frame: The Finest Scenery
- Botanicula
- Broken Age
- Broken Minds
- Broken Sword series:
    - Broken Sword: Shadow of the Templars
    - Broken Sword 2: The Smoking Mirror
    - Broken Sword 3: The Sleeping Dragon
    - Broken Sword 4: The Angel of Death
- Call of the Sea
- Catie in MeowmeowLand
- Chicken Police
- Chook & Sosig: Walk the Plank
- Cinders
- Citizen Sleeper
- Coffee Talk
- Contract Demon
- Criminal Expert
- Dagon: by H. P. Lovecraft
- Dead Synchronicity: Tomorrow Comes Today
- Demetrios - The Big Cynical Adventure
- Deponia series:
    - Deponia
    - Deponia 2: Chaos on Deponia
    - Deponia 3: Goodbye Deponia
- Detective Gallo
- Detective Grimoire
- Devil's Kiss
- Dracula: The Resurrection
- Draugen
- Dream Daddy
- Dropsy
- Edna & Harvey series:
    - Edna & Harvey: The Breakout
    - Edna & Harvey: Harvey's New Eyes
- Finding Paradise
- Fire!
- Firewatch
- Fran Bow
- Gemini Rue
- Goetia
- Gomo
- Gone Home
- Grim Fandango
- Hamilton: The Dating Sim
- Harry Potter setting:
    - Harry Potter and the Mysterious Thief - Part 1
    - Harry Potter and the Mysterious Thief - Part 2
    - Harry Potter and the Transformency Spell
- Hatoful Boyfriend
- Hauma - A Detective Noir Story
- Haven Moon
- Haven Park
- Higurashi When They Cry Hou - Ch.1 Onikakushi
- I Have No Mouth And I Must Scream
- If Not Us
- Indiana Jones games:
    - Indiana Jones and the Last Crusade
    - Indiana Jones and the Fate of Atlantis
- Inspector Waffles
- Irony Curtain
- Jenny LeClue - Detectivú
- J.U.L.I.A Among the Stars
- Kentucky Route Zero
- Lacuna – A Sci-Fi Noir Adventure
- Lamplight City
- Later Daters
- Leisure Suit Larry series:
    - Leisure Suit Larry 1: In the Land of the Lounge Lizards
    - Leisure Suit Larry 2: Looking For Love (In Several Wrong Places)
    - Leisure Suit Larry 3: Passionate Patti in Pursuit of the Pulsating Pectorals!
    - Leisure Suit Larry 5: Passionate Patti Does a Little Undercover Work!
    - Leisure Suit Larry 6: Shape Up Or Slip Out
    - Leisure Suit Larry 7: Love for Sail!
- Letters - a written adventure
- Liar Liar series:
    - Liar Liar
    - Lair Liar 2: Pants on Fire
- Life is Strange
- Lilly Looking Through
- Little Misfortune
- Loom
- Lost Phone series:
    - A Normal Lost Phone
    - Another Lost Phone: Laura's Story
- Machinarium
- Marie's Room
- MechaNika
- Memoranda
- Midnight Scenes: The Highway
- MIND: Path to Thalamus
- My Lovely Family series:
    - My Lovely Daughter
    - My Lovely Wife
- Nine Noir Lives
- Norco
- Old Man's Journey
- One-Eyed Lee series:
    - One-Eyed Lee: Prologue
    - One-Eyed Lee and the Dinner Party
- OneShot
- Oxenfree
- PRIM
- Rakuen
- Resonance
- Return to Mysterious Island series:
    - Return to Mysterious Island
    - Return to Mysterious Island 2
- Samorost series:
    - Samorost
    - Samorost 2
    - Samorost 3
- Sherlock Holmes series (by Frogwares):
    - Sherlock Holmes: The Case of the Silver Earring
    - Sherlock Holmes: The Awakened
    - Sherlock Holmes: Nemesis
    - Sherlock Holmes Versus Jack the Ripper
    - The Testament of Sherlock Holmes
    - Sherlock Holmes: Crimes and Punishments
    - Sherlock Holmes: The Devil's Daughter
- Silence
- State of Mind
- Strangeland
- Subject 13
- Syberia series:
    - Syberia
    - Syberia 2 
    - Syberia 3
    - Syberia: The World Before
- Technobabylon
- The Book of Unwritten Tales series:
    - The Book of Unwritten Tales
    - The Critter Chronicles
    - The Book of Unwritten Tales 2
- The Dark Eye series:
    - The Dark Eye: Chains of Satinav
    - The Dark Eye: Memoria
- The Darkside Detective
- The Dream Machine
- The Excavation of Hob's Barrow
- The First Tree
- The Inner World series:
    - The Inner World
    - The Inner World: The Last Wind Monk
- The Interactive Adventures of Dog Mendonça and Pizzaboy
- The Lion's Song
- The Little Acre
- The Longest Journey series:
    - The Longest Journey
    - Dreamfall Chapters
- The Night of the Rabbit
- The Pillars of the Earth
- The Shivah
- The Suicide of Rachel Foster
- The Tail Makes the Fox
- The Whispered World
- Thimbleweed Park
- To The Moon
- Torin's Passage
- Tormentum: Dark Sorrow
- True Fear series:
    - True Fear: Forsaken Souls Part 1
    - True Fear: Forsaken Souls Part 2
- Tsioque
- Under the Moon
- VirtuaVerse
- Voodoo Detective
- Wallace and Gromit's Grand Adventures series:
    - Wallace and Gromit's Grand Adventures - Episode 1: Fright of the Bumblebees
    - Wallace and Gromit's Grand Adventures - Episode 2: The Last Resort
    - Wallace and Gromit's Grand Adventures - Episode 3: Muzzled
    - Wallace and Gromit's Grand Adventures - Episode 4: The Bogey Man
- Warm
- When The Past Was Around
- Where the Water Tastes Like Wine
- Whispering Willows
- Yesterday
- Zed
- Zork series:
    - Zork 1: The Great Underground Empire
    - Zork 2: The Wizard of Frobozz
    - Zork 3: The Dungeon Master
    - Beyond Zork: The Coconut of Quendor

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.

### Fediverse

./play.it has an account on the Fediverse, you can follow it for news about the development or use it to contact us: [@playit@fediverse.dotslashplay.it]

[@playit@fediverse.dotslashplay.it]: https://fediverse.dotslashplay.it/snac/playit
