/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class AtomicSequenceConverter
extends UnaryExpression {
    public static ToStringMappingFunction TO_STRING_MAPPER = new ToStringMappingFunction();
    private PlainType requiredItemType;
    protected Converter converter;

    public AtomicSequenceConverter(Expression sequence, PlainType requiredItemType) {
        super(sequence);
        this.requiredItemType = requiredItemType;
    }

    public Converter allocateConverter(Configuration config, boolean allowNull) {
        this.converter = this.allocateConverter(config, allowNull, this.getBaseExpression().getItemType());
        return this.converter;
    }

    private Converter getDynamicConverter(Configuration config) {
        return this.allocateConverter(config, false, this.getBaseExpression().getItemType());
    }

    public Converter allocateConverter(Configuration config, boolean allowNull, ItemType sourceType) {
        final ConversionRules rules = config.getConversionRules();
        Converter converter = null;
        if (sourceType instanceof ErrorType) {
            converter = Converter.IDENTITY_CONVERTER;
        } else if (!(sourceType instanceof AtomicType)) {
            converter = null;
        } else if (this.requiredItemType instanceof AtomicType) {
            converter = rules.getConverter((AtomicType)sourceType, (AtomicType)this.requiredItemType);
        } else if (((SimpleType)((Object)this.requiredItemType)).isUnionType()) {
            converter = new StringConverter.StringToUnionConverter(this.requiredItemType, rules);
        }
        if (converter == null && !allowNull) {
            converter = new Converter(rules){

                public ConversionResult convert(AtomicValue input) {
                    Converter converter = rules.getConverter(input.getPrimitiveType(), (AtomicType)AtomicSequenceConverter.this.requiredItemType);
                    if (converter == null) {
                        return new ValidationFailure("Cannot convert value from " + input.getPrimitiveType() + " to " + AtomicSequenceConverter.this.requiredItemType);
                    }
                    return converter.convert(input);
                }
            };
        }
        return converter;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.ATOMIC_SEQUENCE;
    }

    public PlainType getRequiredItemType() {
        return this.requiredItemType;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Expression simplify() throws XPathException {
        Expression operand = this.getBaseExpression().simplify();
        this.setBaseExpression(operand);
        if (operand instanceof Literal && this.requiredItemType instanceof AtomicType) {
            if (Literal.isEmptySequence(operand)) {
                return operand;
            }
            Configuration config = this.getConfiguration();
            this.allocateConverter(config, true);
            if (this.converter != null) {
                GroundedValue val = SequenceExtent.makeSequenceExtent(this.iterate(new EarlyEvaluationContext(config)));
                Literal result = Literal.makeLiteral(val);
                result.setRetainedStaticContext(operand.getRetainedStaticContext());
                return result;
            }
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Expression operand = this.getBaseExpression();
        if (th.isSubType(operand.getItemType(), this.requiredItemType)) {
            return operand;
        }
        if (this.converter == null) {
            this.allocateConverter(config, true);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.optimize(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (this.getBaseExpression() instanceof UntypedSequenceConverter) {
            UntypedSequenceConverter asc = (UntypedSequenceConverter)this.getBaseExpression();
            ItemType ascType = asc.getItemType();
            if (ascType == this.requiredItemType) {
                return this.getBaseExpression();
            }
            if (!(this.requiredItemType != BuiltInAtomicType.STRING && this.requiredItemType != BuiltInAtomicType.UNTYPED_ATOMIC || ascType != BuiltInAtomicType.STRING && ascType != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                UntypedSequenceConverter old = (UntypedSequenceConverter)this.getBaseExpression();
                UntypedSequenceConverter asc2 = new UntypedSequenceConverter(old.getBaseExpression(), this.requiredItemType);
                return asc2.typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
            }
        } else if (this.getBaseExpression() instanceof AtomicSequenceConverter) {
            AtomicSequenceConverter asc = (AtomicSequenceConverter)this.getBaseExpression();
            ItemType ascType = asc.getItemType();
            if (ascType == this.requiredItemType) {
                return this.getBaseExpression();
            }
            if (!(this.requiredItemType != BuiltInAtomicType.STRING && this.requiredItemType != BuiltInAtomicType.UNTYPED_ATOMIC || ascType != BuiltInAtomicType.STRING && ascType != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                AtomicSequenceConverter old = (AtomicSequenceConverter)this.getBaseExpression();
                AtomicSequenceConverter asc2 = new AtomicSequenceConverter(old.getBaseExpression(), this.requiredItemType);
                return asc2.typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
            }
        }
        return this;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x400000;
    }

    public String getStreamerName() {
        return "AtomicSequenceConverter";
    }

    public Expression copy(RebindingMap rebindings) {
        AtomicSequenceConverter atomicConverter = new AtomicSequenceConverter(this.getBaseExpression().copy(rebindings), this.requiredItemType);
        ExpressionTool.copyLocationInfo(this, atomicConverter);
        atomicConverter.setConverter(this.converter);
        return atomicConverter;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        Converter conv = this.converter;
        if (conv == null) {
            conv = this.getDynamicConverter(context.getConfiguration());
        }
        if (conv == Converter.TO_STRING) {
            return new ItemMappingIterator(base, TO_STRING_MAPPER, true);
        }
        AtomicSequenceMappingFunction mapper = new AtomicSequenceMappingFunction();
        mapper.setConverter(conv);
        return new ItemMappingIterator(base, mapper, true);
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue item;
        Converter conv = this.converter;
        if (conv == null) {
            conv = this.getDynamicConverter(context.getConfiguration());
        }
        if ((item = (AtomicValue)this.getBaseExpression().evaluateItem(context)) == null) {
            return null;
        }
        return conv.convert(item).asAtomic();
    }

    public ItemType getItemType() {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType.equals(((AtomicSequenceConverter)other).requiredItemType);
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    public String getExpressionName() {
        return "convert";
    }

    protected String displayOperator(Configuration config) {
        return "convert";
    }

    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("convert", this);
        destination.emitAttribute("from", this.getBaseExpression().getItemType().toString());
        destination.emitAttribute("to", this.requiredItemType.toString());
        if (this.converter instanceof Converter.PromoterToDouble || this.converter instanceof Converter.PromoterToFloat) {
            destination.emitAttribute("flags", "p");
        }
        this.getBaseExpression().export(destination);
        destination.endElement();
    }

    public static class ToStringMappingFunction
    implements ItemMappingFunction {
        public StringValue mapItem(Item item) throws XPathException {
            return StringValue.makeStringValue(item.getStringValueCS());
        }
    }

    public static class AtomicSequenceMappingFunction
    implements ItemMappingFunction {
        private Converter converter;

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public AtomicValue mapItem(Item item) throws XPathException {
            return this.converter.convert((AtomicValue)item).asAtomic();
        }
    }
}

