# Generated by default/object.tt
package Paws::LicenseManager::ConsumptionConfiguration;
  use Moose;
  has BorrowConfiguration => (is => 'ro', isa => 'Paws::LicenseManager::BorrowConfiguration');
  has ProvisionalConfiguration => (is => 'ro', isa => 'Paws::LicenseManager::ProvisionalConfiguration');
  has RenewType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::ConsumptionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::ConsumptionConfiguration object:

  $service_obj->Method(Att1 => { BorrowConfiguration => $value, ..., RenewType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::ConsumptionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->BorrowConfiguration

=head1 DESCRIPTION

Details about a consumption configuration.

=head1 ATTRIBUTES


=head2 BorrowConfiguration => L<Paws::LicenseManager::BorrowConfiguration>

Details about a borrow configuration.


=head2 ProvisionalConfiguration => L<Paws::LicenseManager::ProvisionalConfiguration>

Details about a provisional configuration.


=head2 RenewType => Str

Renewal frequency.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

