# Generated by default/object.tt
package Paws::TimestreamWrite::RejectedRecord;
  use Moose;
  has ExistingVersion => (is => 'ro', isa => 'Int');
  has Reason => (is => 'ro', isa => 'Str');
  has RecordIndex => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamWrite::RejectedRecord

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamWrite::RejectedRecord object:

  $service_obj->Method(Att1 => { ExistingVersion => $value, ..., RecordIndex => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamWrite::RejectedRecord object:

  $result = $service_obj->Method(...);
  $result->Att1->ExistingVersion

=head1 DESCRIPTION

Records that were not successfully inserted into Timestream due to data
validation issues that must be resolved prior to reinserting time
series data into the system.

=head1 ATTRIBUTES


=head2 ExistingVersion => Int

The existing version of the record. This value is populated in
scenarios where an identical record exists with a higher version than
the version in the write request.


=head2 Reason => Str

The reason why a record was not successfully inserted into Timestream.
Possible causes of failure include:

=over

=item *

Records with duplicate data where there are multiple records with the
same dimensions, timestamps, and measure names but different measure
values.

=item *

Records with timestamps that lie outside the retention duration of the
memory store

When the retention window is updated, you will receive a
C<RejectedRecords> exception if you immediately try to ingest data
within the new window. To avoid a C<RejectedRecords> exception, wait
until the duration of the new window to ingest new data. For further
information, see Best Practices for Configuring Timestream
(https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration)
and the explanation of how storage works in Timestream
(https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html).

=item *

Records with dimensions or measures that exceed the Timestream defined
limits.

=back

For more information, see Access Management
(https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html)
in the Timestream Developer Guide.


=head2 RecordIndex => Int

The index of the record in the input request for WriteRecords. Indexes
begin with 0.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamWrite>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

