package Graphics::ColorNamesCMYK::Pantone;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-Pantone'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  '100C' => 0x01004600, # 1,0,70,0
  '101C' => 0x01004e00, # 1,0,78,0
  '102C' => 0x00006400, # 0,0,100,0
  '103C' => 0x00086413, # 0,8,100,19
  '104C' => 0x030a641d, # 3,10,100,29
  '105C' => 0x0f145d2a, # 15,20,93,42
  '106C' => 0x01004f00, # 1,0,79,0
  '107C' => 0x00015800, # 0,1,88,0
  '108C' => 0x00026300, # 0,2,99,0
  '109C' => 0x00056400, # 0,5,100,0
  '110C' => 0x00146408, # 0,20,100,8
  '111C' => 0x00116421, # 0,17,100,33
  '112C' => 0x03126426, # 3,18,100,38
  '113C' => 0x00014a00, # 0,1,74,0
  '114C' => 0x00025000, # 0,2,80,0
  '115C' => 0x00045800, # 0,4,88,0
  '116C' => 0x000a6200, # 0,10,98,0
  '117C' => 0x001a640f, # 0,26,100,15
  '118C' => 0x001a641f, # 0,26,100,31
  '119C' => 0x0b18602d, # 11,24,96,45
  '120C' => 0x00054200, # 0,5,66,0
  '121C' => 0x00064800, # 0,6,72,0
  '122C' => 0x00095000, # 0,9,80,0
  '123C' => 0x00105900, # 0,16,89,0
  '124C' => 0x001d6401, # 0,29,100,1
  '125C' => 0x001f6419, # 0,31,100,25
  '126C' => 0x001e6428, # 0,30,100,40
  '127C' => 0x00033f00, # 0,3,63,0
  '128C' => 0x00074b00, # 0,7,75,0
  '129C' => 0x000a5000, # 0,10,80,0
  '130C' => 0x00206400, # 0,32,100,0
  '131C' => 0x0027640b, # 0,39,100,11
  '132C' => 0x00226424, # 0,34,100,36
  '133C' => 0x0c21623c, # 12,33,98,60
  '134C' => 0x000b3e00, # 0,11,62,0
  '135C' => 0x00124800, # 0,18,72,0
  '136C' => 0x00165300, # 0,22,83,0
  '137C' => 0x00246400, # 0,36,100,0
  '138C' => 0x00366401, # 0,54,100,1
  '139C' => 0x0030641a, # 0,48,100,26
  '140C' => 0x062b643a, # 6,43,100,58
  '141C' => 0x00104400, # 0,16,68,0
  '142C' => 0x00154d00, # 0,21,77,0
  '143C' => 0x001b5500, # 0,27,85,0
  '144C' => 0x00316400, # 0,49,100,0
  '145C' => 0x00316408, # 0,49,100,8
  '146C' => 0x002f641f, # 0,47,100,31
  '147C' => 0x13265734, # 19,38,87,52
  '148C' => 0x00112f00, # 0,17,47,0
  '149C' => 0x00163800, # 0,22,56,0
  '150C' => 0x001e4700, # 0,30,71,0
  '151C' => 0x00366400, # 0,54,100,0
  '152C' => 0x003d6400, # 0,61,100,0
  '153C' => 0x00396411, # 0,57,100,17
  '154C' => 0x00396426, # 0,57,100,38
  '155C' => 0x000d2300, # 0,13,35,0
  '156C' => 0x00173300, # 0,23,51,0
  '157C' => 0x00284700, # 0,40,71,0
  '158C' => 0x003e6100, # 0,62,97,0
  '159C' => 0x00446407, # 0,68,100,7
  '160C' => 0x00406420, # 0,64,100,32
  '161C' => 0x0b3d5c41, # 11,61,92,65
  '162C' => 0x001b2000, # 0,27,32,0
  '163C' => 0x002c3900, # 0,44,57,0
  '164C' => 0x003b5100, # 0,59,81,0
  '165C' => 0x00446000, # 0,68,96,0
  '166C' => 0x004c6400, # 0,76,100,0
  '167C' => 0x0049640f, # 0,73,100,15
  '168C' => 0x024a5e39, # 2,74,94,57
  '169C' => 0x00221500, # 0,34,21,0
  '170C' => 0x00383000, # 0,56,48,0
  '171C' => 0x004a5500, # 0,74,85,0
  '172C' => 0x00506200, # 0,80,98,0
  '173C' => 0x00536304, # 0,83,99,4
  '174C' => 0x00545f25, # 0,84,95,37
  '175C' => 0x0d4e4d3b, # 13,78,77,59
  '176C' => 0x00220900, # 0,34,9,0
  '177C' => 0x003a1d00, # 0,58,29,0
  '178C' => 0x004b3900, # 0,75,57,0
  '179C' => 0x00585500, # 0,88,85,0
  '180C' => 0x01574d0d, # 1,87,77,13
  '181C' => 0x0657472f, # 6,87,71,47
  '182C' => 0x001e0000, # 0,30,0,0
  '183C' => 0x002e0600, # 0,46,6,0
  '184C' => 0x004f1f00, # 0,79,31,0
  '185C' => 0x00645900, # 0,100,89,0
  '186C' => 0x00645005, # 0,100,80,5
  '187C' => 0x00644a1a, # 0,100,74,26
  '188C' => 0x05603836, # 5,96,56,54
  '189C' => 0x002a0300, # 0,42,3,0
  '190C' => 0x00410b00, # 0,65,11,0
  '191C' => 0x00551e00, # 0,85,30,0
  '192C' => 0x00643e00, # 0,100,62,0
  '193C' => 0x00643b0b, # 0,100,59,11
  '194C' => 0x02612b21, # 2,97,43,33
  '196C' => 0x00150200, # 0,21,2,0
  '197C' => 0x002d0700, # 0,45,7,0
  '198C' => 0x00552900, # 0,85,41,0
  '199C' => 0x00644f00, # 0,100,79,0
  '200C' => 0x00644c0d, # 0,100,76,13
  '201C' => 0x00643f1f, # 0,100,63,31
  '202C' => 0x01623a2c, # 1,98,58,44
  '203C' => 0x00220000, # 0,34,0,0
  '204C' => 0x003a0100, # 0,58,1,0
  '205C' => 0x00540f00, # 0,84,15,0
  '206C' => 0x00644502, # 0,100,69,2
  '207C' => 0x00643b1a, # 0,100,59,26
  '208C' => 0x00641d2c, # 0,100,29,44
  '209C' => 0x0f601f37, # 15,96,31,55
  '210C' => 0x012c0000, # 1,44,0,0
  '211C' => 0x003c0000, # 0,60,0,0
  '212C' => 0x004e0200, # 0,78,2,0
  '213C' => 0x005f0900, # 0,95,9,0
  '214C' => 0x01640e03, # 1,100,14,3
  '215C' => 0x02640e15, # 2,100,14,21
  '216C' => 0x0c62112e, # 12,98,17,46
  '217C' => 0x011b0000, # 1,27,0,0
  '218C' => 0x02420000, # 2,66,0,0
  '219C' => 0x005f0000, # 0,95,0,0
  '220C' => 0x00640d1a, # 0,100,13,26
  '221C' => 0x00640e26, # 0,100,14,38
  '222C' => 0x15640734, # 21,100,7,52
  '223C' => 0x04300000, # 4,48,0,0
  '224C' => 0x05400000, # 5,64,0,0
  '225C' => 0x045a0000, # 4,90,0,0
  '226C' => 0x00640002, # 0,100,0,2
  '227C' => 0x03640014, # 3,100,0,20
  '228C' => 0x11640021, # 17,100,0,33
  '229C' => 0x1b640936, # 27,100,9,54
  '230C' => 0x03270000, # 3,39,0,0
  '231C' => 0x053d0000, # 5,61,0,0
  '232C' => 0x07510000, # 7,81,0,0
  '233C' => 0x0b640000, # 11,100,0,0
  '234C' => 0x10640011, # 16,100,0,17
  '235C' => 0x12640025, # 18,100,0,37
  '236C' => 0x05260000, # 5,38,0,0
  '237C' => 0x07350000, # 7,53,0,0
  '238C' => 0x0b460000, # 11,70,0,0
  '239C' => 0x0e510000, # 14,81,0,0
  '240C' => 0x145a0000, # 20,90,0,0
  '241C' => 0x1c640000, # 28,100,0,0
  '242C' => 0x2064001d, # 32,100,0,29
  '243C' => 0x061d0000, # 6,29,0,0
  '244C' => 0x0a2b0000, # 10,43,0,0
  '245C' => 0x0e380000, # 14,56,0,0
  '246C' => 0x1b590000, # 27,89,0,0
  '247C' => 0x1e5e0000, # 30,94,0,0
  '248C' => 0x25640000, # 37,100,0,0
  '249C' => 0x2b640011, # 43,100,0,17
  '250C' => 0x071d0000, # 7,29,0,0
  '251C' => 0x0d2a0000, # 13,42,0,0
  '252C' => 0x1a430000, # 26,67,0,0
  '253C' => 0x285f0000, # 40,95,0,0
  '254C' => 0x2e620000, # 46,98,0,0
  '255C' => 0x35640010, # 53,100,0,16
  '256C' => 0x0b180000, # 11,24,0,0
  '257C' => 0x13270000, # 19,39,0,0
  '258C' => 0x33540000, # 51,84,0,0
  '259C' => 0x40640007, # 64,100,0,7
  '260C' => 0x3c640016, # 60,100,0,22
  '261C' => 0x3c64001f, # 60,100,0,31
  '262C' => 0x3a600631, # 58,96,6,49
  '263C' => 0x0b140000, # 11,20,0,0
  '264C' => 0x17220000, # 23,34,0,0
  '265C' => 0x36430000, # 54,67,0,0
  '266C' => 0x47580000, # 71,88,0,0
  '267C' => 0x51630000, # 81,99,0,0
  '268C' => 0x4f640000, # 79,100,0,0
  '269C' => 0x4c640012, # 76,100,0,18
  '270C' => 0x1d170000, # 29,23,0,0
  '271C' => 0x2c260000, # 44,38,0,0
  '272C' => 0x3d370000, # 61,55,0,0
  '273C' => 0x62610025, # 98,97,0,37
  '274C' => 0x62610031, # 98,97,0,49
  '275C' => 0x6263003a, # 98,99,0,58
  '276C' => 0x5e5d004f, # 94,93,0,79
  '277C' => 0x20080000, # 32,8,0,0
  '278C' => 0x2b110000, # 43,17,0,0
  '279C' => 0x45220000, # 69,34,0,0
  '280C' => 0x64550027, # 100,85,0,39
  '281C' => 0x644e0039, # 100,78,0,57
  '282C' => 0x64480049, # 100,72,0,73
  '283C' => 0x290b0000, # 41,11,0,0
  '284C' => 0x36130000, # 54,19,0,0
  '285C' => 0x5a2f0000, # 90,47,0,0
  '286C' => 0x6450000c, # 100,80,0,12
  '287C' => 0x64510017, # 100,81,0,23
  '288C' => 0x644f0025, # 100,79,0,37
  '289C' => 0x6442004c, # 100,66,0,76
  '290C' => 0x19010000, # 25,1,0,0
  '291C' => 0x26040000, # 38,4,0,0
  '292C' => 0x370d0000, # 55,13,0,0
  '293C' => 0x644c0009, # 100,76,0,9
  '294C' => 0x644a002d, # 100,74,0,45
  '295C' => 0x643f0043, # 100,63,0,67
  '296C' => 0x642e0059, # 100,46,0,89
  '297C' => 0x34000000, # 52,0,0,0
  '298C' => 0x41030000, # 65,3,0,0
  '299C' => 0x4f070000, # 79,7,0,0
  '300C' => 0x64380003, # 100,56,0,3
  '301C' => 0x64330022, # 100,51,0,34
  '302C' => 0x64200044, # 100,32,0,68
  '303C' => 0x64210654, # 100,33,6,84
  '304C' => 0x23000200, # 35,0,2,0
  '305C' => 0x37000100, # 55,0,1,0
  '306C' => 0x4c000000, # 76,0,0,0
  '307C' => 0x64140019, # 100,20,0,25
  '308C' => 0x640a0034, # 100,10,0,52
  '309C' => 0x6408144c, # 100,8,20,76
  '310C' => 0x32000400, # 50,0,4,0
  '311C' => 0x41000600, # 65,0,6,0
  '312C' => 0x5c000c00, # 92,0,12,0
  '313C' => 0x64000b06, # 100,0,11,6
  '314C' => 0x64000d16, # 100,0,13,22
  '315C' => 0x6400112c, # 100,0,17,44
  '316C' => 0x640a1d44, # 100,10,29,68
  '317C' => 0x1a000600, # 26,0,6,0
  '318C' => 0x27000900, # 39,0,9,0
  '319C' => 0x3c001000, # 60,0,16,0
  '320C' => 0x64002401, # 100,0,36,1
  '321C' => 0x6400250a, # 100,0,37,10
  '322C' => 0x64002721, # 100,0,39,33
  '323C' => 0x64002933, # 100,0,41,51
  '324C' => 0x22000a00, # 34,0,10,0
  '325C' => 0x36001400, # 54,0,20,0
  '326C' => 0x51002600, # 81,0,38,0
  '327C' => 0x64003b0d, # 100,0,59,13
  '328C' => 0x6400381e, # 100,0,56,30
  '329C' => 0x6400372a, # 100,0,55,42
  '330C' => 0x5d0e3539, # 93,14,53,57
  '331C' => 0x1b000f00, # 27,0,15,0
  '332C' => 0x23001500, # 35,0,21,0
  '333C' => 0x36002200, # 54,0,34,0
  '334C' => 0x64004401, # 100,0,68,1
  '335C' => 0x64004317, # 100,0,67,23
  '336C' => 0x6301432d, # 99,1,67,45
  '337C' => 0x28001d00, # 40,0,29,0
  '338C' => 0x34002400, # 52,0,36,0
  '339C' => 0x4f003c00, # 79,0,60,0
  '340C' => 0x64005100, # 100,0,81,0
  '341C' => 0x5f014b1a, # 95,1,75,26
  '342C' => 0x5d044b2b, # 93,4,75,43
  '343C' => 0x570d4838, # 87,13,72,56
  '344C' => 0x23002300, # 35,0,35,0
  '345C' => 0x28002600, # 40,0,38,0
  '346C' => 0x34003200, # 52,0,50,0
  '347C' => 0x5c006100, # 92,0,97,0
  '348C' => 0x5d006211, # 93,0,98,17
  '349C' => 0x55035b2c, # 85,3,91,44
  '350C' => 0x4a12513e, # 74,18,81,62
  '351C' => 0x20002100, # 32,0,33,0
  '352C' => 0x25002600, # 37,0,38,0
  '353C' => 0x2a002c00, # 42,0,44,0
  '354C' => 0x55006200, # 85,0,98,0
  '355C' => 0x5d006400, # 93,0,100,0
  '356C' => 0x5b00641a, # 91,0,100,26
  '357C' => 0x5009583c, # 80,9,88,60
  '358C' => 0x20003300, # 32,0,51,0
  '359C' => 0x26003a00, # 38,0,58,0
  '360C' => 0x3b005a00, # 59,0,90,0
  '361C' => 0x44006400, # 68,0,100,0
  '362C' => 0x42006409, # 66,0,100,9
  '363C' => 0x40006418, # 64,0,100,24
  '364C' => 0x3b00642b, # 59,0,100,43
  '365C' => 0x17003800, # 23,0,56,0
  '366C' => 0x1d004000, # 29,0,64,0
  '367C' => 0x25004d00, # 37,0,77,0
  '368C' => 0x36006400, # 54,0,100,0
  '369C' => 0x3a006404, # 58,0,100,4
  '370C' => 0x3100641e, # 49,0,100,30
  '371C' => 0x280a623b, # 40,10,98,59
  '372C' => 0x0f003500, # 15,0,53,0
  '373C' => 0x12003c00, # 18,0,60,0
  '374C' => 0x17004500, # 23,0,69,0
  '375C' => 0x28006200, # 40,0,98,0
  '376C' => 0x30006401, # 48,0,100,1
  '377C' => 0x29006416, # 41,0,100,22
  '378C' => 0x2009643c, # 32,9,100,60
  '379C' => 0x09004500, # 9,0,69,0
  '380C' => 0x0d005300, # 13,0,83,0
  '381C' => 0x12006300, # 18,0,99,0
  '382C' => 0x16006400, # 22,0,100,0
  '383C' => 0x13006412, # 19,0,100,18
  '384C' => 0x0e006423, # 14,0,100,35
  '385C' => 0x110f6034, # 17,15,96,52
  '386C' => 0x06004300, # 6,0,67,0
  '387C' => 0x0a005600, # 10,0,86,0
  '388C' => 0x0b005b00, # 11,0,91,0
  '389C' => 0x0f006300, # 15,0,99,0
  '390C' => 0x14006408, # 20,0,100,8
  '391C' => 0x0a006423, # 10,0,100,35
  '392C' => 0x09076431, # 9,7,100,49
  '393C' => 0x03003f00, # 3,0,63,0
  '394C' => 0x05005400, # 5,0,84,0
  '395C' => 0x06005c00, # 6,0,92,0
  '396C' => 0x07006400, # 7,0,100,0
  '397C' => 0x0b00640d, # 11,0,100,13
  '398C' => 0x0800641a, # 8,0,100,26
  '399C' => 0x02056424, # 2,5,100,36
  '400C' => 0x14111300, # 20,17,19,0
  '401C' => 0x1c191c03, # 28,25,28,3
  '402C' => 0x221e2108, # 34,30,33,8
  '403C' => 0x2724280e, # 39,36,40,14
  '404C' => 0x2d2b2f19, # 45,43,47,25
  '405C' => 0x312f3320, # 49,47,51,32
  '406C' => 0x14131100, # 20,19,17,0
  '408C' => 0x2324200a, # 35,36,32,10
  '409C' => 0x282a2812, # 40,42,40,18
  '410C' => 0x2d302d1a, # 45,48,45,26
  '411C' => 0x33373427, # 51,55,52,39
  '412C' => 0x3d44404a, # 61,68,64,74
  '413C' => 0x19111600, # 25,17,22,0
  '414C' => 0x1f171d03, # 31,23,29,3
  '415C' => 0x271d2409, # 39,29,36,9
  '416C' => 0x2d232b12, # 45,35,43,18
  '417C' => 0x352a341f, # 53,42,52,31
  '418C' => 0x3b303a2c, # 59,48,58,44
  '419C' => 0x4c41425a, # 76,65,66,90
  '420C' => 0x120d0a00, # 18,13,10,0
  '421C' => 0x1c141401, # 28,20,20,1
  '422C' => 0x241a1704, # 36,26,23,4
  '423C' => 0x2c211d09, # 44,33,29,9
  '424C' => 0x34292614, # 52,41,38,20
  '425C' => 0x3f332d21, # 63,51,45,33
  '426C' => 0x51433753, # 81,67,55,83
  '427C' => 0x0e080400, # 14,8,4,0
  '428C' => 0x150d0800, # 21,13,8,0
  '429C' => 0x23171302, # 35,23,19,2
  '430C' => 0x32221b0b, # 50,34,27,11
  '431C' => 0x3f2d2219, # 63,45,34,25
  '432C' => 0x4e392738, # 78,57,39,56
  '433C' => 0x583f2855, # 88,63,40,85
  '434C' => 0x0e110a00, # 14,17,10,0
  '435C' => 0x15180e00, # 21,24,14,0
  '436C' => 0x1e211604, # 30,33,22,4
  '437C' => 0x2c332718, # 44,51,39,24
  '438C' => 0x343e332f, # 52,62,51,47
  '439C' => 0x38443b40, # 56,68,59,64
  '440C' => 0x3d453f4b, # 61,69,63,75
  '441C' => 0x180c0e00, # 24,12,14,0
  '442C' => 0x24141702, # 36,20,23,2
  '443C' => 0x2b191a05, # 43,25,26,5
  '444C' => 0x36232311, # 54,35,35,17
  '445C' => 0x422f2f25, # 66,47,47,37
  '446C' => 0x47353735, # 71,53,55,53
  '447C' => 0x46393f41, # 70,57,63,65
  '448C' => 0x272f5143, # 39,47,81,67
  '449C' => 0x1d2b5743, # 29,43,87,67
  '450C' => 0x192a5840, # 25,42,88,64
  '451C' => 0x1b183d10, # 27,24,61,16
  '452C' => 0x18143006, # 24,20,48,6
  '453C' => 0x14102502, # 20,16,37,2
  '454C' => 0x110c1d00, # 17,12,29,0
  '455C' => 0x121e5e3b, # 18,30,94,59
  '456C' => 0x0c145b1d, # 12,20,91,29
  '457C' => 0x07106016, # 7,16,96,22
  '458C' => 0x0a094702, # 10,9,71,2
  '459C' => 0x09084301, # 9,8,67,1
  '460C' => 0x07043700, # 7,4,55,0
  '461C' => 0x04012b00, # 4,1,43,0
  '462C' => 0x1b34523d, # 27,52,82,61
  '463C' => 0x0d365835, # 13,54,88,53
  '464C' => 0x0735592a, # 7,53,89,42
  '465C' => 0x0d1f3f0c, # 13,31,63,12
  '466C' => 0x0d193406, # 13,25,52,6
  '467C' => 0x0b132a02, # 11,19,42,2
  '468C' => 0x080e2100, # 8,14,33,0
  '469C' => 0x0b40593d, # 11,64,89,61
  '470C' => 0x033e581e, # 3,62,88,30
  '471C' => 0x013f5e13, # 1,63,94,19
  '472C' => 0x00283601, # 0,40,54,1
  '473C' => 0x00182100, # 0,24,33,0
  '474C' => 0x00141c00, # 0,20,28,0
  '475C' => 0x000f1700, # 0,15,23,0
  '476C' => 0x21424c44, # 33,66,76,68
  '477C' => 0x13454e3c, # 19,69,78,60
  '478C' => 0x0c485136, # 12,72,81,54
  '479C' => 0x112c320f, # 17,44,50,15
  '480C' => 0x0e1d2203, # 14,29,34,3
  '481C' => 0x0b171800, # 11,23,24,0
  '482C' => 0x08111400, # 8,17,20,0
  '483C' => 0x0a52513f, # 10,82,81,63
  '484C' => 0x015a5c21, # 1,90,92,33
  '485C' => 0x005f6400, # 0,95,100,0
  '486C' => 0x00322a00, # 0,50,42,0
  '487C' => 0x00251f00, # 0,37,31,0
  '488C' => 0x001c1700, # 0,28,23,0
  '489C' => 0x00161400, # 0,22,20,0
  '490C' => 0x12583b42, # 18,88,59,66
  '491C' => 0x09593b30, # 9,89,59,48
  '492C' => 0x06593c27, # 6,89,60,39
  '494C' => 0x00290700, # 0,41,7,0
  '495C' => 0x001c0100, # 0,28,1,0
  '496C' => 0x00170100, # 0,23,1,0
  '497C' => 0x224d3e43, # 34,77,62,67
  '498C' => 0x174c3d36, # 23,76,61,54
  '499C' => 0x124b3c2e, # 18,75,60,46
  '500C' => 0x0c321505, # 12,50,21,5
  '501C' => 0x07250b00, # 7,37,11,0
  '502C' => 0x021b0600, # 2,27,6,0
  '503C' => 0x01160700, # 1,22,7,0
  '504C' => 0x1d582d41, # 29,88,45,65
  '505C' => 0x155a2234, # 21,90,34,52
  '506C' => 0x14571c25, # 20,87,28,37
  '507C' => 0x072f0601, # 7,47,6,1
  '508C' => 0x01250300, # 1,37,3,0
  '509C' => 0x00200100, # 0,32,1,0
  '510C' => 0x001a0200, # 0,26,2,0
  '511C' => 0x2d5c0c2f, # 45,92,12,47
  '512C' => 0x3060010a, # 48,96,1,10
  '513C' => 0x30600000, # 48,96,0,0
  '514C' => 0x0e330000, # 14,51,0,0
  '515C' => 0x07230000, # 7,35,0,0
  '516C' => 0x041a0000, # 4,26,0,0
  '517C' => 0x01160000, # 1,22,0,0
  '518C' => 0x3c541636, # 60,84,22,54
  '519C' => 0x3e5c0622, # 62,92,6,34
  '520C' => 0x3f630014, # 63,99,0,20
  '521C' => 0x23360000, # 35,54,0,0
  '522C' => 0x18280000, # 24,40,0,0
  '523C' => 0x101e0000, # 16,30,0,0
  '524C' => 0x0b150000, # 11,21,0,0
  '525C' => 0x40620121, # 64,98,1,33
  '526C' => 0x42640000, # 66,100,0,0
  '527C' => 0x3e5d0000, # 62,93,0,0
  '528C' => 0x1f360000, # 31,54,0,0
  '529C' => 0x13260000, # 19,38,0,0
  '530C' => 0x0c1b0000, # 12,27,0,0
  '531C' => 0x08140000, # 8,20,0,0
  '532C' => 0x5c491d59, # 92,73,29,89
  '533C' => 0x5e490545, # 94,73,5,69
  '534C' => 0x64470033, # 100,71,0,51
  '535C' => 0x2c1b0502, # 44,27,5,2
  '536C' => 0x24130300, # 36,19,3,0
  '537C' => 0x180c0100, # 24,12,1,0
  '538C' => 0x13090200, # 19,9,2,0
  '539C' => 0x642b0053, # 100,43,0,83
  '540C' => 0x64350041, # 100,53,0,65
  '541C' => 0x643d002b, # 100,61,0,43
  '542C' => 0x33100000, # 51,16,0,0
  '543C' => 0x23070000, # 35,7,0,0
  '544C' => 0x18040000, # 24,4,0,0
  '545C' => 0x14030000, # 20,3,0,0
  '546C' => 0x61202256, # 97,32,34,86
  '547C' => 0x640b1452, # 100,11,20,82
  '548C' => 0x64080b4a, # 100,8,11,74
  '549C' => 0x39100a02, # 57,16,10,2
  '550C' => 0x2c0a0600, # 44,10,6,0
  '551C' => 0x23060400, # 35,6,4,0
  '552C' => 0x19040100, # 25,4,1,0
  '553C' => 0x4d1c4a43, # 77,28,74,67
  '554C' => 0x50104833, # 80,16,72,51
  '555C' => 0x4d0c4423, # 77,12,68,35
  '556C' => 0x380c2c07, # 56,12,44,7
  '557C' => 0x300a2403, # 48,10,36,3
  '558C' => 0x28071d00, # 40,7,29,0
  '559C' => 0x1f041600, # 31,4,22,0
  '560C' => 0x561e414b, # 86,30,65,75
  '561C' => 0x5b0d3c35, # 91,13,60,53
  '562C' => 0x5c073723, # 92,7,55,35
  '563C' => 0x3a001f00, # 58,0,31,0
  '564C' => 0x2f001900, # 47,0,25,0
  '565C' => 0x23001300, # 35,0,19,0
  '566C' => 0x19000e00, # 25,0,14,0
  '567C' => 0x5818424a, # 88,24,66,74
  '569C' => 0x60013b14, # 96,1,59,20
  '570C' => 0x36001e00, # 54,0,30,0
  '571C' => 0x24001200, # 36,0,18,0
  '572C' => 0x1e000f00, # 30,0,15,0
  '573C' => 0x18000b00, # 24,0,11,0
  '574C' => 0x3116553a, # 49,22,85,58
  '575C' => 0x2f095623, # 47,9,86,35
  '576C' => 0x30064f11, # 48,6,79,17
  '577C' => 0x22033701, # 34,3,55,1
  '578C' => 0x1c012c00, # 28,1,44,0
  '579C' => 0x19012a00, # 25,1,42,0
  '580C' => 0x15002600, # 21,0,38,0
  '581C' => 0x1615603c, # 22,21,96,60
  '582C' => 0x10046425, # 16,4,100,37
  '583C' => 0x18006306, # 24,0,99,6
  '584C' => 0x11004b00, # 17,0,75,0
  '585C' => 0x0c004000, # 12,0,64,0
  '586C' => 0x09003b00, # 9,0,59,0
  '587C' => 0x07003300, # 7,0,51,0
  '600C' => 0x01002c00, # 1,0,44,0
  '601C' => 0x02003100, # 2,0,49,0
  '602C' => 0x02003b00, # 2,0,59,0
  '603C' => 0x04004e00, # 4,0,78,0
  '604C' => 0x05005800, # 5,0,88,0
  '605C' => 0x04016404, # 4,1,100,4
  '606C' => 0x0006640d, # 0,6,100,13
  '607C' => 0x04002c00, # 4,0,44,0
  '608C' => 0x05003500, # 5,0,53,0
  '609C' => 0x07003c00, # 7,0,60,0
  '610C' => 0x0a034a00, # 10,3,74,0
  '611C' => 0x0b055a04, # 11,5,90,4
  '612C' => 0x04056411, # 4,5,100,17
  '613C' => 0x0109641c, # 1,9,100,28
  '614C' => 0x0b052900, # 11,5,41,0
  '615C' => 0x0d083000, # 13,8,48,0
  '616C' => 0x0f093401, # 15,9,52,1
  '617C' => 0x130d4206, # 19,13,66,6
  '618C' => 0x13105212, # 19,16,82,18
  '619C' => 0x10105b1c, # 16,16,91,28
  '620C' => 0x0a10622c, # 10,16,98,44
  '621C' => 0x0d000900, # 13,0,9,0
  '622C' => 0x1b051200, # 27,5,18,0
  '623C' => 0x280a1b01, # 40,10,27,1
  '624C' => 0x35102607, # 53,16,38,7
  '625C' => 0x42153116, # 66,21,49,22
  '626C' => 0x50153c30, # 80,21,60,48
  '627C' => 0x591c4253, # 89,28,66,83
  '628C' => 0x19000400, # 25,0,4,0
  '629C' => 0x24000500, # 36,0,5,0
  '630C' => 0x32000800, # 50,0,8,0
  '631C' => 0x43020b00, # 67,2,11,0
  '632C' => 0x57080e07, # 87,8,14,7
  '633C' => 0x6405091e, # 100,5,9,30
  '634C' => 0x64060130, # 100,6,1,48
  '635C' => 0x20000100, # 32,0,1,0
  '636C' => 0x2a000000, # 42,0,0,0
  '637C' => 0x3c000200, # 60,0,2,0
  '638C' => 0x4d000300, # 77,0,3,0
  '639C' => 0x61040302, # 97,4,3,2
  '640C' => 0x6408000c, # 100,8,0,12
  '641C' => 0x6416001d, # 100,22,0,29
  '642C' => 0x0f040000, # 15,4,0,0
  '643C' => 0x14060000, # 20,6,0,0
  '644C' => 0x260f0000, # 38,15,0,0
  '645C' => 0x33170001, # 51,23,0,1
  '646C' => 0x41220201, # 65,34,2,1
  '647C' => 0x5834030c, # 88,52,3,12
  '648C' => 0x64450038, # 100,69,0,56
  '649C' => 0x0b030000, # 11,3,0,0
  '650C' => 0x10060000, # 16,6,0,0
  '651C' => 0x210f0000, # 33,15,0,0
  '652C' => 0x341b0001, # 52,27,0,1
  '653C' => 0x5436030a, # 84,54,3,10
  '654C' => 0x64490021, # 100,73,0,33
  '655C' => 0x6449003d, # 100,73,0,61
  '656C' => 0x0a020000, # 10,2,0,0
  '657C' => 0x13070000, # 19,7,0,0
  '658C' => 0x1d0b0000, # 29,11,0,0
  '659C' => 0x331a0000, # 51,26,0,0
  '660C' => 0x4a2c0000, # 74,44,0,0
  '661C' => 0x6451000d, # 100,81,0,13
  '662C' => 0x64570024, # 100,87,0,36
  '663C' => 0x05060000, # 5,6,0,0
  '664C' => 0x06080000, # 6,8,0,0
  '665C' => 0x13160000, # 19,22,0,0
  '666C' => 0x23270402, # 35,39,4,2
  '667C' => 0x343a0808, # 52,58,8,8
  '668C' => 0x41480812, # 65,72,8,18
  '669C' => 0x5061002d, # 80,97,0,45
  '670C' => 0x010f0000, # 1,15,0,0
  '671C' => 0x021c0000, # 2,28,0,0
  '672C' => 0x052a0000, # 5,42,0,0
  '673C' => 0x06370000, # 6,55,0,0
  '674C' => 0x0e4c0000, # 14,76,0,0
  '675C' => 0x11620107, # 17,98,1,7
  '676C' => 0x00640723, # 0,100,7,35
  '677C' => 0x03110000, # 3,17,0,0
  '678C' => 0x04140000, # 4,20,0,0
  '679C' => 0x06190000, # 6,25,0,0
  '680C' => 0x0e2c0000, # 14,44,0,0
  '681C' => 0x18400403, # 24,64,4,3
  '682C' => 0x1d50080c, # 29,80,8,12
  '683C' => 0x19600726, # 25,96,7,38
  '684C' => 0x04150000, # 4,21,0,0
  '685C' => 0x061d0000, # 6,29,0,0
  '686C' => 0x0b270100, # 11,39,1,0
  '687C' => 0x13330502, # 19,51,5,2
  '688C' => 0x1a410907, # 26,65,9,7
  '689C' => 0x20550c17, # 32,85,12,23
  '690C' => 0x1a620d3b, # 26,98,13,59
  '691C' => 0x01110500, # 1,17,5,0
  '692C' => 0x03190800, # 3,25,8,0
  '693C' => 0x07260e00, # 7,38,14,0
  '694C' => 0x0c331505, # 12,51,21,5
  '695C' => 0x0f3d1a0b, # 15,61,26,11
  '696C' => 0x104c261b, # 16,76,38,27
  '697C' => 0x0f502e24, # 15,80,46,36
  '698C' => 0x000f0300, # 0,15,3,0
  '699C' => 0x00190400, # 0,25,4,0
  '700C' => 0x00250900, # 0,37,9,0
  '701C' => 0x00381000, # 0,56,16,0
  '702C' => 0x02491e03, # 2,73,30,3
  '703C' => 0x03583410, # 3,88,52,16
  '704C' => 0x015f4b1f, # 1,95,75,31
  '705C' => 0x000c0000, # 0,12,0,0
  '706C' => 0x00130000, # 0,19,0,0
  '707C' => 0x00210400, # 0,33,4,0
  '708C' => 0x00340f00, # 0,52,15,0
  '709C' => 0x00492000, # 0,73,32,0
  '710C' => 0x00583a00, # 0,88,58,0
  '711C' => 0x005e5405, # 0,94,84,5
  '712C' => 0x00132800, # 0,19,40,0
  '713C' => 0x00193100, # 0,25,49,0
  '714C' => 0x00244200, # 0,36,66,0
  '715C' => 0x00325d00, # 0,50,93,0
  '716C' => 0x003b6400, # 0,59,100,0
  '717C' => 0x00456402, # 0,69,100,2
  '718C' => 0x004a640c, # 0,74,100,12
  '719C' => 0x01121f00, # 1,18,31,0
  '720C' => 0x021a2b00, # 2,26,43,0
  '721C' => 0x04223603, # 4,34,54,3
  '722C' => 0x042e4b0d, # 4,46,75,13
  '723C' => 0x01375e19, # 1,55,94,25
  '724C' => 0x00406429, # 0,64,100,41
  '725C' => 0x00446435, # 0,68,100,53
  '726C' => 0x06152100, # 6,21,33,0
  '727C' => 0x081a2702, # 8,26,39,2
  '728C' => 0x0a203106, # 10,32,49,6
  '729C' => 0x0a2b4112, # 10,43,65,18
  '730C' => 0x07335521, # 7,51,85,33
  '731C' => 0x003f6439, # 0,63,100,57
  '732C' => 0x00456444, # 0,69,100,68
  '801C' => 0x55000800, # 85,0,8,0
  '802C' => 0x33005500, # 51,0,85,0
  '803C' => 0x00036100, # 0,3,97,0
  '804C' => 0x00293f00, # 0,41,63,0
  '805C' => 0x003a2900, # 0,58,41,0
  '806C' => 0x00480000, # 0,72,0,0
  '807C' => 0x0c4c0000, # 12,76,0,0
  '808C' => 0x6400121c, # 100,0,18,28
  '809C' => 0x02005209, # 2,0,82,9
  '810C' => 0x00104f00, # 0,16,79,0
  '811C' => 0x002c3a00, # 0,44,58,0
  '812C' => 0x003f2400, # 0,63,36,0
  '813C' => 0x00471602, # 0,71,22,2
  '814C' => 0x23320011, # 35,50,0,17
  '1205C' => 0x00043000, # 0,4,48,0
  '1215C' => 0x00073d00, # 0,7,61,0
  '1225C' => 0x00105000, # 0,16,80,0
  '1235C' => 0x00195e00, # 0,25,94,0
  '1245C' => 0x021f6210, # 2,31,98,16
  '1255C' => 0x031e5f1d, # 3,30,95,29
  '1265C' => 0x0a205c2d, # 10,32,92,45
  '1345C' => 0x000d3200, # 0,13,50,0
  '1355C' => 0x00133d00, # 0,19,61,0
  '1365C' => 0x001c4f00, # 0,28,79,0
  '1375C' => 0x00286100, # 0,40,97,0
  '1385C' => 0x00366405, # 0,54,100,5
  '1395C' => 0x00336427, # 0,51,100,39
  '1405C' => 0x0831613c, # 8,49,97,60
  '1485C' => 0x00224400, # 0,34,68,0
  '1495C' => 0x00316000, # 0,49,96,0
  '1505C' => 0x00406400, # 0,64,100,0
  '1525C' => 0x004d640e, # 0,77,100,14
  '1535C' => 0x00476426, # 0,71,100,38
  '1545C' => 0x00446443, # 0,68,100,67
  '1555C' => 0x001d2800, # 0,29,40,0
  '1565C' => 0x002a3c00, # 0,42,60,0
  '1575C' => 0x003b5a00, # 0,59,90,0
  '1585C' => 0x00426300, # 0,66,99,0
  '1595C' => 0x00466402, # 0,70,100,2
  '1605C' => 0x01425f1e, # 1,66,95,30
  '1615C' => 0x0144622c, # 1,68,98,44
  '1625C' => 0x00292700, # 0,41,39,0
  '1635C' => 0x00353700, # 0,53,55,0
  '1645C' => 0x00445500, # 0,68,85,0
  '1655C' => 0x004d6400, # 0,77,100,0
  '1665C' => 0x00526400, # 0,82,100,0
  '1675C' => 0x004f641a, # 0,79,100,26
  '1685C' => 0x014f5f30, # 1,79,95,48
  '1765C' => 0x002a0900, # 0,42,9,0
  '1767C' => 0x00240500, # 0,36,5,0
  '1775C' => 0x00350f00, # 0,53,15,0
  '1777C' => 0x00481e00, # 0,72,30,0
  '1785C' => 0x00523300, # 0,82,51,0
  '1787C' => 0x00594200, # 0,89,66,0
  '1788C' => 0x005d5200, # 0,93,82,0
  '1795C' => 0x00605201, # 0,96,82,1
  '1797C' => 0x005c4806, # 0,92,72,6
  '1805C' => 0x00614e16, # 0,97,78,22
  '1807C' => 0x035a411c, # 3,90,65,28
  '1815C' => 0x02614834, # 2,97,72,52
  '1817C' => 0x17503a39, # 23,80,58,57
  '1895C' => 0x00200000, # 0,32,0,0
  '1905C' => 0x002f0200, # 0,47,2,0
  '1915C' => 0x00511000, # 0,81,16,0
  '1925C' => 0x00643400, # 0,100,52,0
  '1935C' => 0x00643b08, # 0,100,59,8
  '1945C' => 0x0064301a, # 0,100,48,26
  '1955C' => 0x00642b2b, # 0,100,43,43
  '2365C' => 0x031d0000, # 3,29,0,0
  '2375C' => 0x0c3b0000, # 12,59,0,0
  '2385C' => 0x13520000, # 19,82,0,0
  '2395C' => 0x17600000, # 23,96,0,0
  '2405C' => 0x1f640001, # 31,100,0,1
  '2415C' => 0x23640006, # 35,100,0,6
  '2425C' => 0x24640017, # 36,100,0,23
  '2562C' => 0x0e230000, # 14,35,0,0
  '2563C' => 0x12260000, # 18,38,0,0
  '2567C' => 0x18260000, # 24,38,0,0
  '2572C' => 0x17310000, # 23,49,0,0
  '2573C' => 0x1c340000, # 28,52,0,0
  '2577C' => 0x27380000, # 39,56,0,0
  '2582C' => 0x294d0000, # 41,77,0,0
  '2583C' => 0x2a470000, # 42,71,0,0
  '2587C' => 0x3d530000, # 61,83,0,0
  '2592C' => 0x345d0000, # 52,93,0,0
  '2593C' => 0x3b5e0000, # 59,94,0,0
  '2597C' => 0x52640004, # 82,100,0,4
  '2602C' => 0x3a630000, # 58,99,0,0
  '2603C' => 0x42640004, # 66,100,0,4
  '2607C' => 0x5564000d, # 85,100,0,13
  '2612C' => 0x3d640001, # 61,100,0,1
  '2613C' => 0x44640008, # 68,100,0,8
  '2617C' => 0x55640017, # 85,100,0,23
  '2622C' => 0x395f031b, # 57,95,3,27
  '2623C' => 0x42640014, # 66,100,0,20
  '2627C' => 0x5364002c, # 83,100,0,44
  '2635C' => 0x151b0000, # 21,27,0,0
  '2645C' => 0x22290000, # 34,41,0,0
  '2655C' => 0x31370000, # 49,55,0,0
  '2665C' => 0x41490000, # 65,73,0,0
  '2685C' => 0x61640013, # 97,100,0,19
  '2695C' => 0x5964003a, # 89,100,0,58
  '2705C' => 0x24200000, # 36,32,0,0
  '2706C' => 0x120b0000, # 18,11,0,0
  '2707C' => 0x15070000, # 21,7,0,0
  '2708C' => 0x190c0000, # 25,12,0,0
  '2715C' => 0x342f0000, # 52,47,0,0
  '2716C' => 0x261a0000, # 38,26,0,0
  '2717C' => 0x200d0000, # 32,13,0,0
  '2718C' => 0x41280000, # 65,40,0,0
  '2725C' => 0x49440000, # 73,68,0,0
  '2726C' => 0x53420000, # 83,66,0,0
  '2727C' => 0x4b2d0000, # 75,45,0,0
  '2728C' => 0x634c0000, # 99,76,0,0
  '2735C' => 0x63630005, # 99,99,0,5
  '2736C' => 0x645a0002, # 100,90,0,2
  '2738C' => 0x645b000d, # 100,91,0,13
  '2745C' => 0x64620016, # 100,98,0,22
  '2746C' => 0x645b000a, # 100,91,0,10
  '2747C' => 0x64550025, # 100,85,0,37
  '2748C' => 0x64560023, # 100,86,0,35
  '2755C' => 0x63620023, # 99,98,0,35
  '2756C' => 0x645c001a, # 100,92,0,26
  '2757C' => 0x64510033, # 100,81,0,51
  '2758C' => 0x6453002f, # 100,83,0,47
  '2765C' => 0x6262003c, # 98,98,0,60
  '2766C' => 0x6457003a, # 100,87,0,58
  '2767C' => 0x64470042, # 100,71,0,66
  '2768C' => 0x644e0042, # 100,78,0,66
  '2905C' => 0x2b030000, # 43,3,0,0
  '2915C' => 0x3a080000, # 58,8,0,0
  '2925C' => 0x4b120000, # 75,18,0,0
  '2935C' => 0x643f0002, # 100,63,0,2
  '2945C' => 0x64400010, # 100,64,0,16
  '2955C' => 0x6434003a, # 100,52,0,58
  '2965C' => 0x64280052, # 100,40,0,82
  '2975C' => 0x25000000, # 37,0,0,0
  '2985C' => 0x3a000000, # 58,0,0,0
  '2995C' => 0x4f030000, # 79,3,0,0
  '3005C' => 0x64230002, # 100,35,0,2
  '3015C' => 0x64200019, # 100,32,0,25
  '3025C' => 0x64130038, # 100,19,0,56
  '3035C' => 0x64130a48, # 100,19,10,72
  '3105C' => 0x31000700, # 49,0,7,0
  '3115C' => 0x46000d00, # 70,0,13,0
  '3125C' => 0x59001300, # 89,0,19,0
  '3135C' => 0x6400160a, # 100,0,22,10
  '3145C' => 0x6400181e, # 100,0,24,30
  '3155C' => 0x6400192f, # 100,0,25,47
  '3165C' => 0x64001d40, # 100,0,29,64
  '3242C' => 0x2c001100, # 44,0,17,0
  '3245C' => 0x28001300, # 40,0,19,0
  '3248C' => 0x34002000, # 52,0,32,0
  '3252C' => 0x3b001a00, # 59,0,26,0
  '3255C' => 0x3a001e00, # 58,0,30,0
  '3258C' => 0x3e002300, # 62,0,35,0
  '3262C' => 0x51002800, # 81,0,40,0
  '3265C' => 0x4b002b00, # 75,0,43,0
  '3268C' => 0x56003700, # 86,0,55,0
  '3272C' => 0x64003300, # 100,0,51,0
  '3275C' => 0x5d003900, # 93,0,57,0
  '3278C' => 0x64004100, # 100,0,65,0
  '3282C' => 0x6400360f, # 100,0,54,15
  '3285C' => 0x64003901, # 100,0,57,1
  '3288C' => 0x64004311, # 100,0,67,17
  '3292C' => 0x64003838, # 100,0,56,56
  '3295C' => 0x64003d1c, # 100,0,61,28
  '3298C' => 0x64004328, # 100,0,67,40
  '3302C' => 0x5f0c3840, # 95,12,56,64
  '3305C' => 0x5d0d3d3e, # 93,13,61,62
  '3308C' => 0x5c0e4346, # 92,14,67,70
  '3375C' => 0x29001f00, # 41,0,31,0
  '3385C' => 0x37002d00, # 55,0,45,0
  '3395C' => 0x4d004300, # 77,0,67,0
  '3405C' => 0x5c005500, # 92,0,85,0
  '3415C' => 0x6400551d, # 100,0,85,29
  '3425C' => 0x6002502f, # 96,2,80,47
  '3435C' => 0x570f4d45, # 87,15,77,69
  '3935C' => 0x02004800, # 2,0,72,0
  '3945C' => 0x02006200, # 2,0,98,0
  '3955C' => 0x02006400, # 2,0,100,0
  '3965C' => 0x02006401, # 2,0,100,1
  '3975C' => 0x03066417, # 3,6,100,23
  '3985C' => 0x020c6429, # 2,12,100,41
  '3995C' => 0x1119603c, # 17,25,96,60
  '4485C' => 0x15285a3d, # 21,40,90,61
  '4495C' => 0x111d5425, # 17,29,84,37
  '4505C' => 0x141b4b1a, # 20,27,75,26
  '4515C' => 0x14163b0a, # 20,22,59,10
  '4525C' => 0x11113104, # 17,17,49,4
  '4535C' => 0x0f0d2a01, # 15,13,42,1
  '4545C' => 0x0c0b2400, # 12,11,36,0
  '4625C' => 0x0e4b5b4c, # 14,75,91,76
  '4635C' => 0x0b364c22, # 11,54,76,34
  '4645C' => 0x0e2c3b12, # 14,44,59,18
  '4655C' => 0x0e252f08, # 14,37,47,8
  '4665C' => 0x0c1e2803, # 12,30,40,3
  '4675C' => 0x08151b00, # 8,21,27,0
  '4685C' => 0x06121800, # 6,18,24,0
  '4695C' => 0x134b4f42, # 19,75,79,66
  '4705C' => 0x1340432a, # 19,64,67,42
  '4715C' => 0x15323618, # 21,50,54,24
  '4725C' => 0x1429290b, # 20,41,41,11
  '4735C' => 0x111f2104, # 17,31,33,4
  '4745C' => 0x0e191700, # 14,25,23,0
  '4755C' => 0x0a131100, # 10,19,17,0
  '4975C' => 0x1b5a3e53, # 27,90,62,83
  '4985C' => 0x1846291f, # 24,70,41,31
  '4995C' => 0x173d2213, # 23,61,34,19
  '5005C' => 0x14321b09, # 20,50,27,9
  '5015C' => 0x0d241101, # 13,36,17,1
  '5025C' => 0x081b0900, # 8,27,9,0
  '5035C' => 0x06160900, # 6,22,9,0
  '5115C' => 0x305b113b, # 48,91,17,59
  '5125C' => 0x30521022, # 48,82,16,34
  '5135C' => 0x2b441113, # 43,68,17,19
  '5145C' => 0x22350d07, # 34,53,13,7
  '5155C' => 0x14210701, # 20,33,7,1
  '5165C' => 0x0b150300, # 11,21,3,0
  '5175C' => 0x09120300, # 9,18,3,0
  '5185C' => 0x39521e3b, # 57,82,30,59
  '5195C' => 0x32491a23, # 50,73,26,35
  '5205C' => 0x293a1510, # 41,58,21,16
  '5215C' => 0x1b260c03, # 27,38,12,3
  '5225C' => 0x121b0700, # 18,27,7,0
  '5235C' => 0x0d160500, # 13,22,5,0
  '5245C' => 0x080f0100, # 8,15,1,0
  '5255C' => 0x645e004e, # 100,94,0,78
  '5265C' => 0x504e0b26, # 80,78,11,38
  '5275C' => 0x433f0f15, # 67,63,15,21
  '5285C' => 0x2c280a05, # 44,40,10,5
  '5295C' => 0x1c180400, # 28,24,4,0
  '5305C' => 0x13100100, # 19,16,1,0
  '5315C' => 0x0b090000, # 11,9,0,0
  '5395C' => 0x642c0a5b, # 100,44,10,91
  '5405C' => 0x45251310, # 69,37,19,16
  '5415C' => 0x4122100b, # 65,34,16,11
  '5425C' => 0x34190d04, # 52,25,13,4
  '5435C' => 0x220e0600, # 34,14,6,0
  '5445C' => 0x1a0a0300, # 26,10,3,0
  '5455C' => 0x17080200, # 23,8,2,0
  '5463C' => 0x631f225a, # 99,31,34,90
  '5467C' => 0x58253b50, # 88,37,59,80
  '5473C' => 0x5618212b, # 86,24,33,43
  '5477C' => 0x47243027, # 71,36,48,39
  '5483C' => 0x44171c0e, # 68,23,28,14
  '5487C' => 0x3d202715, # 61,32,39,21
  '5493C' => 0x330f1403, # 51,15,20,3
  '5497C' => 0x30181d07, # 48,24,29,7
  '5503C' => 0x2a0b1000, # 42,11,16,0
  '5507C' => 0x26121601, # 38,18,22,1
  '5513C' => 0x20070a00, # 32,7,10,0
  '5517C' => 0x1d0d1000, # 29,13,16,0
  '5523C' => 0x1b050800, # 27,5,8,0
  '5527C' => 0x180a0d00, # 24,10,13,0
  '5535C' => 0x571f4556, # 87,31,69,86
  '5545C' => 0x461b3623, # 70,27,54,35
  '5555C' => 0x3e182f15, # 62,24,47,21
  '5565C' => 0x32132407, # 50,19,36,7
  '5575C' => 0x2b101e03, # 43,16,30,3
  '5585C' => 0x220b1900, # 34,11,25,0
  '5595C' => 0x17061200, # 23,6,18,0
  '5605C' => 0x4e234a4e, # 78,35,74,78
  '5615C' => 0x391e351b, # 57,30,53,27
  '5625C' => 0x341b2d11, # 52,27,45,17
  '5635C' => 0x28142105, # 40,20,33,5
  '5645C' => 0x23111c02, # 35,17,28,2
  '5655C' => 0x1d0d1700, # 29,13,23,0
  '5665C' => 0x180b1300, # 24,11,19,0
  '5743C' => 0x311a5846, # 49,26,88,70
  '5747C' => 0x2713604c, # 39,19,96,76
  '5753C' => 0x2c18502f, # 44,24,80,47
  '5757C' => 0x2011592e, # 32,17,89,46
  '5763C' => 0x2917451f, # 41,23,69,31
  '5767C' => 0x21124b19, # 33,18,75,25
  '5773C' => 0x26163b12, # 38,22,59,18
  '5777C' => 0x1e103c0b, # 30,16,60,11
  '5783C' => 0x20122f07, # 32,18,47,7
  '5787C' => 0x180c2e03, # 24,12,46,3
  '5793C' => 0x1b0e2602, # 27,14,38,2
  '5797C' => 0x14092700, # 20,9,39,0
  '5803C' => 0x150b2000, # 21,11,32,0
  '5807C' => 0x10061f00, # 16,6,31,0
  '5815C' => 0x1d1d5b41, # 29,29,91,65
  '5825C' => 0x1a165020, # 26,22,80,32
  '5835C' => 0x1a144310, # 26,20,67,16
  '5845C' => 0x18123908, # 24,18,57,8
  '5855C' => 0x150e2f03, # 21,14,47,3
  '5865C' => 0x110a2b01, # 17,10,43,1
  '5875C' => 0x0e082500, # 14,8,37,0
  '100U' => 0x00043200, # 0,4,50,0
  '106U' => 0x00083b00, # 0,8,59,0
  '113U' => 0x000c3f00, # 0,12,63,0
  '120U' => 0x00145600, # 0,20,86,0
  '1205U' => 0x000b2a00, # 0,11,42,0
  '127U' => 0x000a2f01, # 0,10,47,1
  '134U' => 0x00113500, # 0,17,53,0
  '1345U' => 0x00102b00, # 0,16,43,0
  '141U' => 0x00163802, # 0,22,56,2
  '101U' => 0x00053c00, # 0,5,60,0
  '107U' => 0x000a4400, # 0,10,68,0
  '114U' => 0x000f4700, # 0,15,71,0
  '121U' => 0x00144400, # 0,20,68,0
  '1215U' => 0x000f3300, # 0,15,51,0
  '128U' => 0x00123e01, # 0,18,62,1
  '135U' => 0x00183c00, # 0,24,60,0
  '1355U' => 0x00163300, # 0,22,51,0
  '142U' => 0x001d3f03, # 0,29,63,3
  '102U' => 0x00075200, # 0,7,82,0
  '108U' => 0x000d4f00, # 0,13,79,0
  '115U' => 0x00135200, # 0,19,82,0
  '122U' => 0x00194b00, # 0,25,75,0
  '1225U' => 0x001b4500, # 0,27,69,0
  '129U' => 0x001e4b02, # 0,30,75,2
  '136U' => 0x00204700, # 0,32,71,0
  '1365U' => 0x00204000, # 0,32,64,0
  '143U' => 0x00234504, # 0,35,69,4
  '109U' => 0x00166400, # 0,22,100,0
  '116U' => 0x001d5d00, # 0,29,93,0
  '123U' => 0x00215100, # 0,33,81,0
  '1235U' => 0x00204d00, # 0,32,77,0
  '130U' => 0x00255103, # 0,37,81,3
  '137U' => 0x00264e00, # 0,38,78,0
  '1375U' => 0x00284b00, # 0,40,75,0
  '144U' => 0x002a4b05, # 0,42,75,5
  '103U' => 0x000c4d1d, # 0,12,77,29
  '110U' => 0x00165114, # 0,22,81,20
  'Orange 021U' => 0x002a4b05, # 0,42,75,5
  'Process Black U' => 0x00050c53, # 0,5,12,83
  'Process Cyan U' => 0x64160010, # 100,22,0,16
  'Process Magenta U' => 0x00643110, # 0,100,49,16
  'Process Yellow U' => 0x00065b04, # 0,6,91,4
  '117U' => 0x00174a1c, # 0,23,74,28
  '124U' => 0x00214c10, # 0,33,76,16
  '1245U' => 0x001a411b, # 0,26,65,27
  '131U' => 0x001f491b, # 0,31,73,27
  '138U' => 0x00294c11, # 0,41,76,17
  '1385U' => 0x00274614, # 0,39,70,20
  '145U' => 0x00246118, # 0,36,97,24
  'red 032U' => 0x00434004, # 0,67,64,4
  '104U' => 0x00093f27, # 0,9,63,39
  '111U' => 0x000d3e27, # 0,13,62,39
  '118U' => 0x00124026, # 0,18,64,38
  '125U' => 0x00163f23, # 0,22,63,35
  '1255U' => 0x00133825, # 0,19,56,37
  '132U' => 0x00133c29, # 0,19,60,41
  '139U' => 0x001d3e26, # 0,29,62,38
  '1395U' => 0x001a372a, # 0,26,55,42
  '146U' => 0x001a3b26, # 0,26,59,38
  'Blue 072 U' => 0x403d0020, # 64,61,0,32
  '105U' => 0x00062b33, # 0,6,43,51
  '112U' => 0x000c372e, # 0,12,55,46
  '119U' => 0x000a2d30, # 0,10,45,48
  '126U' => 0x0010362c, # 0,16,54,44
  '1265U' => 0x000e2e2f, # 0,14,46,47
  '133U' => 0x000a2b33, # 0,10,43,51
  '140U' => 0x00112e32, # 0,17,46,50
  '1405U' => 0x00102835, # 0,16,40,53
  '147U' => 0x000b2536, # 0,11,37,54
  '148U' => 0x00162f00, # 0,22,47,0
  '1485U' => 0x00233d00, # 0,35,61,0
  '155U' => 0x00132803, # 0,19,40,3
  '1555U' => 0x00182600, # 0,24,38,0
  '162U' => 0x001b2700, # 0,27,39,0
  '1625U' => 0x00222b00, # 0,34,43,0
  '169U' => 0x001c2000, # 0,28,32,0
  '176U' => 0x001f1b00, # 0,31,27,0
  '1765U' => 0x00231d00, # 0,35,29,0
  '1767U' => 0x001b1500, # 0,27,21,0
  '1495U' => 0x002a4400, # 0,42,68,0
  '149U' => 0x001d3603, # 0,29,54,3
  '156U' => 0x00192f03, # 0,25,47,3
  '1565U' => 0x00213100, # 0,33,49,0
  '163U' => 0x00273600, # 0,39,54,0
  '1635U' => 0x00293300, # 0,41,51,0
  '170U' => 0x002d3300, # 0,45,51,0
  '177U' => 0x002d2b00, # 0,45,43,0
  '1775U' => 0x002d2800, # 0,45,40,0
  '1777U' => 0x00322b00, # 0,50,43,0
  '150U' => 0x00284300, # 0,40,67,0
  '1505U' => 0x00324e00, # 0,50,78,0
  '157U' => 0x00263c05, # 0,38,60,5
  '1575U' => 0x00293c00, # 0,41,60,0
  '164U' => 0x002f3f00, # 0,47,63,0
  '1645U' => 0x00323e00, # 0,50,62,0
  '171U' => 0x00353c00, # 0,53,60,0
  '178U' => 0x00363500, # 0,54,53,0
  '1785U' => 0x003c3700, # 0,60,55,0
  '1787U' => 0x003d3701, # 0,61,55,1
  '151U' => 0x002f4c00, # 0,47,76,0
  '158U' => 0x002f4407, # 0,47,68,7
  '1585U' => 0x00304500, # 0,48,69,0
  '165U' => 0x00364800, # 0,54,72,0
  '1655U' => 0x00384600, # 0,56,70,0
  '172U' => 0x003c4600, # 0,60,70,0
  'warm red U' => 0x004a5304, # 0,74,83,4
  '1788U' => 0x003e3d02, # 0,62,61,2
  '152U' => 0x002e480c, # 0,46,72,12
  '1525U' => 0x002f461a, # 0,47,70,26
  '159U' => 0x002c4115, # 0,44,65,21
  '1595U' => 0x002f4311, # 0,47,67,17
  '166U' => 0x0036480c, # 0,54,72,12
  '1665U' => 0x0037440a, # 0,55,68,10
  '173U' => 0x00354013, # 0,53,64,19
  '179U' => 0x003a3e0c, # 0,58,62,12
  '1795U' => 0x003b3b0f, # 0,59,59,15
  '1797U' => 0x003d3b14, # 0,61,59,20
  '153U' => 0x00233e21, # 0,35,62,33
  '1535U' => 0x00233929, # 0,35,57,41
  '160U' => 0x00203726, # 0,32,55,38
  '1605U' => 0x00233623, # 0,35,54,35
  '167U' => 0x002b3d1d, # 0,43,61,29
  '1675U' => 0x002b3921, # 0,43,57,33
  '174U' => 0x002a3527, # 0,42,53,39
  '180U' => 0x00323519, # 0,50,53,25
  '1805U' => 0x0033331d, # 0,51,51,29
  '1807U' => 0x00333223, # 0,51,50,35
  '154U' => 0x001d352b, # 0,29,53,43
  '1545U' => 0x00162934, # 0,22,41,52
  '161U' => 0x00122735, # 0,18,39,53
  '1615U' => 0x001f322a, # 0,31,50,42
  '168U' => 0x001e2e2e, # 0,30,46,46
  '1685U' => 0x0023302a, # 0,35,48,42
  '175U' => 0x001d2633, # 0,29,38,51
  '181U' => 0x0024292d, # 0,36,41,45
  '1815U' => 0x00282b2c, # 0,40,43,44
  '1817U' => 0x001f1f35, # 0,31,31,53
  '182U' => 0x001c1500, # 0,28,21,0
  '189U' => 0x00211800, # 0,33,24,0
  '1895U' => 0x001e1300, # 0,30,19,0
  '196U' => 0x00141104, # 0,20,17,4
  '203U' => 0x001c1104, # 0,28,17,4
  '210U' => 0x00241400, # 0,36,20,0
  '217U' => 0x00150804, # 0,21,8,4
  '223U' => 0x00220d02, # 0,34,13,2
  '230U' => 0x001e0c00, # 0,30,12,0
  '236U' => 0x00210a03, # 0,33,10,3
  '183U' => 0x002d2400, # 0,45,36,0
  '190U' => 0x002f2400, # 0,47,36,0
  '1905U' => 0x00261a01, # 0,38,26,1
  '197U' => 0x00211a05, # 0,33,26,5
  '204U' => 0x002d1f07, # 0,45,31,7
  '211U' => 0x002f1c01, # 0,47,28,1
  '218U' => 0x002d1706, # 0,45,23,6
  '224U' => 0x002d1304, # 0,45,19,4
  '231U' => 0x002f1302, # 0,47,19,2
  '237U' => 0x002a0d05, # 0,42,13,5
  '184U' => 0x00383001, # 0,56,48,1
  '191U' => 0x00372d03, # 0,55,45,3
  '1915U' => 0x00372904, # 0,55,41,4
  '198U' => 0x00362e09, # 0,54,46,9
  '205U' => 0x00392a0a, # 0,57,42,10
  '212U' => 0x00382404, # 0,56,36,4
  '219U' => 0x003c220b, # 0,60,34,11
  '225U' => 0x003b1d08, # 0,59,29,8
  '232U' => 0x00381805, # 0,56,24,5
  '238U' => 0x00341209, # 0,52,18,9
  '185U' => 0x00433c05, # 0,67,60,5
  '192U' => 0x00413707, # 0,65,55,7
  '1925U' => 0x00423509, # 0,66,53,9
  '199U' => 0x0040380d, # 0,64,56,13
  '206U' => 0x0045350f, # 0,69,53,15
  '213U' => 0x00402b09, # 0,64,43,9
  'rubine red U' => 0x00432a0e, # 0,67,42,14
  '226U' => 0x00642f12, # 0,100,47,18
  'Rhodamine red U' => 0x0043200b, # 0,67,32,11
  '239U' => 0x003d160e, # 0,61,22,14
  '186U' => 0x003d3712, # 0,61,55,18
  '193U' => 0x003a3117, # 0,58,49,23
  '1935U' => 0x003e3315, # 0,62,51,21
  '200U' => 0x003a331a, # 0,58,51,26
  '207U' => 0x003a331a, # 0,58,51,26
  '214U' => 0x003d2a12, # 0,61,42,18
  '220U' => 0x0039221f, # 0,57,34,31
  '227U' => 0x003b1f1f, # 0,59,31,31
  '233U' => 0x00412016, # 0,65,32,22
  '240U' => 0x00381518, # 0,56,21,24
  '187U' => 0x00342f20, # 0,52,47,32
  '194U' => 0x002d2624, # 0,45,38,36
  '1945U' => 0x0034291f, # 0,52,41,31
  '201U' => 0x002e2825, # 0,46,40,37
  '208U' => 0x00291c2c, # 0,41,28,44
  '215U' => 0x00352320, # 0,53,35,32
  '221U' => 0x00341e26, # 0,52,30,38
  '228U' => 0x002d172d, # 0,45,23,45
  '234U' => 0x00371a21, # 0,55,26,33
  '241U' => 0x0034151f, # 0,52,21,31
  '188U' => 0x0026232e, # 0,38,35,46
  '195U' => 0x00221d2f, # 0,34,29,47
  '1955U' => 0x002d2429, # 0,45,36,41
  '202U' => 0x0027232c, # 0,39,35,44
  '209U' => 0x00201731, # 0,32,23,49
  '216U' => 0x00261a2e, # 0,38,26,46
  '222U' => 0x00221231, # 0,34,18,49
  '229U' => 0x001f1034, # 0,31,16,52
  '235U' => 0x002e152b, # 0,46,21,43
  '242U' => 0x0025102d, # 0,37,16,45
  '2365U' => 0x00170703, # 0,23,7,3
  '243U' => 0x001a0505, # 0,26,5,5
  '250U' => 0x00160207, # 0,22,2,7
  '256U' => 0x0311000f, # 3,17,0,15
  '2562U' => 0x05190009, # 5,25,0,9
  '2563U' => 0x0619000f, # 6,25,0,15
  '2567U' => 0x0c1b000e, # 12,27,0,14
  '263U' => 0x060f0008, # 6,15,0,8
  '2635U' => 0x0d150009, # 13,21,0,9
  '270U' => 0x1616000d, # 22,22,0,13
  '2375U' => 0x002a0a08, # 0,42,10,8
  '244U' => 0x00220608, # 0,34,6,8
  '251U' => 0x0021000c, # 0,33,0,12
  '257U' => 0x04180014, # 4,24,0,20
  '2572U' => 0x0823000d, # 8,35,0,13
  '2573U' => 0x09210014, # 9,33,0,20
  '2577U' => 0x11240016, # 17,36,0,22
  '264U' => 0x101d000b, # 16,29,0,11
  '2645U' => 0x131c000b, # 19,28,0,11
  '271U' => 0x1b1b0011, # 27,27,0,17
  '2385U' => 0x00320d0c, # 0,50,13,12
  '245U' => 0x002b070c, # 0,43,7,12
  '252U' => 0x002e0113, # 0,46,1,19
  '258U' => 0x07200020, # 7,32,0,32
  '2582U' => 0x0a2b0013, # 10,43,0,19
  '2583U' => 0x0a25001d, # 10,37,0,29
  '2587U' => 0x1428001c, # 20,40,0,28
  '265U' => 0x192a0012, # 25,42,0,18
  '2655U' => 0x1925000f, # 25,37,0,15
  '272U' => 0x21200016, # 33,32,0,22
  '2395U' => 0x003b1210, # 0,59,18,16
  '246U' => 0x003a0d13, # 0,58,13,19
  'Purple U' => 0x00390519, # 0,57,5,25
  '259U' => 0x05220027, # 5,34,0,39
  '2592U' => 0x0b320019, # 11,50,0,25
  '2593U' => 0x0b2a0025, # 11,42,0,37
  '2597U' => 0x152d0024, # 21,45,0,36
  '266U' => 0x1e300017, # 30,48,0,23
  '2665U' => 0x1f2d0015, # 31,45,0,21
  '273U' => 0x23280027, # 35,40,0,39
  '2405U' => 0x0036101b, # 0,54,16,27
  '247U' => 0x00390e1a, # 0,57,14,26
  '253U' => 0x0034031d, # 0,52,3,29
  '260U' => 0x021c002d, # 2,28,0,45
  '2602U' => 0x09300023, # 9,48,0,35
  '2603U' => 0x0927002b, # 9,39,0,43
  '2607U' => 0x13290029, # 19,41,0,41
  '267U' => 0x1b2f0020, # 27,47,0,32
  'Violet U' => 0x2233001e, # 34,51,0,30
  '274U' => 0x2025002d, # 32,37,0,45
  '2415U' => 0x00330f21, # 0,51,15,33
  '248U' => 0x00330d25, # 0,51,13,37
  '254U' => 0x002f0326, # 0,47,3,38
  '261U' => 0x02190031, # 2,25,0,49
  '2612U' => 0x0526002d, # 5,38,0,45
  '2613U' => 0x0724002f, # 7,36,0,47
  '2617U' => 0x1027002e, # 16,39,0,46
  '268U' => 0x1426002c, # 20,38,0,44
  '2685U' => 0x1d2e0023, # 29,46,0,35
  '275U' => 0x1d220031, # 29,34,0,49
  '2425U' => 0x002d0f29, # 0,45,15,41
  '249U' => 0x00240b2f, # 0,36,11,47
  '255U' => 0x00220531, # 0,34,5,49
  '262U' => 0x00140136, # 0,20,1,54
  '2622U' => 0x001a0134, # 0,26,1,52
  '2623U' => 0x041e0034, # 4,30,0,52
  '2627U' => 0x0b220033, # 11,34,0,51
  '269U' => 0x0d1f0032, # 13,31,0,50
  '2695U' => 0x101b0032, # 16,27,0,50
  '276U' => 0x11170038, # 17,23,0,56
  '2705U' => 0x15160009, # 21,22,0,9
  '2706U' => 0x0f0c0005, # 15,12,0,5
  '2707U' => 0x120a0004, # 18,10,0,4
  '2708U' => 0x1a100006, # 26,16,0,6
  '277U' => 0x1c0e0005, # 28,14,0,5
  '283U' => 0x23100007, # 35,16,0,7
  '290U' => 0x1e0b0007, # 30,11,0,7
  '2905U' => 0x2a0f0007, # 42,15,0,7
  '297U' => 0x2f0e0007, # 47,14,0,7
  '2975U' => 0x2a0b0007, # 42,11,0,7
  '2715U' => 0x1d20000d, # 29,32,0,13
  '2716U' => 0x1f190009, # 31,25,0,9
  '2717U' => 0x1f120004, # 31,18,0,4
  '2718U' => 0x3326000f, # 51,38,0,15
  '278U' => 0x29160007, # 41,22,0,7
  '284U' => 0x2f180009, # 47,24,0,9
  '291U' => 0x2e130008, # 46,19,0,8
  '2915U' => 0x39170009, # 57,23,0,9
  '298U' => 0x43160009, # 67,22,0,9
  '2985U' => 0x45140009, # 69,20,0,9
  '2725U' => 0x23280011, # 35,40,0,17
  '2726U' => 0x2d290013, # 45,41,0,19
  '2727U' => 0x39260009, # 57,38,0,9
  '2728U' => 0x3a2e0018, # 58,46,0,24
  '279U' => 0x3a23000e, # 58,35,0,14
  '285U' => 0x41250013, # 65,37,0,19
  '292U' => 0x391b000a, # 57,27,0,10
  '2925U' => 0x471f000e, # 71,31,0,14
  '299U' => 0x5c1f000f, # 92,31,0,15
  '2995U' => 0x5e1c000e, # 94,28,0,14
  '2735U' => 0x2a33001e, # 42,51,0,30
  '2736U' => 0x3130001b, # 49,48,0,27
  '2738U' => 0x39350024, # 57,53,0,36
  '286U' => 0x46300024, # 70,48,0,36
  '293U' => 0x4f2e0022, # 79,46,0,34
  '2935U' => 0x542c0021, # 84,44,0,33
  '300U' => 0x6428001d, # 100,40,0,29
  '3005U' => 0x64250019, # 100,37,0,25
  '2745U' => 0x252d0028, # 37,45,0,40
  '2746U' => 0x2e2c0023, # 46,44,0,35
  '2747U' => 0x362d002c, # 54,45,0,44
  '2748U' => 0x312c002d, # 49,44,0,45
  '280U' => 0x352b0031, # 53,43,0,49
  '287U' => 0x3c290029, # 60,41,0,41
  '294U' => 0x3b23002f, # 59,35,0,47
  '2945U' => 0x4725002d, # 71,37,0,45
  '301U' => 0x481f002c, # 72,31,0,44
  '3015U' => 0x4e1d002a, # 78,29,0,42
  '2755U' => 0x2128002d, # 33,40,0,45
  '2756U' => 0x2522002d, # 37,34,0,45
  '2757U' => 0x2d250033, # 45,37,0,51
  '2758U' => 0x29250034, # 41,37,0,52
  '281U' => 0x2e250036, # 46,37,0,54
  '288U' => 0x3726002f, # 55,38,0,47
  '295U' => 0x341d0037, # 52,29,0,55
  '2955U' => 0x331a0036, # 51,26,0,54
  '302U' => 0x36150035, # 54,21,0,53
  '3025U' => 0x37140034, # 55,20,0,52
  '2765U' => 0x1b220035, # 27,34,0,53
  '2766U' => 0x1e1b0033, # 30,27,0,51
  '2767U' => 0x1a18003d, # 26,24,0,61
  '2768U' => 0x201c0039, # 32,28,0,57
  '282U' => 0x231d003c, # 35,29,0,60
  '289U' => 0x2419003b, # 36,25,0,59
  '296U' => 0x1e11003e, # 30,17,0,62
  '2965U' => 0x2813003c, # 40,19,0,60
  '303U' => 0x2610003c, # 38,16,0,60
  '3035U' => 0x250e003c, # 37,14,0,60
  '304U' => 0x28070007, # 40,7,0,7
  '310U' => 0x3c0a000a, # 60,10,0,10
  '3105U' => 0x4207000d, # 66,7,0,13
  '317U' => 0x19000009, # 25,0,0,9
  '324U' => 0x2800010f, # 40,0,1,15
  '3242U' => 0x3a00040e, # 58,0,4,14
  '3245U' => 0x4100080e, # 65,0,8,14
  '3248U' => 0x31000a13, # 49,0,10,19
  '331U' => 0x25000909, # 37,0,9,9
  '337U' => 0x27000d10, # 39,0,13,16
  '305U' => 0x410e0007, # 65,14,0,7
  '311U' => 0x640d000e, # 100,13,0,14
  '3115U' => 0x64090011, # 100,9,0,17
  '318U' => 0x3402000d, # 52,2,0,13
  '325U' => 0x43000318, # 67,0,3,24
  '3255U' => 0x64000a13, # 100,0,10,19
  '3258U' => 0x3f000b18, # 63,0,11,24
  '332U' => 0x32000a0b, # 50,0,10,11
  '338U' => 0x3d001118, # 61,0,17,24
  '306U' => 0x6415000b, # 100,21,0,11
  '312U' => 0x64100012, # 100,16,0,18
  '3125U' => 0x640c0018, # 100,12,0,24
  '319U' => 0x52030012, # 82,3,0,18
  '326U' => 0x64000521, # 100,0,5,33
  '3262U' => 0x6400061b, # 100,0,6,27
  '3265U' => 0x64000b19, # 100,0,11,25
  '3268U' => 0x4e000d1e, # 78,0,13,30
  '333U' => 0x64000f12, # 100,0,15,18
  '339U' => 0x50001520, # 80,0,21,32
  'Process Blue U' => 0x64210018, # 100,33,0,24
  '313U' => 0x6414001f, # 100,20,0,31
  '3135U' => 0x640e0023, # 100,14,0,35
  '320U' => 0x64050023, # 100,5,0,35
  '327U' => 0x6400072c, # 100,0,7,44
  '3272U' => 0x6400072c, # 100,0,7,44
  '3275U' => 0x64000e21, # 100,0,14,33
  '3278U' => 0x64001127, # 100,0,17,39
  'Green U' => 0x64001321, # 100,0,19,33
  '340U' => 0x64001926, # 100,0,25,38
  '307U' => 0x641c0024, # 100,28,0,36
  '314U' => 0x64120028, # 100,18,0,40
  '3145U' => 0x640c002f, # 100,12,0,47
  '321U' => 0x6405002e, # 100,5,0,46
  '328U' => 0x55000333, # 85,0,3,51
  '3282U' => 0x6400052f, # 100,0,5,47
  '3285U' => 0x64000a2c, # 100,0,10,44
  '3288U' => 0x64000a2c, # 100,0,10,44
  '334U' => 0x64000f2a, # 100,0,15,42
  '341U' => 0x39001235, # 57,0,18,53
  '308U' => 0x39001235, # 57,0,18,53
  '315U' => 0x4a0f0035, # 74,15,0,53
  '3155U' => 0x4d0b0036, # 77,11,0,54
  '322U' => 0x52040035, # 82,4,0,53
  '329U' => 0x3d000336, # 61,0,3,54
  '3292U' => 0x35000439, # 53,0,4,57
  '3295U' => 0x48000833, # 72,0,8,51
  '3298U' => 0x34000937, # 52,0,9,55
  '335U' => 0x47000c33, # 71,0,12,51
  '342U' => 0x2b000e38, # 43,0,14,56
  '309U' => 0x250c003d, # 37,12,0,61
  '316U' => 0x2508003e, # 37,8,0,62
  '3165U' => 0x360a003c, # 54,10,0,60
  '323U' => 0x3504003c, # 53,4,0,60
  '330U' => 0x2000013d, # 32,0,1,61
  '3302U' => 0x2100023e, # 33,0,2,62
  '3305U' => 0x2100053b, # 33,0,5,59
  '3308U' => 0x1a00063e, # 26,0,6,62
  '336U' => 0x31000a37, # 49,0,10,55
  '343U' => 0x1d000a3c, # 29,0,10,60
  '3375U' => 0x3a00120c, # 58,0,18,12
  '344U' => 0x2200140f, # 34,0,20,15
  '351U' => 0x2400160a, # 36,0,22,10
  '358U' => 0x1e00240f, # 30,0,36,15
  '365U' => 0x1000250a, # 16,0,37,10
  '372U' => 0x0d002806, # 13,0,40,6
  '379U' => 0x03003007, # 3,0,48,7
  '386U' => 0x01003205, # 1,0,50,5
  '393U' => 0x00022f03, # 0,2,47,3
  '3935U' => 0x00042e01, # 0,4,46,1
  '3385U' => 0x49001511, # 73,0,21,17
  '345U' => 0x2e001814, # 46,0,24,20
  '352U' => 0x32001b0c, # 50,0,27,12
  '359U' => 0x27002a14, # 39,0,42,20
  '366U' => 0x18002b0e, # 24,0,43,14
  '373U' => 0x15003309, # 21,0,51,9
  '380U' => 0x07003d0b, # 7,0,61,11
  '387U' => 0x04004007, # 4,0,64,7
  '394U' => 0x00024005, # 0,2,64,5
  '3945U' => 0x00053e01, # 0,5,62,1
  '3395U' => 0x64001916, # 100,0,25,22
  '346U' => 0x3b001c1a, # 59,0,28,26
  '353U' => 0x3f002010, # 63,0,32,16
  '360U' => 0x31002e1c, # 49,0,46,28
  '367U' => 0x20003112, # 32,0,49,18
  '374U' => 0x1b003a0b, # 27,0,58,11
  '381U' => 0x0d004910, # 13,0,73,16
  '388U' => 0x08004b09, # 8,0,75,9
  '395U' => 0x00004907, # 0,0,73,7
  '3955U' => 0x00064e02, # 0,6,78,2
  '3405U' => 0x64001f1e, # 100,0,31,30
  '347U' => 0x56002527, # 86,0,37,39
  '354U' => 0x64002e22, # 100,0,46,34
  '361U' => 0x37003521, # 55,0,53,33
  '368U' => 0x2a003d1e, # 42,0,61,30
  '375U' => 0x2b004e15, # 43,0,78,21
  '382U' => 0x18005318, # 24,0,83,24
  '389U' => 0x0e00620e, # 14,0,98,14
  '396U' => 0x0300640b, # 3,0,100,11
  '3965U' => 0x00065b03, # 0,6,91,3
  '3415U' => 0x3f001431, # 63,0,20,49
  '348U' => 0x3d002030, # 61,0,32,48
  '355U' => 0x53002629, # 83,0,38,41
  '362U' => 0x2a002f2a, # 42,0,47,42
  '369U' => 0x27003a25, # 39,0,58,37
  '376U' => 0x23004421, # 35,0,68,33
  '383U' => 0x08004128, # 8,0,65,40
  '390U' => 0x0b004e22, # 11,0,78,34
  '397U' => 0x01004721, # 1,0,71,33
  '3975U' => 0x00084b1d, # 0,8,75,29
  '3425U' => 0x2d001035, # 45,0,16,53
  '349U' => 0x26001737, # 38,0,23,55
  '356U' => 0x37001e33, # 55,0,30,51
  '363U' => 0x23002930, # 35,0,41,48
  '370U' => 0x1800302e, # 24,0,48,46
  '377U' => 0x1400372c, # 20,0,55,44
  '384U' => 0x0400392d, # 4,0,57,45
  '391U' => 0x0100392e, # 1,0,57,46
  '398U' => 0x00003e2a, # 0,0,62,42
  '3985U' => 0x00083c27, # 0,8,60,39
  '3435U' => 0x1a000b3c, # 26,0,11,60
  '350U' => 0x12000f3c, # 18,0,15,60
  '357U' => 0x1a001239, # 26,0,18,57
  '364U' => 0x19002435, # 25,0,36,53
  '371U' => 0x09002037, # 9,0,32,55
  '378U' => 0x06002534, # 6,0,37,52
  '385U' => 0x00022833, # 0,2,40,51
  '392U' => 0x00013033, # 0,1,48,51
  '399U' => 0x00043c2e, # 0,4,60,46
  '3995U' => 0x00062c31, # 0,6,44,49
  '400U' => 0x00030716, # 0,3,7,22
  '406U' => 0x00050716, # 0,5,7,22
  '413U' => 0x0100051a, # 1,0,5,26
  '420U' => 0x01000119, # 1,0,1,25
  '427U' => 0x04010015, # 4,1,0,21
  '434U' => 0x00060510, # 0,6,5,16
  '441U' => 0x05000118, # 5,0,1,24
  '401U' => 0x0003071d, # 0,3,7,29
  '407U' => 0x00050621, # 0,5,6,33
  '414U' => 0x01000421, # 1,0,4,33
  '421U' => 0x0100001d, # 1,0,0,29
  '428U' => 0x0703001c, # 7,3,0,28
  '435U' => 0x0008051c, # 0,8,5,28
  '442U' => 0x0500001d, # 5,0,0,29
  '402U' => 0x00030724, # 0,3,7,36
  '408U' => 0x00050626, # 0,5,6,38
  '415U' => 0x01000426, # 1,0,4,38
  '422U' => 0x02010024, # 2,1,0,36
  '429U' => 0x09040026, # 9,4,0,38
  '436U' => 0x00080622, # 0,8,6,34
  '443U' => 0x08010027, # 8,1,0,39
  '403U' => 0x0003072b, # 0,3,7,43
  '409U' => 0x0006072a, # 0,6,7,42
  '416U' => 0x0100042b, # 1,0,4,43
  '423U' => 0x04010029, # 4,1,0,41
  '430U' => 0x0c06002b, # 12,6,0,43
  '437U' => 0x000a072d, # 0,10,7,45
  '444U' => 0x0802002e, # 8,2,0,46
  '404U' => 0x0004072d, # 0,4,7,45
  '410U' => 0x0006072e, # 0,6,7,46
  '417U' => 0x02000430, # 2,0,4,48
  '424U' => 0x0101002e, # 1,1,0,46
  '431U' => 0x0c050031, # 12,5,0,49
  '438U' => 0x000c0931, # 0,12,9,49
  '445U' => 0x07020037, # 7,2,0,55
  '405U' => 0x00040835, # 0,4,8,53
  '411U' => 0x00070934, # 0,7,9,52
  '418U' => 0x01000534, # 1,0,5,52
  '425U' => 0x02010032, # 2,1,0,50
  '432U' => 0x0a060037, # 10,6,0,55
  '439U' => 0x000a0937, # 0,10,9,55
  '446U' => 0x0600013b, # 6,0,1,59
  'Black U' => 0x0004083e, # 0,4,8,62
  '412U' => 0x00080b3d, # 0,8,11,61
  '419U' => 0x00000441, # 0,0,4,65
  '426U' => 0x0101003b, # 1,1,0,59
  '433U' => 0x0705003e, # 7,5,0,62
  '440U' => 0x00080a3b, # 0,8,10,59
  '447U' => 0x0300033e, # 3,0,3,62
  'warm gray 1U' => 0x0003060e, # 0,3,6,14
  'warm gray 2U' => 0x00040713, # 0,4,7,19
  'warm gray 3U' => 0x00040819, # 0,4,8,25
  'warm gray 4U' => 0x0004081d, # 0,4,8,29
  'warm gray 5U' => 0x00050822, # 0,5,8,34
  'warm gray 6U' => 0x00040724, # 0,4,7,36
  'warm gray 7U' => 0x00050729, # 0,5,7,41
  'warm gray 8U' => 0x0005082c, # 0,5,8,44
  'warm gray 9U' => 0x0005072f, # 0,5,7,47
  'warm gray 10U' => 0x00050831, # 0,5,8,49
  'warm gray 11U' => 0x00050833, # 0,5,8,51
  'cool gray 1' => 0x0000020f, # 0,0,2,15
  'cool gray 2' => 0x00000115, # 0,0,1,21
  'cool gray 3' => 0x04030014, # 4,3,0,20
  'cool gray 4U' => 0x0101001b, # 1,1,0,27
  'cool gray 5U' => 0x0201001f, # 2,1,0,31
  'cool gray 6U' => 0x02010022, # 2,1,0,34
  'cool gray 7U' => 0x03010025, # 3,1,0,37
  'cool gray 8U' => 0x03020028, # 3,2,0,40
  'cool gray 9U' => 0x0402002c, # 4,2,0,44
  'cool gray 10U' => 0x0403002f, # 4,3,0,47
  'cool gray 11U' => 0x05030031, # 5,3,0,49
  '448U' => 0x0006183c, # 0,6,24,60
  '449U' => 0x00061a37, # 0,6,26,55
  '450U' => 0x00071e32, # 0,7,30,50
  '451U' => 0x0003162a, # 0,3,22,42
  '452U' => 0x00011422, # 0,1,20,34
  '453U' => 0x0002131a, # 0,2,19,26
  '454U' => 0x00010f15, # 0,1,15,21
  '4485U' => 0x000a2734, # 0,10,39,52
  '4495U' => 0x0008222c, # 0,8,34,44
  '4505U' => 0x00071f24, # 0,7,31,36
  '4515U' => 0x00071d1f, # 0,7,29,31
  '4525U' => 0x00061b18, # 0,6,27,24
  '4535U' => 0x00061a15, # 0,6,26,21
  '4545U' => 0x00061710, # 0,6,23,16
  '455U' => 0x00072735, # 0,7,39,53
  '456U' => 0x000a342c, # 0,10,52,44
  '457U' => 0x000c3d20, # 0,12,61,32
  '458U' => 0x000a3313, # 0,10,51,19
  '459U' => 0x00082e0d, # 0,8,46,13
  '460U' => 0x00062809, # 0,6,40,9
  '461U' => 0x00052107, # 0,5,33,7
  '462U' => 0x000d1f38, # 0,13,31,56
  '463U' => 0x00112730, # 0,17,39,48
  '464U' => 0x00142d27, # 0,20,45,39
  '465U' => 0x0010251f, # 0,16,37,31
  '466U' => 0x000e2218, # 0,14,34,24
  '467U' => 0x000b1e12, # 0,11,30,18
  '468U' => 0x0008180c, # 0,8,24,12
  '4625U' => 0x00162738, # 0,22,39,56
  '4635U' => 0x0017242b, # 0,23,36,43
  '4645U' => 0x00162125, # 0,22,33,37
  '4655U' => 0x00141f1e, # 0,20,31,30
  '4665U' => 0x00121e15, # 0,18,30,21
  '4675U' => 0x000f1a0f, # 0,15,26,15
  '4685U' => 0x000c160a, # 0,12,22,10
  '469U' => 0x00162734, # 0,22,39,52
  '470U' => 0x001f3224, # 0,31,50,36
  '471U' => 0x00233819, # 0,35,56,25
  '472U' => 0x0021300e, # 0,33,48,14
  '473U' => 0x001c2b07, # 0,28,43,7
  '474U' => 0x00172404, # 0,23,36,4
  '475U' => 0x00131f01, # 0,19,31,1
  '4695U' => 0x00172135, # 0,23,33,53
  '4705U' => 0x00141b2d, # 0,20,27,45
  '4715U' => 0x00121928, # 0,18,25,40
  '4725U' => 0x00111620, # 0,17,22,32
  '4735U' => 0x000f151a, # 0,15,21,26
  '4745U' => 0x000d1213, # 0,13,18,19
  '4755U' => 0x000a0f0e, # 0,10,15,14
  '476U' => 0x000f1939, # 0,15,25,57
  '477U' => 0x00131f33, # 0,19,31,51
  '478U' => 0x0017232c, # 0,23,35,44
  '479U' => 0x00131b21, # 0,19,27,33
  '480U' => 0x00121a16, # 0,18,26,22
  '481U' => 0x000d1511, # 0,13,21,17
  '482U' => 0x000a120d, # 0,10,18,13
  '483U' => 0x001b2533, # 0,27,37,51
  '484U' => 0x002b3325, # 0,43,51,37
  '485U' => 0x003b410b, # 0,59,65,11
  '486U' => 0x00292f06, # 0,41,47,6
  '487U' => 0x00212805, # 0,33,40,5
  '488U' => 0x00181f04, # 0,24,31,4
  '489U' => 0x00131904, # 0,19,25,4
  '490U' => 0x001d1d35, # 0,29,29,53
  '491U' => 0x0025252c, # 0,37,37,44
  '492U' => 0x00292726, # 0,41,39,38
  '493U' => 0x00261f16, # 0,38,31,22
  '494U' => 0x00201b0a, # 0,32,27,10
  '495U' => 0x001b1605, # 0,27,22,5
  '496U' => 0x00161202, # 0,22,18,2
  '497U' => 0x00151838, # 0,21,24,56
  '498U' => 0x001b1d32, # 0,27,29,50
  '499U' => 0x001f212d, # 0,31,33,45
  '500U' => 0x001c181a, # 0,28,24,26
  '501U' => 0x0018140f, # 0,24,20,15
  '502U' => 0x0014120a, # 0,20,18,10
  '503U' => 0x000f0e05, # 0,15,14,5
  '4975U' => 0x001a1c37, # 0,26,28,55
  '4985U' => 0x001a162c, # 0,26,22,44
  '4995U' => 0x00191426, # 0,25,20,38
  '5005U' => 0x0016131e, # 0,22,19,30
  '5015U' => 0x00141215, # 0,20,18,21
  '5025U' => 0x00110f0e, # 0,17,15,14
  '5035U' => 0x000e0d0a, # 0,14,13,10
  '504U' => 0x001b1732, # 0,27,23,50
  '505U' => 0x00211a2e, # 0,33,26,46
  '506U' => 0x00241a28, # 0,36,26,40
  '507U' => 0x001f1513, # 0,31,21,19
  '508U' => 0x001e160d, # 0,30,22,13
  '509U' => 0x001a1308, # 0,26,19,8
  '510U' => 0x00151005, # 0,21,16,5
  '511U' => 0x001b0b37, # 0,27,11,55
  '512U' => 0x0024082e, # 0,36,8,46
  '513U' => 0x00280426, # 0,40,4,38
  '514U' => 0x00210513, # 0,33,5,19
  '515U' => 0x001b060b, # 0,27,6,11
  '516U' => 0x00160509, # 0,22,5,9
  '517U' => 0x00110605, # 0,17,6,5
  '5115U' => 0x00170a38, # 0,23,10,56
  '5125U' => 0x00150433, # 0,21,4,51
  '5135U' => 0x0013042d, # 0,19,4,45
  '5145U' => 0x00100324, # 0,16,3,36
  '5155U' => 0x000f041b, # 0,15,4,27
  '5165U' => 0x000c0414, # 0,12,4,20
  '523U' => 0x020e0010, # 2,14,0,16
  '524U' => 0x010a000e, # 1,10,0,14
  '5185U' => 0x00120a36, # 0,18,10,54
  '5195U' => 0x00100731, # 0,16,7,49
  '5205U' => 0x000f042c, # 0,15,4,44
  '5215U' => 0x000e0424, # 0,14,4,36
  '5225U' => 0x000b0518, # 0,11,5,24
  '5235U' => 0x00090510, # 0,9,5,16
  '5245U' => 0x0008040c, # 0,8,4,12
  '525U' => 0x021a0036, # 2,26,0,54
  '526U' => 0x0c28002b, # 12,40,0,43
  '527U' => 0x102d001f, # 16,45,0,31
  '528U' => 0x0c230012, # 12,35,0,18
  '529U' => 0x081b000c, # 8,27,0,12
  '530U' => 0x05140009, # 5,20,0,9
  '531U' => 0x030f0008, # 3,15,0,8
  '5255U' => 0x0e14003a, # 14,20,0,58
  '5265U' => 0x10120031, # 16,18,0,49
  '5275U' => 0x1011002b, # 16,17,0,43
  '5285U' => 0x0d0e0021, # 13,14,0,33
  '5295U' => 0x090a0018, # 9,10,0,24
  '5305U' => 0x06080012, # 6,8,0,18
  '5315U' => 0x0304000c, # 3,4,0,12
  '532U' => 0x0908003d, # 9,8,0,61
  '533U' => 0x16100035, # 22,16,0,53
  '534U' => 0x1f150031, # 31,21,0,49
  '535U' => 0x180f001c, # 24,15,0,28
  '536U' => 0x130b0014, # 19,11,0,20
  '537U' => 0x0d07000f, # 13,7,0,15
  '538U' => 0x0904000c, # 9,4,0,12
  '539U' => 0x1d12003e, # 29,18,0,62
  '540U' => 0x2b1a0038, # 43,26,0,56
  '541U' => 0x351f0033, # 53,31,0,51
  '542U' => 0x2f150016, # 47,21,0,22
  '543U' => 0x2a130012, # 42,19,0,18
  '544U' => 0x200d000d, # 32,13,0,13
  '545U' => 0x180a000a, # 24,10,0,10
  '5395U' => 0x140f0041, # 20,15,0,65
  '5405U' => 0x1d0d0032, # 29,13,0,50
  '5415U' => 0x1d0c002b, # 29,12,0,43
  '5425U' => 0x1b0b0023, # 27,11,0,35
  '5435U' => 0x14080017, # 20,8,0,23
  '5445U' => 0x0f060011, # 15,6,0,17
  '5455U' => 0x0b04000c, # 11,4,0,12
  '546U' => 0x14090041, # 20,9,0,65
  '547U' => 0x240e003c, # 36,14,0,60
  '548U' => 0x2c0f0038, # 44,15,0,56
  '549U' => 0x280c0020, # 40,12,0,32
  '550U' => 0x240b0019, # 36,11,0,25
  '551U' => 0x1b070013, # 27,7,0,19
  '552U' => 0x1405000e, # 20,5,0,14
  '5463U' => 0x1c090042, # 28,9,0,66
  '5473U' => 0x1f070036, # 31,7,0,54
  '5483U' => 0x1f05002e, # 31,5,0,46
  '5493U' => 0x1c040024, # 28,4,0,36
  '5503U' => 0x1503001a, # 21,3,0,26
  '5513U' => 0x10010014, # 16,1,0,20
  '5523U' => 0x0c000010, # 12,0,0,16
  '5467U' => 0x0c00003f, # 12,0,0,63
  '5477U' => 0x0f000038, # 15,0,0,56
  '5487U' => 0x10010033, # 16,1,0,51
  '5497U' => 0x0d00002a, # 13,0,0,42
  '5507U' => 0x0b000122, # 11,0,1,34
  '5517U' => 0x0900021b, # 9,0,2,27
  '5527U' => 0x08000216, # 8,0,2,22
  '553U' => 0x0d000b3b, # 13,0,11,59
  '554U' => 0x19000e36, # 25,0,14,54
  '555U' => 0x20001033, # 32,0,16,51
  '556U' => 0x1c000c26, # 28,0,12,38
  '557U' => 0x18000b1e, # 24,0,11,30
  '558U' => 0x14000919, # 20,0,9,25
  '559U' => 0x0d000812, # 13,0,8,18
  '5535U' => 0x13000341, # 19,0,3,65
  '5545U' => 0x13000636, # 19,0,6,54
  '5555U' => 0x1100052c, # 17,0,5,44
  '5565U' => 0x0f000524, # 15,0,5,36
  '5575U' => 0x0d00051d, # 13,0,5,29
  '5585U' => 0x0c00051b, # 12,0,5,27
  '5595U' => 0x08000512, # 8,0,5,18
  '560U' => 0x1400033f, # 20,0,3,63
  '561U' => 0x24000539, # 36,0,5,57
  '562U' => 0x30000532, # 48,0,5,50
  '563U' => 0x2400051b, # 36,0,5,27
  '564U' => 0x1f000516, # 31,0,5,22
  '565U' => 0x1f000612, # 31,0,6,18
  '566U' => 0x1400050c, # 20,0,5,12
  '5605U' => 0x0a000a3b, # 10,0,10,59
  '5615U' => 0x0c000735, # 12,0,7,53
  '5625U' => 0x0c00062e, # 12,0,6,46
  '5635U' => 0x0a000626, # 10,0,6,38
  '5645U' => 0x0900061f, # 9,0,6,31
  '5655U' => 0x07000519, # 7,0,5,25
  '5665U' => 0x06000516, # 6,0,5,22
  '567U' => 0x1900063d, # 25,0,6,61
  '574U' => 0x08001a37, # 8,0,26,55
  '5743U' => 0x0500173b, # 5,0,23,59
  '5747U' => 0x03002137, # 3,0,33,55
  '581U' => 0x00032735, # 0,3,39,53
  '5815U' => 0x00032237, # 0,3,34,55
  '600U' => 0x00032237, # 0,3,34,55
  '607U' => 0x00042205, # 0,4,34,5
  '614U' => 0x00041c0c, # 0,4,28,12
  '621U' => 0x0900050d, # 9,0,5,13
  '568U' => 0x2e000932, # 46,0,9,50
  '575U' => 0x0f002231, # 15,0,34,49
  '5753U' => 0x06001633, # 6,0,22,51
  '5757U' => 0x03001f30, # 3,0,31,48
  '582U' => 0x0000342b, # 0,0,52,43
  '5825U' => 0x0004212d, # 0,4,33,45
  '601U' => 0x00032a03, # 0,3,42,3
  '608U' => 0x00042806, # 0,4,40,6
  '615U' => 0x00041f0f, # 0,4,31,15
  '622U' => 0x0c000514, # 12,0,5,20
  '569U' => 0x4500092c, # 69,0,9,44
  '576U' => 0x15002527, # 21,0,37,39
  '5763U' => 0x0700132f, # 7,0,19,47
  '5767U' => 0x03001d28, # 3,0,29,40
  '583U' => 0x0700401e, # 7,0,64,30
  '5835U' => 0x00031f2a, # 0,3,31,42
  '602U' => 0x00042f03, # 0,4,47,3
  '609U' => 0x00052d07, # 0,5,45,7
  '616U' => 0x00042214, # 0,4,34,20
  '623U' => 0x1100061d, # 17,0,6,29
  '570U' => 0x31000918, # 49,0,9,24
  '577U' => 0x1100201e, # 17,0,32,30
  '5773U' => 0x04001225, # 4,0,18,37
  '5777U' => 0x02001b22, # 2,0,27,34
  '584U' => 0x04003510, # 4,0,53,16
  '5845U' => 0x00021e23, # 0,2,30,35
  '603U' => 0x00063b05, # 0,6,59,5
  '610U' => 0x0006360c, # 0,6,54,12
  '617U' => 0x0005251b, # 0,5,37,27
  '624U' => 0x13000625, # 19,0,6,37
  '571U' => 0x2600070f, # 38,0,7,15
  '578U' => 0x0f001c17, # 15,0,28,23
  '5783U' => 0x03000f1b, # 3,0,15,27
  '5787U' => 0x02001919, # 2,0,25,25
  '585U' => 0x01002a0a, # 1,0,42,10
  '5855U' => 0x00031c1a, # 0,3,28,26
  '604U' => 0x00074407, # 0,7,68,7
  '611U' => 0x00083d16, # 0,8,61,22
  '618U' => 0x00052923, # 0,5,41,35
  '625U' => 0x1600062e, # 22,0,6,46
  '572U' => 0x2100070d, # 33,0,7,13
  '579U' => 0x0b001912, # 11,0,25,18
  '5793U' => 0x02000d15, # 2,0,13,21
  '5797U' => 0x01001715, # 1,0,23,21
  '586U' => 0x01002a09, # 1,0,42,9
  '6865U' => 0x00021b14, # 0,2,27,20
  '605U' => 0x000a4b0b, # 0,10,75,11
  '612U' => 0x0009421c, # 0,9,66,28
  '619U' => 0x00062c29, # 0,6,44,41
  '626U' => 0x18000536, # 24,0,5,54
  '573U' => 0x15000409, # 21,0,4,9
  '580U' => 0x0900160e, # 9,0,22,14
  '5803U' => 0x02000d11, # 2,0,13,17
  '5807U' => 0x01001411, # 1,0,20,17
  '587U' => 0x00002407, # 0,0,36,7
  '5875U' => 0x00021910, # 0,2,25,16
  '606U' => 0x000b5013, # 0,11,80,19
  '613U' => 0x00094124, # 0,9,65,36
  '620U' => 0x00062e2f, # 0,6,46,47
  '627U' => 0x1a000540, # 26,0,5,64
  '628U' => 0x1603000a, # 22,3,0,10
  '635U' => 0x1d060006, # 29,6,0,6
  '642U' => 0x0a040008, # 10,4,0,8
  '635U' => 0x1d060006, # 29,6,0,6
  '649U' => 0x05030007, # 5,3,0,7
  '656U' => 0x07030005, # 7,3,0,5
  '663U' => 0x0004000b, # 0,4,0,11
  '670U' => 0x000c0605, # 0,12,6,5
  '677U' => 0x000d0706, # 0,13,7,6
  '684U' => 0x000e0807, # 0,14,8,7
  '691U' => 0x000c0c05, # 0,12,12,5
  '629U' => 0x2406000d, # 36,6,0,13
  '636U' => 0x2a090007, # 42,9,0,7
  '643U' => 0x1108000a, # 17,8,0,10
  '650U' => 0x09050008, # 9,5,0,8
  '657U' => 0x0c070005, # 12,7,0,5
  '664U' => 0x0106000d, # 1,6,0,13
  '671U' => 0x00120806, # 0,18,8,6
  '678U' => 0x0010070a, # 0,16,7,10
  '685U' => 0x00110a0a, # 0,17,10,10
  '692U' => 0x00120f09, # 0,18,15,9
  '630U' => 0x2e090010, # 46,9,0,16
  '637U' => 0x3b0d000a, # 59,13,0,10
  '644U' => 0x1a0d0010, # 26,13,0,16
  '651U' => 0x140b000e, # 20,11,0,14
  '658U' => 0x170d0007, # 23,13,0,7
  '665U' => 0x040b0013, # 4,11,0,19
  '672U' => 0x001c0c09, # 0,28,12,9
  '679U' => 0x00170a0d, # 0,23,10,13
  '686U' => 0x00160b10, # 0,22,11,16
  '693U' => 0x0019150e, # 0,25,21,14
  '631U' => 0x3a0c0014, # 58,12,0,20
  '638U' => 0x4e11000d, # 78,17,0,13
  '645U' => 0x21110017, # 33,17,0,23
  '652U' => 0x1e110017, # 30,17,0,23
  '659U' => 0x2215000a, # 34,21,0,10
  '666U' => 0x070e001a, # 7,14,0,26
  '673U' => 0x0025110d, # 0,37,17,13
  '680U' => 0x001c0c19, # 0,28,12,25
  '687U' => 0x001b0e19, # 0,27,14,25
  '694U' => 0x001c1718, # 0,28,23,24
  '632U' => 0x4510001d, # 69,16,0,29
  '639U' => 0x64170014, # 100,23,0,20
  '646U' => 0x2514001f, # 37,20,0,31
  '653U' => 0x25160024, # 37,22,0,36
  '660U' => 0x32200014, # 50,32,0,20
  '667U' => 0x0b130025, # 11,19,0,37
  '674U' => 0x002c1514, # 0,44,21,20
  '681U' => 0x00200f23, # 0,32,15,35
  '688U' => 0x001d0e24, # 0,29,14,36
  '695U' => 0x00201a20, # 0,32,26,32
  '633U' => 0x4b120026, # 75,18,0,38
  '640U' => 0x641a001b, # 100,26,0,27
  '647U' => 0x27160026, # 39,22,0,38
  '654U' => 0x2719002d, # 39,25,0,45
  '661U' => 0x38270021, # 56,39,0,33
  '668U' => 0x0b15002b, # 11,21,0,43
  '675U' => 0x00321a18, # 0,50,26,24
  '682U' => 0x0023112c, # 0,35,17,44
  '689U' => 0x001f112c, # 0,31,17,44
  '696U' => 0x00221d28, # 0,34,29,40
  '634U' => 0x4b14002e, # 75,20,0,46
  '641U' => 0x641c0023, # 100,28,0,35
  '648U' => 0x28190031, # 40,25,0,49
  '655U' => 0x271b0032, # 39,27,0,50
  '662U' => 0x362a002c, # 54,42,0,44
  '669U' => 0x0b160032, # 11,22,0,50
  '676U' => 0x00341c22, # 0,52,28,34
  '683U' => 0x00251531, # 0,37,21,49
  '690U' => 0x00231733, # 0,35,23,51
  '697U' => 0x0025222e, # 0,37,34,46
  '698U' => 0x000e0d02, # 0,14,13,2
  '705U' => 0x000d0b00, # 0,13,11,0
  '712U' => 0x00152600, # 0,21,38,0
  '719U' => 0x00122105, # 0,18,33,5
  '726U' => 0x000f1b09, # 0,15,27,9
  '699U' => 0x00171301, # 0,23,19,1
  '706U' => 0x00151100, # 0,21,17,0
  '713U' => 0x00182c00, # 0,24,44,0
  '720U' => 0x00152607, # 0,21,38,7
  '727U' => 0x0012200e, # 0,18,32,14
  '700U' => 0x001f1b03, # 0,31,27,3
  '707U' => 0x001f1900, # 0,31,25,0
  '714U' => 0x001f3400, # 0,31,52,0
  '721U' => 0x00192b0c, # 0,25,43,12
  '728U' => 0x00142415, # 0,20,36,21
  '701U' => 0x00272109, # 0,39,33,9
  '708U' => 0x00282200, # 0,40,34,0
  '715U' => 0x00273c02, # 0,39,60,2
  '722U' => 0x001c2f15, # 0,28,47,21
  '729U' => 0x0016251b, # 0,22,37,27
  '702U' => 0x002c260f, # 0,44,38,15
  '709U' => 0x00322c03, # 0,50,44,3
  '716U' => 0x002b4108, # 0,43,65,8
  '723U' => 0x001e311b, # 0,30,49,27
  '730U' => 0x00182923, # 0,24,41,35
  '703U' => 0x00322c1d, # 0,50,44,29
  '710U' => 0x0039330b, # 0,57,51,11
  '717U' => 0x002e4610, # 0,46,70,16
  '724U' => 0x001e3423, # 0,30,52,35
  '731U' => 0x00182a2a, # 0,24,42,42
  '704U' => 0x00332f24, # 0,51,47,36
  '711U' => 0x003d3b13, # 0,61,59,19
  '718U' => 0x002e4516, # 0,46,69,22
  '725U' => 0x001e342a, # 0,30,52,42
  '732U' => 0x00182b2f, # 0,24,43,47
  'black 2U' => 0x0004123d, # 0,4,18,61
  'black 3U' => 0x04000440, # 4,0,4,64
  'black 4U' => 0x0009123b, # 0,9,18,59
  'black 5U' => 0x000e0c3b, # 0,14,12,59
  'black 6U' => 0x0c090042, # 12,9,0,66
  'black 7U' => 0x0004073a, # 0,4,7,58
  '801U' => 0x64180014, # 100,24,0,20
  '802U' => 0x48004712, # 72,0,71,18
  '803U' => 0x00095b00, # 0,9,91,0
  '804U' => 0x00214400, # 0,33,68,0
  '805U' => 0x00373500, # 0,55,53,0
  '806U' => 0x00481f00, # 0,72,31,0
  '807U' => 0x004c1209, # 0,76,18,9
  '808U' => 0x64001121, # 100,0,17,33
  '809U' => 0x02004b09, # 2,0,75,9
  '810U' => 0x00114c00, # 0,17,76,0
  '811U' => 0x002f3c00, # 0,47,60,0
  '812U' => 0x00412a00, # 0,65,42,0
  '813U' => 0x00491904, # 0,73,25,4
  '814U' => 0x26350016, # 38,53,0,22
  '4278C' => 0x03030031, # 3,3,0,49
  '4278U' => 0x0303002f, # 3,3,0,47
  '7547U' => 0x0d0a0040, # 13,10,0,64
  '7547C' => 0x361b0054, # 54,27,0,84
  '7546U' => 0x10080034, # 16,8,0,52
  '7546C' => 0x2f150049, # 47,21,0,73
  '7545U' => 0x0f08002c, # 15,8,0,44
  '7545C' => 0x210e003d, # 33,14,0,61
  '7544C' => 0x1308002b, # 19,8,0,43
  '7544U' => 0x0c06001f, # 12,6,0,31
  '7543U' => 0x09040019, # 9,4,0,25
  '7543C' => 0x0d060020, # 13,6,0,32
  '7542C' => 0x0f030018, # 15,3,0,24
  '7541C' => 0x0400000b, # 4,0,0,11
  '7541U' => 0x0401000a, # 4,1,0,10
  '7540U' => 0x0a060033, # 10,6,0,51
  '7540C' => 0x0b060043, # 11,6,0,67
  '7539C' => 0x0100052c, # 1,0,5,44
  '7539U' => 0x02010025, # 2,1,0,37
  '7538U' => 0x03000121, # 3,0,1,33
  '7538C' => 0x04000628, # 4,0,6,40
  '7537C' => 0x03000621, # 3,0,6,33
  '7537U' => 0x0200011c, # 2,0,1,28
  '7536U' => 0x00040a1f, # 0,4,10,31
  '7536C' => 0x00041223, # 0,4,18,35
  '7535C' => 0x00040f1c, # 0,4,15,28
  '7535U' => 0x00030819, # 0,3,8,25
  '7534C' => 0x00020a12, # 0,2,10,18
  '7534U' => 0x00020612, # 0,2,6,18
  '7533C' => 0x00172a48, # 0,23,42,72
  '7533U' => 0x00091039, # 0,9,16,57
  '7532C' => 0x0012263d, # 0,18,38,61
  '7532U' => 0x00080f35, # 0,8,15,53
  '7531C' => 0x000f1e34, # 0,15,30,52
  '7531U' => 0x00090d2d, # 0,9,13,45
  '7530C' => 0x000a1424, # 0,10,20,36
  '7530U' => 0x00080c22, # 0,8,12,34
  '7529C' => 0x0008101c, # 0,8,16,28
  '7529U' => 0x00060a1b, # 0,6,10,27
  '7529U' => 0x00060a1b, # 0,6,10,27
  '7528C' => 0x00060d17, # 0,6,13,23
  '7528U' => 0x00050712, # 0,5,7,18
  '7528U' => 0x00050712, # 0,5,7,18
  '7527C' => 0x00020810, # 0,2,8,16
  '7527U' => 0x0002050e, # 0,2,5,14
  '7526C' => 0x003b502e, # 0,59,80,46
  '7526U' => 0x00232c2b, # 0,35,44,43
  '7525C' => 0x001f3128, # 0,31,49,40
  '7525U' => 0x00151b28, # 0,21,27,40
  '7524C' => 0x00323824, # 0,50,56,36
  '7524U' => 0x00212324, # 0,33,35,36
  '7523C' => 0x002e3121, # 0,46,49,33
  '7523U' => 0x001f1e22, # 0,31,30,34
  '7522C' => 0x0029351d, # 0,41,53,29
  '7522U' => 0x001f231f, # 0,31,35,31
  '7521C' => 0x00132019, # 0,19,32,25
  '7521U' => 0x00121817, # 0,18,24,23
  '7520C' => 0x00131908, # 0,19,25,8
  '7520U' => 0x00131505, # 0,19,21,5
  '7519C' => 0x00132340, # 0,19,35,64
  '7519U' => 0x00090d36, # 0,9,13,54
  '7518C' => 0x001c2339, # 0,28,35,57
  '7518U' => 0x000c0c31, # 0,12,12,49
  '7517C' => 0x00324d30, # 0,50,77,48
  '7517U' => 0x001d292a, # 0,29,41,42
  '7516C' => 0x001d292a, # 0,29,41,42
  '7516U' => 0x001c2725, # 0,28,39,37
  '7515C' => 0x001d2f17, # 0,29,47,23
  '7515U' => 0x001a2318, # 0,26,35,24
  '7514C' => 0x00182510, # 0,24,37,16
  '7514U' => 0x00161c0f, # 0,22,28,15
  '7513C' => 0x00131a0c, # 0,19,26,12
  '7513U' => 0x00131609, # 0,19,22,9
  '7512C' => 0x00285423, # 0,40,84,35
  '7512U' => 0x001d3529, # 0,29,53,41
  '7511C' => 0x00234e1c, # 0,35,78,28
  '7511U' => 0x001d3423, # 0,29,52,35
  '7510C' => 0x001f4416, # 0,31,68,22
  '7510U' => 0x001b3119, # 0,27,49,25
  '7509C' => 0x00173710, # 0,23,55,16
  '7509U' => 0x00172d12, # 0,23,45,18
  '7508C' => 0x00122c0c, # 0,18,44,12
  '7508U' => 0x0014290c, # 0,20,41,12
  '7508U' => 0x0014290c, # 0,20,41,12
  '7507C' => 0x00112701, # 0,17,39,1
  '7507U' => 0x000d2100, # 0,13,33,0
  '7506C' => 0x00081a06, # 0,8,26,6
  '7506U' => 0x000a1b02, # 0,10,27,2
  '7505C' => 0x001a3231, # 0,26,50,49
  '7505U' => 0x000e192f, # 0,14,25,47
  '7504C' => 0x0012252a, # 0,18,37,42
  '7504U' => 0x000c172a, # 0,12,23,42
  '7503C' => 0x00092622, # 0,9,38,34
  '7503U' => 0x00071b26, # 0,7,27,38
  '7502C' => 0x000b2213, # 0,11,34,19
  '7502U' => 0x000c2016, # 0,12,32,22
  '7501C' => 0x00081b0f, # 0,8,27,15
  '7501U' => 0x00091a0d, # 0,9,26,13
  '7500C' => 0x0006190d, # 0,6,25,13
  '7500U' => 0x00071a0a, # 0,7,26,10
  '7499C' => 0x00051a05, # 0,5,26,5
  '7499U' => 0x00051902, # 0,5,25,2
  '7498C' => 0x07002d3e, # 7,0,45,62
  '7498U' => 0x05001433, # 5,0,20,51
  '7497C' => 0x00071e34, # 0,7,30,52
  '7497U' => 0x00040e2d, # 0,4,14,45
  '7496C' => 0x0d004f2f, # 13,0,79,47
  '7496U' => 0x0b002d30, # 11,0,45,48
  '7495C' => 0x07003b28, # 7,0,59,40
  '7495U' => 0x0800252c, # 8,0,37,44
  '7494C' => 0x0b00161f, # 11,0,22,31
  '7494U' => 0x0a00121f, # 10,0,18,31
  '7493C' => 0x05001a17, # 5,0,26,23
  '7493U' => 0x05001718, # 5,0,23,24
  '7492C' => 0x06002514, # 6,0,37,20
  '7492U' => 0x07002115, # 7,0,33,21
  '7491C' => 0x0a00372f, # 10,0,55,47
  '7491U' => 0x08001f2d, # 8,0,31,45
  '7490C' => 0x1a003428, # 26,0,52,40
  '7490U' => 0x16002026, # 22,0,32,38
  '7489C' => 0x20003521, # 32,0,53,33
  '7489U' => 0x1d002421, # 29,0,36,33
  '7488C' => 0x2c004110, # 44,0,65,16
  '7488U' => 0x34003912, # 52,0,57,18
  '7487C' => 0x2400360d, # 36,0,54,13
  '7487U' => 0x26002f0c, # 38,0,47,12
  '7486U' => 0x1300230b, # 19,0,35,11
  '7486C' => 0x1000220c, # 16,0,34,12
  '7485C' => 0x0600100d, # 6,0,16,13
  '7485U' => 0x0700100b, # 7,0,16,11
  '7484C' => 0x64001c42, # 100,0,28,66
  '7484U' => 0x25000d39, # 37,0,13,57
  '7483C' => 0x3a002840, # 58,0,40,64
  '7483U' => 0x1a001235, # 26,0,18,53
  '7482C' => 0x64003426, # 100,0,52,38
  '7482U' => 0x4d002123, # 77,0,33,35
  '7481C' => 0x6400391c, # 100,0,57,28
  '7481U' => 0x6400291b, # 100,0,41,27
  '7480C' => 0x64002a19, # 100,0,42,25
  '7480U' => 0x64002218, # 100,0,34,24
  '7479C' => 0x52002812, # 82,0,40,18
  '7479U' => 0x50002614, # 80,0,38,20
  '7478C' => 0x2000100b, # 32,0,16,11
  '7478U' => 0x20001008, # 32,0,16,8
  '7477C' => 0x3c100041, # 60,16,0,65
  '7477U' => 0x17070035, # 23,7,0,53
  '7476C' => 0x55060042, # 85,6,0,66
  '7476U' => 0x1b030034, # 27,3,0,52
  '7475C' => 0x2a010034, # 42,1,0,52
  '7475U' => 0x1801002d, # 24,1,0,45
  '7474C' => 0x64090031, # 100,9,0,49
  '7474U' => 0x3507002a, # 53,7,0,42
  '7473C' => 0x4b000a28, # 75,0,10,40
  '7473U' => 0x2b000723, # 43,0,7,35
  '7472C' => 0x3200031c, # 50,0,3,28
  '7472U' => 0x2b00021a, # 43,0,2,26
  '7471C' => 0x2b00050d, # 43,0,5,13
  '7471U' => 0x2c00040b, # 44,0,4,11
  '7470C' => 0x64130038, # 100,19,0,56
  '7470U' => 0x310f0031, # 49,15,0,49
  '7469C' => 0x641d002f, # 100,29,0,47
  '7469U' => 0x3814002e, # 56,20,0,46
  '7468C' => 0x64180028, # 100,24,0,40
  '7468U' => 0x3913002a, # 57,19,0,42
  '7467C' => 0x64060020, # 100,6,0,32
  '7467U' => 0x6405001f, # 100,5,0,31
  '7465C' => 0x43000b18, # 67,0,11,24
  '7465U' => 0x39000916, # 57,0,9,22
  '7464C' => 0x17000312, # 23,0,3,18
  '7464U' => 0x1600020e, # 22,0,2,14
  '7463C' => 0x64290047, # 100,41,0,71
  '7463U' => 0x23130033, # 35,19,0,51
  '7462C' => 0x6427002d, # 100,39,0,45
  '7462U' => 0x30190024, # 48,25,0,36
  '7461C' => 0x6421001b, # 100,33,0,27
  '7461U' => 0x421a0016, # 66,26,0,22
  '7460C' => 0x641e0019, # 100,30,0,25
  '7460U' => 0x641a0019, # 100,26,0,25
  '7459C' => 0x4010001d, # 64,16,0,29
  '7459U' => 0x34100021, # 52,16,0,33
  '7458C' => 0x2c0b0015, # 44,11,0,21
  '7458U' => 0x2e0e0019, # 46,14,0,25
  '7457C' => 0x1303000a, # 19,3,0,10
  '7457U' => 0x13040007, # 19,4,0,7
  '7456C' => 0x2e26001e, # 46,38,0,30
  '7456U' => 0x211d0019, # 33,29,0,25
  '7455C' => 0x432f0020, # 67,47,0,32
  '7455U' => 0x2a20001b, # 42,32,0,27
  '7454C' => 0x2f15001d, # 47,21,0,29
  '7454U' => 0x2512001b, # 37,18,0,27
  '7453C' => 0x2c19000d, # 44,25,0,13
  '7453U' => 0x2818000b, # 40,24,0,11
  '7452C' => 0x2a21000d, # 42,33,0,13
  '7452U' => 0x241e000b, # 36,30,0,11
  '7451C' => 0x2819000b, # 40,25,0,11
  '7451U' => 0x25180008, # 37,24,0,8
  '7450C' => 0x0e0a000e, # 14,10,0,14
  '7450U' => 0x0d09000c, # 13,9,0,12
  '7449C' => 0x0028094b, # 0,40,9,75
  '7449U' => 0x0012073d, # 0,18,7,61
  '7448C' => 0x011a0046, # 1,26,0,70
  '7448U' => 0x020a0037, # 2,10,0,55
  '7447C' => 0x16280035, # 22,40,0,53
  '7447U' => 0x0d15002b, # 13,21,0,43
  '7446C' => 0x20220015, # 32,34,0,21
  '7446U' => 0x1d1d0013, # 29,29,0,19
  '7445C' => 0x0e110018, # 14,17,0,24
  '7445U' => 0x0e100016, # 14,16,0,22
  '7444C' => 0x1110000e, # 17,16,0,14
  '7444U' => 0x1110000b, # 17,16,0,11
  '7443C' => 0x05060009, # 5,6,0,9
  '7443U' => 0x06080008, # 6,8,0,8
  '7443U' => 0x06080008, # 6,8,0,8
  '7442C' => 0x1544001a, # 21,68,0,26
  '7442U' => 0x11300019, # 17,48,0,25
  '7441C' => 0x11340019, # 17,52,0,25
  '7441U' => 0x0e260015, # 14,38,0,21
  '7440C' => 0x021c0023, # 2,28,0,35
  '7440U' => 0x0213001b, # 2,19,0,27
  '7439C' => 0x041a001b, # 4,26,0,27
  '7439U' => 0x03150016, # 3,21,0,22
  '7438C' => 0x011b0010, # 1,27,0,16
  '7438U' => 0x001c0010, # 0,28,0,16
  '7437C' => 0x02100012, # 2,16,0,18
  '7437U' => 0x010f0010, # 1,15,0,16
  '7436C' => 0x00080207, # 0,8,2,7
  '7436U' => 0x000c0205, # 0,12,2,5
  '7435C' => 0x0048282f, # 0,72,40,47
  '7435U' => 0x0027182d, # 0,39,24,45
  '7434C' => 0x00432b27, # 0,67,43,39
  '7434U' => 0x00271a22, # 0,39,26,34
  '7433C' => 0x00412823, # 0,65,40,35
  '7433U' => 0x00412823, # 0,65,40,35
  '7432C' => 0x00311d1d, # 0,49,29,29
  '7432U' => 0x00231617, # 0,35,22,23
  '7431C' => 0x00241515, # 0,36,21,21
  '7431U' => 0x001a100e, # 0,26,16,14
  '7430C' => 0x00170d0e, # 0,23,13,14
  '7430U' => 0x00150d0a, # 0,21,13,10
  '7429C' => 0x00110a0b, # 0,17,10,11
  '7429U' => 0x000e0907, # 0,14,9,7
  '7428C' => 0x003a2a3a, # 0,58,42,58
  '7428U' => 0x001c1432, # 0,28,20,50
  '7427C' => 0x00524529, # 0,82,69,41
  '7427U' => 0x00322c23, # 0,50,44,35
  '7426C' => 0x00593e24, # 0,89,62,36
  '7426U' => 0x0034281f, # 0,52,40,31
  '7425C' => 0x0050351d, # 0,80,53,29
  '7425U' => 0x0034271b, # 0,52,39,27
  '7424C' => 0x0045290b, # 0,69,41,11
  '7424U' => 0x003c2a0f, # 0,60,42,15
  '7423C' => 0x0038280c, # 0,56,40,12
  '7423U' => 0x0030250b, # 0,48,37,11
  '7422C' => 0x00100d04, # 0,16,13,4
  '7422U' => 0x00100e01, # 0,16,14,1
  '7421C' => 0x0048323c, # 0,72,50,60
  '7421U' => 0x00261b33, # 0,38,27,51
  '7420C' => 0x004e3927, # 0,78,57,39
  '7420U' => 0x002f2524, # 0,47,37,36
  '7419C' => 0x003a311f, # 0,58,49,31
  '7419U' => 0x003a311f, # 0,58,49,31
  '7418C' => 0x003b3814, # 0,59,56,20
  '7418U' => 0x00302f19, # 0,48,47,25
  '7417C' => 0x00414b0c, # 0,65,75,12
  '7417U' => 0x00363a09, # 0,54,58,9
  '7416C' => 0x00363f0a, # 0,54,63,10
  '7416U' => 0x00323708, # 0,50,55,8
  '7415C' => 0x00131b0a, # 0,19,27,10
  '7415U' => 0x00171e08, # 0,23,30,8
  '7414C' => 0x002c5818, # 0,44,88,24
  '7414U' => 0x00223919, # 0,34,57,25
  '7413C' => 0x00274d0e, # 0,39,77,14
  '7413U' => 0x00263c0d, # 0,38,60,13
  '7412C' => 0x00264b11, # 0,38,75,17
  '7412U' => 0x00213612, # 0,33,54,18
  '7411C' => 0x001c3c0a, # 0,28,60,10
  '7411U' => 0x001f3409, # 0,31,52,9
  '7410C' => 0x00203500, # 0,32,53,0
  '7410U' => 0x00253900, # 0,37,57,0
  '7409C' => 0x00195506, # 0,25,85,6
  '7409U' => 0x001e4403, # 0,30,68,3
  '7408C' => 0x00176404, # 0,23,100,4
  '7408U' => 0x00225407, # 0,34,84,7
  '7407C' => 0x00153c14, # 0,21,60,20
  '7407U' => 0x00142e14, # 0,20,46,20
  '7406C' => 0x00136405, # 0,19,100,5
  '7406U' => 0x00185305, # 0,24,83,5
  '7405C' => 0x000f6405, # 0,15,100,5
  '7405U' => 0x00175e0a, # 0,23,94,10
  '7404C' => 0x000b4a04, # 0,11,74,4
  '7404U' => 0x00124a01, # 0,18,74,1
  '7403C' => 0x000b2d07, # 0,11,45,7
  '7403U' => 0x000f2f04, # 0,15,47,4
  '7402C' => 0x00062207, # 0,6,34,7
  '7402U' => 0x000a2505, # 0,10,37,5
  '7401C' => 0x00082104, # 0,8,33,4
  '7401U' => 0x000a2300, # 0,10,35,0
  '5865U' => 0x00021b14, # 0,2,27,20
  '3252U' => 0x64000514, # 100,0,5,20
};


1;
# ABSTRACT: Pantone colors

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::Pantone - Pantone colors

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::Pantone (from Perl distribution Graphics-ColorNamesCMYK-Pantone), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-Pantone>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-Pantone>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-Pantone>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
