use Test::More qw(no_plan);

use Math::Cartesian::Product;

# 0

ok 0 == cartesian {};

# 3

 {my $a = '';
  
  ok 0 == cartesian {0}               [qw(a b c)];
  ok 1 == cartesian {shift() eq 'b'}  [qw(a b c)];
  ok 2 == cartesian {shift() ne 'b'}  [qw(a b c)];
  ok 3 == cartesian {$a .= "@_\n"; 1} [qw(a b c)];
  ok $a eq << "end";
a
b
c
end
 }

# 3*2

 {my $a = '';
  ok 6 == cartesian {$a .= "@_\n"; 1} [qw(a b c)], [1,2];
  ok $a eq << "end";
a 1
a 2
b 1
b 2
c 1
c 2
end
 }

# 3*2*0

 {my $a = '';
  
  ok 0 == cartesian {$a .= "@_\n"; 1} [qw(a b c)], [1,2], [];
  ok $a eq << "end";
end
 }


# 2*2*2*2

 {my $a = '';
  my $b = [qw(a b)];
  ok 16 == cartesian {$a .= "@_\n"; 1} $b,$b,$b,$b;
  ok $a eq << "end";
a a a a
a a a b
a a b a
a a b b
a b a a
a b a b
a b b a
a b b b
b a a a
b a a b
b a b a
b a b b
b b a a
b b a b
b b b a
b b b b
end
 }

# (2*2)*(2*2)

 {my $a = '';
  my $b = [qw(a b)];
  my $c = [cartesian {$a .= "@_\n"; 1} $b,$b];
  ok 4 == @$c;
  ok $a eq << "end";
a a
a b
b a
b b
end

  my $d = '';
  ok 16 == cartesian {$d .= "@_\n"; 1} $c, $c;
  ok $d eq << "end";
a a a a
a a a b
a a b a
a a b b
a b a a
a b a b
a b b a
a b b b
b a a a
b a a b
b a b a
b a b b
b b a a
b b a b
b b b a
b b b b
end

  ok 8 == cartesian {$_[1] eq 'a'} $c, $c;
 }

