package Daje::Workflow::Activities::Files::Save;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Workflow::Activities::Files::Save - It's a tool to save an array of files
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Activities::Files::Save;
#
#      "activity_data": {
#               "file" : {
#                 "target_dir_tag": "sql_target_dir",
#                 "filetype": ".sql",
#                 "file_list_tag": "sql"
#               }
#             }
#
#      Mandatory meta data
#
#      - file contains file name or name an path
#
#      - data content to write to disk
#
#
#      Possible meta data
#
#      - path if set to 1 the file tag contains full path
#
#      - new_only if set to 1 dont replace existing file
#
#      # Producer
#      for(Bla; Bla; Ble) {
#           if (my $sql = $self->_process_sql(@{$files_list}[$i])) {
#                 my $data->{data} = $sql;
#                 $data->{file} = Mojo::File->new(@{$files_list}[$i])->basename;
#                 $data->{file} =~ s/.json//g;
#                 push(@data, $data);
#           }
#       }
#
#      $self->context->{context}->{sql} = \@data;
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Activities::Files::Save is a file saver
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Mojo::File qw(path);;

our $VERSION = "1.11";

sub save($self) {

    $self->model->insert_history(
        "Save file(s)",
        "Daje::Workflow::Activities::Files::Save::save",
        1
    );

    try {
        my $files = $self->context->{context}->{payload}->{$self->activity_data->{file}->{file_list_tag}};
        my $length = scalar @{$files};
        for (my $i = 0; $i < $length; $i++) {
            my $file = "";
            if (exists @{$files}[$i]->{path} and @{$files}[$i]->{path} == 1) {
                $file = @{$files}[$i]->{file};
                $self->_make_dir($file);
            } else {
                my $filepath = $self->context->{context}->{payload}->{$self->activity_data->{file}->{target_dir_tag}};
                $file = $filepath . @{$files}[$i]->{file} . $self->activity_data->{file}->{filetype};
                $self->_make_dir($file);
            }
            if (exists @{$files}[$i]->{new_only} and @{$files}[$i]->{new_only} == 1) {
                if (!-e $file) {
                    $self->_save_file($file, @{$files}[$i]->{data});
                }
            } else {
                $self->_save_file($file, @{$files}[$i]->{data});
            }
        }
    } catch($e) {
        $self->error->add_error($e) ;
    };

    return;
}

sub _make_dir($self, $file) {
    my $file_name = path($file)->basename();
    my $path = $file;
    $path =~ s/$file_name//;
    my $result = path($path)->make_path();
    return $result;
}

sub _save_file($self, $file, $data) {
    open(my $fh, ">", $file);
    print $fh $data;
    close $fh;
}

1;
__END__








#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Activities::Files::Save - It's a tool to save an array of files



=head1 SYNOPSIS


    use Daje::Workflow::Activities::Files::Save;

     "activity_data": {
              "file" : {
                "target_dir_tag": "sql_target_dir",
                "filetype": ".sql",
                "file_list_tag": "sql"
              }
            }

     Mandatory meta data

=over

=item *
file contains file name or name an path

=back

=over

=item *
data content to write to disk

=back


     Possible meta data

=over

=item *
path if set to 1 the file tag contains full path

=back

=over

=item *
new_only if set to 1 dont replace existing file

=back

     # Producer
     for(Bla; Bla; Ble) {
          if (my $sql = $self->_process_sql(@{$files_list}[$i])) {
                my $data->{data} = $sql;
                $data->{file} = Mojo::File->new(@{$files_list}[$i])->basename;
                $data->{file} =~ s/.json//g;
                push(@data, $data);
          }
      }

     $self->context->{context}->{sql} = \@data;




=head1 DESCRIPTION


Daje::Workflow::Activities::Files::Save is a file saver



=head1 REQUIRES

L<Mojo::File> 

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 save($self)

 save($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

