use v6;

unit module Tomtit:ver<0.0.5>;
use File::Directory::Tree;

sub tomtit-usage () is export  {
  say "usage: tom --bootstrap|--last|--clean|run=scenario"
}

sub tomtit-help () is export  {
  say q:to/DOC/;
  usage:
    tom --bootstrap     # bootstrap system
    tom --list          # list of available scenarios
    tom --last          # what is the last run?
    tom --run=scenario  # run this scenario

  options:
    --verbose   # run scenarios in verbose mode
    --quiet     # run scenrios in less verbose mode
  DOC
}

# clean tomtit internal data
# is useful as with time it might grows

sub tomtit-clean ($dir) is export { 

  say "cleaning $dir/.cache ...";

  if "$dir/.cache/".IO ~~ :e {
    empty-directory "$dir/.cache"
  }

}

sub scenario-last ($dir) is export {
  if "$dir/.cache/history".IO ~~ :e {
    my @history =  "$dir/.cache/history".IO.lines;
    say @history[*-1];
  }
}

sub tomtit-bootstrap () is export {

  my $cmd = "sparrowdo --local_mode --bootstrap";

  shell($cmd);

}

sub scenario-run ($dir,$scenario,%args=()) is export {

  my $fh = open "$dir/.cache/history", :a;
  $fh.print($scenario,"\n");
  $fh.close;

  my $cmd = "sparrowdo --local_mode --no_sudo --sparrow_root=$dir/.cache --sparrowfile=$dir/$scenario.pl6";

  $cmd ~= " --format=production" if %args<quiet>;

  if %args<verbose> {
    $cmd ~= " --verbose";
    say "run $cmd ...";
  }

  shell($cmd);

}


sub scenario-list ($dir) is export {

    say "[scenarios list]";

    for dir($dir) -> $f {

      next unless "$f".IO ~~ :f;
      next unless $f ~~ /\.pl6$/;
      my $scenario-name = substr($f.basename,0,($f.basename.chars)-4);
      say "$scenario-name";

    }

}
