# Generated by default/object.tt
package Paws::AuditManager::ChangeLog;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', request_name => 'action', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has ObjectName => (is => 'ro', isa => 'Str', request_name => 'objectName', traits => ['NameInRequest']);
  has ObjectType => (is => 'ro', isa => 'Str', request_name => 'objectType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ChangeLog

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ChangeLog object:

  $service_obj->Method(Att1 => { Action => $value, ..., ObjectType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ChangeLog object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

The record of a change within AWS Audit Manager, such as a modified
assessment, a delegated control set, and so on.

=head1 ATTRIBUTES


=head2 Action => Str

The action performed.


=head2 CreatedAt => Str

The time of creation for the changelog object.


=head2 CreatedBy => Str

The IAM user or role that performed the action.


=head2 ObjectName => Str

The name of the changelog object.


=head2 ObjectType => Str

The changelog object type, such as an assessment, control, or control
set.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

