/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.NumberInstruction;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleTarget;
import net.sf.saxon.type.TypeHierarchy;

public class Optimizer {
    public static final int NO_OPTIMIZATION = 0;
    public static final int FULL_OPTIMIZATION = 10;
    protected Configuration config;
    private OptimizerOptions optimizerOptions = OptimizerOptions.FULL_EE_OPTIMIZATION;
    protected boolean tracing;

    public Optimizer(Configuration config) {
        this.config = config;
        this.tracing = config.getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions");
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setOptimizerOptions(OptimizerOptions options) {
        this.optimizerOptions = options;
    }

    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions;
    }

    public boolean isOptionSet(int option) {
        return this.optimizerOptions.isSet(option);
    }

    public Expression optimizeGeneralComparison(ExpressionVisitor visitor, GeneralComparison gc, boolean backwardsCompatible, ContextItemStaticInfo contextItemType) {
        return gc;
    }

    public Expression optimizeSaxonStreamFunction(ExpressionVisitor visitor, ContextItemStaticInfo cisi, Expression select) throws XPathException {
        if (select.getItemType().isPlainType()) {
            return select;
        }
        return null;
    }

    public Expression convertPathExpressionToKey(SlashExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand, boolean contextIsDoc) {
        return f;
    }

    public FilterExpression convertToFilterExpression(SlashExpression pathExp, TypeHierarchy th) throws XPathException {
        return null;
    }

    public int isIndexableFilter(Expression filter) {
        return 0;
    }

    public Sequence makeIndexedValue(SequenceIterator iter) throws XPathException {
        throw new UnsupportedOperationException("Indexing requires Saxon-EE");
    }

    public Sequence evaluateStreamingArgument(Expression expr, XPathContext context) throws XPathException {
        return ExpressionTool.eagerEvaluate(expr, context);
    }

    public boolean isVariableReplaceableByDot(Expression exp, Binding[] binding) {
        if (exp instanceof ContextSwitchingExpression) {
            Expression start = ((ContextSwitchingExpression)((Object)exp)).getSelectExpression();
            Expression step = ((ContextSwitchingExpression)((Object)exp)).getActionExpression();
            return this.isVariableReplaceableByDot(start, binding) && !ExpressionTool.dependsOnVariable(step, binding);
        }
        for (Operand o : exp.operands()) {
            if (this.isVariableReplaceableByDot(o.getChildExpression(), binding)) continue;
            return false;
        }
        return true;
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, SlashExpression path) throws XPathException {
        return sorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
        return functionCall;
    }

    public Expression promoteExpressionsToGlobal(Expression body, GlobalVariableManager gvManager, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression eliminateCommonSubexpressions(Expression in) {
        return in;
    }

    public Expression trySwitch(Choose choose, ExpressionVisitor visitor) {
        return choose;
    }

    public Expression tryGeneralComparison(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, OrExpression orExpr) throws XPathException {
        return orExpr;
    }

    public RuleTarget makeInversion(Pattern pattern, NamedTemplate template) throws XPathException {
        return null;
    }

    public void makeCopyOperationsExplicit(Expression parent, Operand child) throws XPathException {
    }

    public void checkStreamability(XSLTemplate sourceTemplate, TemplateRule compiledTemplate) throws XPathException {
    }

    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression expr) throws XPathException {
        return expr;
    }

    public Expression generateMultithreadedInstruction(Expression instruction) {
        return instruction;
    }

    public Expression compileToByteCode(ICompilerService compilerService, Expression expr, String objectName, int evaluationMethods) {
        return null;
    }

    public Expression makeByteCodeCandidate(ExpressionOwner owner, Expression expr, String objectName, int requiredEvaluationModes) {
        return null;
    }

    public void injectByteCodeCandidates(Expression exp) throws XPathException {
    }

    public Expression optimizeNumberInstruction(NumberInstruction ni, ContextItemStaticInfo contextInfo) {
        return null;
    }

    public void assessFunctionStreamability(XSLFunction sourceFunction, UserFunction compiledFunction) throws XPathException {
        throw new XPathException("Streamable stylesheet functions are not supported in Saxon-HE", "XTSE3430");
    }

    public void trace(String message, Expression exp) {
        if (this.tracing) {
            Logger err = this.getConfiguration().getLogger();
            err.info("OPT : At line " + exp.getLocation().getLineNumber() + " of " + exp.getLocation().getSystemId());
            err.info("OPT : " + message);
            err.info("OPT : Expression after rewrite: " + exp.toString());
        }
    }

    public static void trace(Configuration config, String message, Expression exp) {
        if (config.getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            Logger err = config.getLogger();
            err.info("OPT : At line " + exp.getLocation().getLineNumber() + " of " + exp.getLocation().getSystemId());
            err.info("OPT : " + message);
            err.info("OPT : Expression after rewrite: " + exp.toString());
        }
    }
}

