
package ZCS::Admin::Elements::AuthResponse;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:zimbraAdmin' }

__PACKAGE__->__set_name('AuthResponse');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %authToken_of :ATTR(:get<authToken>);
my %lifetime_of :ATTR(:get<lifetime>);
my %a_of :ATTR(:get<a>);
my %sessionId_of :ATTR(:get<sessionId>);

__PACKAGE__->_factory(
    [ qw(        authToken
        lifetime
        a
        sessionId

    ) ],
    {
        'authToken' => \%authToken_of,
        'lifetime' => \%lifetime_of,
        'a' => \%a_of,
        'sessionId' => \%sessionId_of,
    },
    {
        'authToken' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'lifetime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'a' => 'ZCS::Admin::Types::ItemAttribute',
        'sessionId' => 'ZCS::Admin::Types::sessionId',
    },
    {

        'authToken' => 'authToken',
        'lifetime' => 'lifetime',
        'a' => 'a',
        'sessionId' => 'sessionId',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Elements::AuthResponse

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
AuthResponse from the namespace urn:zimbraAdmin.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * authToken

 $element->set_authToken($data);
 $element->get_authToken();




=item * lifetime

 $element->set_lifetime($data);
 $element->get_lifetime();




=item * a

 $element->set_a($data);
 $element->get_a();




=item * sessionId

 $element->set_sessionId($data);
 $element->get_sessionId();





=back


=head1 METHODS

=head2 new

 my $element = ZCS::Admin::Elements::AuthResponse->new($data);

Constructor. The following data structure may be passed to new():

 {
   authToken =>  $some_value, # string
   lifetime =>  $some_value, # string
   a =>  { value => $some_value },
   sessionId =>  { value => $some_value },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

