/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZLanguagePack;
import java.util.HashMap;
import java.util.regex.Pattern;

public class TueBaDZHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private final String left;
    private String right;
    private boolean coordSwitch = false;
    private final Pattern headMarkedPattern;
    private final Pattern headMarkedPattern2;

    public TueBaDZHeadFinder() {
        super(new TueBaDZLanguagePack());
        String excluded = String.valueOf(this.tlp.labelAnnotationIntroducingCharacters());
        excluded = "-" + excluded.replaceAll("-", "");
        this.headMarkedPattern = Pattern.compile("^[^" + excluded + "]*:HD");
        this.headMarkedPattern2 = Pattern.compile("^[^" + excluded + "]*-HD");
        this.nonTerminalInfo = new HashMap();
        this.left = this.coordSwitch ? "right" : "left";
        this.right = this.coordSwitch ? "left" : "right";
        this.nonTerminalInfo.put("VROOT", new String[][]{{this.left, "SIMPX"}, {this.left, "NX"}, {this.left, "P"}, {this.left, "PX", "ADVX"}, {this.left, "EN", "EN_ADD", "ENADD"}, {this.left}});
        this.nonTerminalInfo.put("ROOT", new String[][]{{this.left, "SIMPX"}, {this.left, "NX"}, {this.left, "P"}, {this.left, "PX", "ADVX"}, {this.left, "EN", "EN_ADD", "ENADD"}, {this.left}});
        this.nonTerminalInfo.put("TOP", new String[][]{{this.left, "SIMPX"}, {this.left, "NX"}, {this.left, "P"}, {this.left, "PX", "ADVX"}, {this.left, "EN", "EN_ADD", "ENADD"}, {this.left}});
        this.nonTerminalInfo.put("PX", new String[][]{{this.left, "APPR", "APPRART", "PX"}});
        this.nonTerminalInfo.put("NX", new String[][]{{this.right, "NX"}, {this.right, "NE", "NN"}, {this.right, "EN", "EN_ADD", "ENADD", "FX"}, {this.right, "ADJX", "PIS", "ADVX"}, {this.right, "CARD", "TRUNC"}, {this.right}});
        this.nonTerminalInfo.put("FX", new String[][]{{this.right, "FM", "FX"}});
        this.nonTerminalInfo.put("ADJX", new String[][]{{this.right, "ADJX", "ADJA", "ADJD"}, {this.right}});
        this.nonTerminalInfo.put("ADVX", new String[][]{{this.right, "ADVX", "ADV"}});
        this.nonTerminalInfo.put("DP", new String[][]{{this.left}});
        this.nonTerminalInfo.put("VXFIN", new String[][]{{this.left, "VXFIN"}, {this.right, "VVFIN"}});
        this.nonTerminalInfo.put("VXINF", new String[][]{{this.right, "VXINF"}, {this.right, "VVPP", "VVINF"}});
        this.nonTerminalInfo.put("LV", new String[][]{{this.right}});
        this.nonTerminalInfo.put("C", new String[][]{{this.right, "KOUS"}, {this.right, "NX"}});
        this.nonTerminalInfo.put("FKOORD", new String[][]{{this.left, "LK", "C"}, {this.right, "FKONJ", "MF", "VC"}});
        this.nonTerminalInfo.put("KOORD", new String[][]{{this.left}});
        this.nonTerminalInfo.put("LK", new String[][]{{this.left}});
        this.nonTerminalInfo.put("MF", new String[][]{{this.left}});
        this.nonTerminalInfo.put("MFE", new String[][]{{this.left}});
        this.nonTerminalInfo.put("NF", new String[][]{{this.left}});
        this.nonTerminalInfo.put("PARORD", new String[][]{{this.left}});
        this.nonTerminalInfo.put("VC", new String[][]{{this.left, "VXINF"}});
        this.nonTerminalInfo.put("VF", new String[][]{{this.left, "NX", "ADJX", "PX", "ADVX", "EN", "SIMPX"}});
        this.nonTerminalInfo.put("FKONJ", new String[][]{{this.left, "LK"}, {this.right, "VC"}, {this.left, "MF", "NF", "VF"}});
        this.nonTerminalInfo.put("DM", new String[][]{{this.left, "PTKANT"}, {this.left, "ITJ"}, {this.left, "KON", "FM"}, {this.left}});
        this.nonTerminalInfo.put("P", new String[][]{{this.left, "SIMPX"}, {this.left}});
        this.nonTerminalInfo.put("PSIMPX", new String[][]{{this.left, "SIMPX"}, {this.left}});
        this.nonTerminalInfo.put("R", new String[][]{{this.left, "C"}, {this.left, "R"}, {this.right, "VC"}});
        this.nonTerminalInfo.put("RSIMPX", new String[][]{{this.left, "C"}, {this.left, "RSIMPX"}, {this.right, "VC"}});
        this.nonTerminalInfo.put("SIMPX", new String[][]{{this.left, "LK"}, {this.right, "VC"}, {this.left, "SIMPX"}, {this.left, "C"}, {this.right, "FKOORD"}, {this.right, "MF"}, {this.right}});
        this.nonTerminalInfo.put("EN", new String[][]{{this.left, "NX"}});
        this.nonTerminalInfo.put("EN_ADD", new String[][]{{this.left, "NX"}, {this.left, "VXINF"}});
        this.nonTerminalInfo.put("ENADD", new String[][]{{this.left, "NX"}, {this.left, "VXINF"}});
    }

    protected Tree findMarkedHead(Tree t) {
        Tree[] kids = t.children();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            if (!this.headMarkedPattern.matcher(kids[i].label().value()).find() && !this.headMarkedPattern2.matcher(kids[i].label().value()).find()) continue;
            return kids[i];
        }
        return null;
    }

    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        return category.substring(0, this.postBasicCategoryIndex(category));
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        char seenAtZero = '\u0000';
        int leng = category.length();
        for (i = 0; i < leng; ++i) {
            char ch = category.charAt(i);
            if (!this.isLabelAnnotationIntroducingCharacter(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    public boolean isLabelAnnotationIntroducingCharacter(char ch) {
        if (this.tlp.isLabelAnnotationIntroducingCharacter(ch)) {
            return true;
        }
        return ch == '-';
    }

    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        Tree theHead = null;
        String motherCat = this.basicCategory(t.label().value());
        String[][] how = (String[][])this.nonTerminalInfo.get(motherCat);
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(t.children(), this.defaultRule, true);
            }
            return null;
        }
        for (int i = 0; i < how.length; ++i) {
            boolean deflt = i == how.length - 1;
            theHead = this.traverseLocate(t.children(), how[i], deflt);
            if (theHead != null) break;
        }
        return theHead;
    }
}

