[![Actions Status](https://github.com/sanko/Acme-Insult-Glax/actions/workflows/ci.yml/badge.svg)](https://github.com/sanko/Acme-Insult-Glax/actions) [![MetaCPAN Release](https://badge.fury.io/pl/Acme-Insult-Glax.svg)](https://metacpan.org/release/Acme-Insult-Glax)
# NAME

Acme::Insult::Glax - Programmatically Generate Insults

# SYNOPSIS

```perl
use Acme::Insult::Glax qw[insult];
say insult( );
```

# DESCRIPTION

Acme::Insult::Glax provides 'insulting' statements generated by the RESTful libInsult API.

# METHODS

These functions may be imported by name or with the `:all` tag.

## `insult( [...] )`

Tear someone down.

```perl
my $shade = insult( ); # Random insult
print insult( lang => 'en_corporate', who => 'John and Eric', plural => 1 );
print insult( lang => 'en_corporate', who => 'John' );
print insult( lang => 'en_corporate', who => 'John' );
```

You may request specific insults by passing parameters.

Expected parameters include:

- `lang`

    Insult's language style. Expected styles include:

    - `en`

        Plain English. This is the default.

    - `en_corporate`

        English with corporate jargon inserted. Perfect for the 4:50p work email.

- `template`

    Insult template.

    The default value is different depending on the parameters passed to the API:

    - `lang => 'en'`

        ```
        You are as <adjective> as <article target=adj1> <adjective min=1 max=3 id=adj1> <amount> of <adjective min=1 max=3> <animal> <animal_part>
        ```

    - `lang => 'en', who => 'Alex'`

        ```
        Alex is as <adjective> as <article target=adj1> <adjective min=1 max=3 id=adj1> <amount> of <adjective min=1 max=3> <animal> <animal_part>
        ```

    - `lang => 'en', plural => 1`

        ```
        You are as <adjective> as <article target=adj1> <adjective min=1 max=3 id=adj1> <amount> of <adjective min=1 max=3> <animal> <animal_part>
        ```

    - `en_corporate`

        ```
        We <adverb> <verb> <adjective min=1 max=3> <noun>
        ```

    - `lang => 'en_corporate', who => 'Alex'`

        ```
        Alex <adverb> <verb id=verb><verb_3rd target=verb> <adjective min=1 max=3> <noun>
        ```

    - `lang => 'en_corporate', plural => 1`

        ```
        We <adverb> <verb> <adjective min=1 max=3> <noun>"
        ```

    A few examples might be...

    ```
    John and Eric <adverb> <verb id=verb><verb_3rd target=verb> <adjective min=1 max=3> <noun>
    # John and Eric proactively facilitates cutting-edge elastic products

    John and Eric are as <adjective> as <article target=adj1> <adjective min=1 max=3 id=adj1> <amount> of <adjective min=1 max=3> <animal> <animal_part>
    # John and Eric is as disgusting as an unsatisfactory mass of stinky revolting boring maggot toes
    ```

    These are undocumented but from my tinkering, I've figured out that templates can accept the following pseudo-XML tags:

    - `<article>`

        Properly fills in a/an depending on what follows it.

        You may target another field by its id.

        ```
        ... <article target='adj1' /> <adjective id='adj1' max='3' /> ...
        ```

    - `<adverb>`
    - `<adjective>`

        ```
        <adjective min=1 max=3 id=adj1>
        ```

    - `<amount>`
    - `<animal>`
    - `<animal_part>`
    - `<noun>`
    - `<verb>`

        Inserts an action or activity.

    Be aware that some of these are unsupported when the language is set to `en_corporate`.

- `who`

    Person to insult. If present, changes the template to third person singular.

- `plural`

    If present (along with a `who` value), changes the template to third person plural.

## `adjective( [...] )`

```perl
my $adjective0 = adjective( );
my $adjective1 = adjective( 'en' );
my $adjective2 = adjective( 'en_corporate' );
```

Generates a single descriptive adjective in plain text.

Expected parameters include:

- `lang`

    Language style. Expected values include:

    - `en`

        Plain English. This is the default.

    - `en_corporate`

        English with corporate jargon inserted.

# LICENSE & LEGAL

Copyright (C) Sanko Robinson.

This library is free software; you can redistribute it and/or modify it under the terms found in the Artistic License
2\. Other copyrights, terms, and conditions may apply to data transmitted through this module.

Insults are generated by [libInsult](https://gitlab.com/mattia.basaglia/LibInsult) which is maintained by [Mattia
"Glax" Basaglia](https://mattbas.org/).

# AUTHOR

Sanko Robinson <sanko@cpan.org>

## ...but why?

I'm inflicting this upon the world because [oodler577](https://github.com/oodler577/) invited me to help expand Perl's
coverage of smaller open APIs. Blame them or [join us](https://github.com/oodler577/FreePublicPerlAPIs) in the effort.
