use strict;
use warnings;
use Test::More;
use MyNote;
use MyTmpTimer;
BEGIN { use_ok 'UUID' }

my $n = 100;
my %seen = ();

my $fh = tmptimer( $n, sub {
    my ($n, $fh) = @_;
    my ($bin, $str);
    for (1 .. $n) {
        UUID::generate_v7($bin);
        UUID::unparse($bin, $str);
        print $fh $str. "\n";
    }
});

while (my $str = <$fh>) {
    chomp $str;
    ok !exists($seen{$str}), $str;
    $seen{$str} = 1;
}

is scalar(keys %seen), $n, 'no dupes';

done_testing;
